/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.webflow;

import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.jahia.tools.files.FileUpload;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.commons.CommonsFileUploadSupport;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class MultipartResolver
extends CommonsMultipartResolver {
    protected CommonsFileUploadSupport.MultipartParsingResult parseRequest(HttpServletRequest request) throws MultipartException {
        FileUpload fileUpload = (FileUpload)request.getAttribute("fileUpload");
        ArrayList<DiskFileItem> fileItems = new ArrayList<DiskFileItem>(fileUpload.getFileItems().values());
        LinkedMultiValueMap multipartFiles = new LinkedMultiValueMap();
        HashMap<String, String> multipartParameterContentTypes = new HashMap<String, String>();
        for (FileItem fileItem : fileItems) {
            CommonsMultipartFile file = new CommonsMultipartFile(fileItem);
            multipartFiles.add((Object)fileItem.getFieldName(), (Object)file);
        }
        HashMap<String, String[]> multipartParameters = new HashMap<String, String[]>();
        for (String param : fileUpload.getParameterNames()) {
            if (request.getQueryString().contains("&" + param + "=") || request.getQueryString().startsWith(param + "=")) continue;
            multipartParameters.put(param, fileUpload.getParameterValues(param));
            multipartParameterContentTypes.put(param, fileUpload.getParameterContentType(param));
        }
        return new CommonsFileUploadSupport.MultipartParsingResult((MultiValueMap)multipartFiles, multipartParameters, multipartParameterContentTypes);
    }
}

