/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.search.analyzer;

import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.ASCIIFoldingFilter;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.KeywordMarkerFilter;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;
import org.tartarus.snowball.SnowballProgram;
import org.tartarus.snowball.ext.German2Stemmer;

public class GermanSnowballAnalyzer
extends StopwordAnalyzerBase {
    private final Set<?> exclusionSet;

    public static final Set<?> getDefaultStopSet() {
        return GermanAnalyzer.getDefaultStopSet();
    }

    public GermanSnowballAnalyzer(Version matchVersion) {
        this(matchVersion, GermanAnalyzer.getDefaultStopSet());
    }

    public GermanSnowballAnalyzer(Version matchVersion, Set<?> stopwords) {
        this(matchVersion, stopwords, (Set<?>)CharArraySet.EMPTY_SET);
    }

    public GermanSnowballAnalyzer(Version matchVersion, Set<?> stopwords, Set<?> stemExclusionSet) {
        super(matchVersion, stopwords);
        this.exclusionSet = CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy((Version)matchVersion, stemExclusionSet));
    }

    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        StandardTokenizer source = new StandardTokenizer(this.matchVersion, reader);
        StandardFilter result = new StandardFilter(this.matchVersion, (TokenStream)source);
        result = new LowerCaseFilter(this.matchVersion, (TokenStream)result);
        result = new StopFilter(this.matchVersion, (TokenStream)result, (Set)this.stopwords);
        result = new KeywordMarkerFilter((TokenStream)result, this.exclusionSet);
        result = new SnowballFilter((TokenStream)result, (SnowballProgram)new German2Stemmer());
        result = new ASCIIFoldingFilter((TokenStream)result);
        return new ReusableAnalyzerBase.TokenStreamComponents((Tokenizer)source, (TokenStream)result);
    }
}

