/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.search.jcr;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.query.lucene.AbstractExcerpt;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.TermFactory;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermPositionVector;
import org.jahia.osgi.BundleUtils;
import org.jahia.services.search.jcr.ExcerptProcessor;
import org.jahia.services.search.jcr.JahiaExcerptProvider;
import org.jahia.services.search.jcr.JahiaHighlighter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTMLExcerpt
extends AbstractExcerpt {
    private static final Logger log = LoggerFactory.getLogger(HTMLExcerpt.class);
    private static final Pattern APOS = Pattern.compile("&apos;");
    private ExcerptProcessor excerptProcessor;
    private boolean lookForExcerptProcessor = true;
    public static final FieldSelector FULLTEXT = new FieldSelector(){

        public FieldSelectorResult accept(String fieldName) {
            if (FieldNames.FULLTEXT == fieldName) {
                return FieldSelectorResult.LOAD;
            }
            return FieldSelectorResult.NO_LOAD;
        }
    };

    protected String createExcerpt(TermPositionVector tpv, String text, int maxFragments, int maxFragmentSize) throws IOException {
        if (this.lookForExcerptProcessor) {
            this.excerptProcessor = BundleUtils.getOsgiService(ExcerptProcessor.class, null);
            this.lookForExcerptProcessor = false;
        }
        if (this.excerptProcessor != null) {
            return this.excerptProcessor.handleText(tpv, text, this.getQueryTerms(), maxFragments, maxFragmentSize);
        }
        return JahiaHighlighter.highlight(tpv, this.getQueryTerms(), text, "<div>", "</div>", "...", " ", "<span class=\"searchHighlightedText\">", "</span>", maxFragments, maxFragmentSize / 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExcerpt(NodeId id, int maxFragments, int maxFragmentSize) throws IOException {
        IndexReader reader = this.index.getIndexReader();
        try {
            Document doc;
            block12: {
                Term idTerm = TermFactory.createUUIDTerm((String)id.toString());
                try (TermDocs tDocs = reader.termDocs(idTerm);){
                    if (tDocs.next()) {
                        int docNumber = tDocs.doc();
                        doc = reader.document(docNumber, FULLTEXT);
                        break block12;
                    }
                    String string = null;
                    return string;
                }
            }
            Fieldable[] fields = doc.getFieldables(FieldNames.FULLTEXT);
            if (fields.length == 0) {
                log.debug("Fulltext field not stored, using {}", (Object)JahiaExcerptProvider.class.getName());
                JahiaExcerptProvider exProvider = new JahiaExcerptProvider();
                exProvider.init(this.query, this.index);
                String string = exProvider.getExcerpt(id, maxFragments, maxFragmentSize);
                return string;
            }
            String excerpt = super.getExcerpt(id, maxFragments, maxFragmentSize);
            if (excerpt != null) {
                String string = APOS.matcher(excerpt).replaceAll("&#39;");
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            Util.closeOrRelease((IndexReader)reader);
        }
    }
}

