/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.sites;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jahia.services.usermanager.JahiaUser;
import org.springframework.core.io.Resource;

public class SiteCreationInfo {
    private String description;
    private Resource fileImport;
    private String fileImportName;
    private String firstImport;
    private Resource legacyDefinitionsFilePath;
    private Resource legacyMappingFilePath;
    private String locale;
    private String[] modulesToDeploy;
    private String originatingJahiaRelease;
    private String serverName;
    private String[] serverNameAliases;
    private JahiaUser siteAdmin;
    private String siteKey;
    private String templateSet;
    private String title;

    public static Builder builder() {
        return new Builder();
    }

    public SiteCreationInfo() {
    }

    public SiteCreationInfo(String siteKey, String serverName, String serverNameAliasesAsString, String title, String description, String templateSet, String[] modulesToDeploy, String locale, JahiaUser siteAdmin, String firstImport, Resource fileImport, String fileImportName, String originatingJahiaRelease, Resource legacyMappingFilePath, Resource legacyDefinitionsFilePath) {
        this();
        this.siteKey = siteKey;
        this.serverName = serverName;
        this.setServerNameAliasesAsString(serverNameAliasesAsString);
        this.title = title;
        this.description = description;
        this.templateSet = templateSet;
        this.modulesToDeploy = modulesToDeploy;
        this.locale = locale;
        this.siteAdmin = siteAdmin;
        this.fileImport = fileImport;
        this.fileImportName = fileImportName;
        this.firstImport = firstImport;
        this.originatingJahiaRelease = originatingJahiaRelease;
        this.legacyDefinitionsFilePath = legacyDefinitionsFilePath;
        this.legacyMappingFilePath = legacyMappingFilePath;
    }

    public String getDescription() {
        return this.description;
    }

    public Resource getFileImport() {
        return this.fileImport;
    }

    public String getFileImportName() {
        return this.fileImportName;
    }

    public String getFirstImport() {
        return this.firstImport;
    }

    public Resource getLegacyDefinitionsFilePath() {
        return this.legacyDefinitionsFilePath;
    }

    public Resource getLegacyMappingFilePath() {
        return this.legacyMappingFilePath;
    }

    public String getLocale() {
        return this.locale;
    }

    public String[] getModulesToDeploy() {
        return this.modulesToDeploy;
    }

    public String getOriginatingJahiaRelease() {
        return this.originatingJahiaRelease;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String[] getServerNameAliases() {
        return this.serverNameAliases;
    }

    public JahiaUser getSiteAdmin() {
        return this.siteAdmin;
    }

    public String getSiteKey() {
        return this.siteKey;
    }

    public String getTemplateSet() {
        return this.templateSet;
    }

    public String getTitle() {
        return this.title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFileImport(Resource fileImport) {
        this.fileImport = fileImport;
    }

    public void setFileImportName(String fileImportName) {
        this.fileImportName = fileImportName;
    }

    public void setFirstImport(String firstImport) {
        this.firstImport = firstImport;
    }

    public void setLegacyDefinitionsFilePath(Resource legacyDefinitionsFilePath) {
        this.legacyDefinitionsFilePath = legacyDefinitionsFilePath;
    }

    public void setLegacyMappingFilePath(Resource legacyMappingFilePath) {
        this.legacyMappingFilePath = legacyMappingFilePath;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setModulesToDeploy(String[] modulesToDeploy) {
        this.modulesToDeploy = modulesToDeploy;
    }

    public void setOriginatingJahiaRelease(String originatingJahiaRelease) {
        this.originatingJahiaRelease = originatingJahiaRelease;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setServerNameAliases(String[] serverNameAliases) {
        this.serverNameAliases = serverNameAliases;
    }

    public void setServerNameAliasesAsString(String serverNameAliases) {
        this.serverNameAliases = StringUtils.isNotEmpty((String)serverNameAliases) ? StringUtils.split((String)serverNameAliases, (String)", ") : null;
    }

    public void setSiteAdmin(JahiaUser siteAdmin) {
        this.siteAdmin = siteAdmin;
    }

    public void setSiteKey(String siteKey) {
        this.siteKey = siteKey;
    }

    public void setTemplateSet(String templateSet) {
        this.templateSet = templateSet;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static class Builder {
        private SiteCreationInfo site = new SiteCreationInfo();

        private Builder() {
        }

        public SiteCreationInfo build() {
            return this.site;
        }

        public Builder description(String description) {
            this.site.setDescription(description);
            return this;
        }

        public Builder fileImport(Resource fileImport) {
            this.site.setFileImport(fileImport);
            return this;
        }

        public Builder fileImportName(String fileImportName) {
            this.site.setFileImportName(fileImportName);
            return this;
        }

        public Builder firstImport(String firstImport) {
            this.site.setFirstImport(firstImport);
            return this;
        }

        public Builder legacyDefinitionsFilePath(Resource legacyDefinitionsFilePath) {
            this.site.setLegacyDefinitionsFilePath(legacyDefinitionsFilePath);
            return this;
        }

        public Builder legacyMappingFilePath(Resource legacyMappingFilePath) {
            this.site.setLegacyMappingFilePath(legacyMappingFilePath);
            return this;
        }

        public Builder locale(String locale) {
            this.site.setLocale(locale);
            return this;
        }

        public Builder modulesToDeploy(String[] modulesToDeploy) {
            this.site.setModulesToDeploy(modulesToDeploy);
            return this;
        }

        public Builder originatingJahiaRelease(String originatingJahiaRelease) {
            this.site.setOriginatingJahiaRelease(originatingJahiaRelease);
            return this;
        }

        public Builder serverName(String serverName) {
            this.site.setServerName(serverName);
            return this;
        }

        public Builder serverNameAliases(String serverNameAliases) {
            this.site.setServerNameAliasesAsString(serverNameAliases);
            return this;
        }

        public Builder siteAdmin(JahiaUser siteAdmin) {
            this.site.setSiteAdmin(siteAdmin);
            return this;
        }

        public Builder siteKey(String siteKey) {
            this.site.setSiteKey(siteKey);
            return this;
        }

        public Builder templateSet(String templateSet) {
            this.site.setTemplateSet(templateSet);
            return this;
        }

        public Builder title(String title) {
            this.site.setTitle(title);
            return this;
        }
    }
}

