/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.tags;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Source;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.response.FacetField;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.query.QOMBuilder;
import org.jahia.services.query.QueryResultWrapper;
import org.jahia.services.query.ScrollableQuery;
import org.jahia.services.query.ScrollableQueryCallback;
import org.jahia.services.tags.TaggingService;
import org.jahia.services.tags.TagsSuggester;

public class TagsSuggesterImpl
implements TagsSuggester {
    private boolean faceted = false;

    @Override
    public Map<String, Long> suggest(String prefix, String startPath, Long mincount, Long limit, Long offset, boolean sortByCount, JCRSessionWrapper sessionWrapper) throws RepositoryException {
        String converterdInput = TaggingService.getInstance().getTagHandler().execute(prefix);
        if (this.faceted) {
            return this.facetedSuggestion(converterdInput, startPath, mincount, limit, offset, sortByCount, sessionWrapper);
        }
        return this.simpleSuggestion(converterdInput, startPath, limit, sessionWrapper);
    }

    protected Map<String, Long> facetedSuggestion(String prefix, String startPath, Long mincount, Long limit, Long offset, boolean sortByCount, JCRSessionWrapper sessionWrapper) throws RepositoryException {
        LinkedHashMap<String, Long> tagsMap = new LinkedHashMap<String, Long>();
        QueryManagerWrapper queryManager = sessionWrapper.getWorkspace().getQueryManager();
        String searchPath = StringUtils.isEmpty((String)startPath) ? "/sites" : JCRContentUtils.sqlEncode(startPath);
        StringBuilder facet = new StringBuilder();
        facet.append("rep:facet(nodetype=jmix:tagged&key=j:tagList").append(mincount != null ? "&facet.mincount=" + mincount.toString() : "").append(limit != null ? "&facet.limit=" + limit.toString() : "").append(offset != null ? "&facet.offset=" + offset.toString() : "").append("&facet.sort=").append(String.valueOf(sortByCount)).append(StringUtils.isNotEmpty((String)prefix) ? "&facet.prefix=" + prefix : "").append(")");
        QueryObjectModelFactory factory = queryManager.getQOMFactory();
        QOMBuilder qomBuilder = new QOMBuilder(factory, sessionWrapper.getValueFactory());
        qomBuilder.setSource((Source)factory.selector("jmix:tagged", "tagged"));
        qomBuilder.andConstraint((Constraint)factory.descendantNode("tagged", searchPath));
        qomBuilder.getColumns().add(factory.column("tagged", "j:tagList", facet.toString()));
        QueryObjectModel qom = qomBuilder.createQOM();
        QueryResultWrapper res = (QueryResultWrapper)qom.execute();
        if (res.getFacetField("j:tagList").getValues() != null) {
            for (FacetField.Count count : res.getFacetField("j:tagList").getValues()) {
                tagsMap.put(count.getName(), count.getCount());
            }
        }
        return tagsMap;
    }

    protected Map<String, Long> simpleSuggestion(final String prefix, String startPath, final Long limit, JCRSessionWrapper sessionWrapper) throws RepositoryException {
        if (StringUtils.isEmpty((String)prefix.trim())) {
            return new HashMap<String, Long>();
        }
        QueryManagerWrapper queryManager = sessionWrapper.getWorkspace().getQueryManager();
        String searchPath = StringUtils.isEmpty((String)startPath) ? "/sites" : JCRContentUtils.sqlEncode(startPath);
        Query query = queryManager.createQuery("select t.[j:tagList] from [jmix:tagged] as t where isdescendantnode(t, [" + searchPath + "]) and t.[j:tagList] like '" + JCRContentUtils.sqlEncode(prefix) + "%'", "JCR-SQL2");
        ScrollableQuery scrollableQuery = new ScrollableQuery(100L, 100L, query);
        return scrollableQuery.execute(new ScrollableQueryCallback<Map<String, Long>>(){
            Map<String, Long> result = new LinkedHashMap<String, Long>();

            @Override
            public boolean scroll() throws RepositoryException {
                boolean limitReached;
                NodeIterator nodeIterator = this.stepResult.getNodes();
                boolean bl = limitReached = limit != null && (long)this.result.keySet().size() == limit;
                block0: while (!limitReached && nodeIterator.hasNext()) {
                    JCRValueWrapper[] tags;
                    JCRNodeWrapper nodeWrapper = (JCRNodeWrapper)nodeIterator.next();
                    for (JCRValueWrapper tag : tags = nodeWrapper.getProperty("j:tagList").getValues()) {
                        String tagValue = tag.getString();
                        if (!tagValue.startsWith(prefix)) continue;
                        if (limit == null || limit <= 0L || (long)this.result.keySet().size() < limit) {
                            this.result.put(tagValue, 0L);
                            continue;
                        }
                        limitReached = true;
                        continue block0;
                    }
                }
                return !limitReached;
            }

            @Override
            protected Map<String, Long> getResult() {
                return this.result;
            }
        });
    }

    public void setFaceted(boolean faceted) {
        this.faceted = faceted;
    }
}

