/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.templates;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import org.apache.commons.lang.StringUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.util.Timeout;
import org.apache.maven.model.Model;
import org.apache.xerces.impl.dv.util.Base64;
import org.jahia.data.templates.ModuleReleaseInfo;
import org.jahia.services.notification.HttpClientService;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ForgeHelper {
    private static Logger logger = LoggerFactory.getLogger(ForgeHelper.class);
    private HttpClientService httpClientService;

    ForgeHelper() {
    }

    String createForgeModule(ModuleReleaseInfo releaseInfo, File jar) throws IOException {
        String moduleUrl = null;
        String url = releaseInfo.getForgeUrl();
        CloseableHttpClient client = this.httpClientService.getHttpClient(url);
        HttpGet getMethod = new HttpGet(url + "/home.html");
        getMethod.addHeader("Authorization", (Object)("Basic " + Base64.encode((byte[])(releaseInfo.getUsername() + ":" + releaseInfo.getPassword()).getBytes())));
        String token = this.getToken(client, getMethod);
        HttpEntity entity = MultipartEntityBuilder.create().addTextBody("form-token", token).addBinaryBody("file", jar).build();
        HttpPost postMethod = new HttpPost(url + "/contents/modules-repository.createModuleFromJar.do");
        postMethod.setConfig(this.httpClientService.getRequestConfigBuilder((HttpClient)client).setResponseTimeout(Timeout.DISABLED).build());
        postMethod.addHeader("Authorization", (Object)("Basic " + Base64.encode((byte[])(releaseInfo.getUsername() + ":" + releaseInfo.getPassword()).getBytes())));
        postMethod.addHeader("accept", (Object)"application/json");
        postMethod.setEntity(entity);
        String result = null;
        try (CloseableHttpResponse response = client.execute((ClassicHttpRequest)postMethod);){
            if (response.getCode() == 200) {
                result = EntityUtils.toString((HttpEntity)response.getEntity());
            } else {
                logger.warn("Connection to URL: {} failed with status {}", (Object)url, (Object)response.getCode());
            }
        }
        catch (IOException | ParseException e) {
            logger.error("Unable to get the content of the URL: {}. Cause: {}", new Object[]{url, e.getMessage(), e});
        }
        if (StringUtils.isNotEmpty((String)result)) {
            try {
                JSONObject json = new JSONObject(result);
                if (json.isNull("moduleAbsoluteUrl")) {
                    if (!json.isNull("error")) {
                        throw new IOException(json.getString("error"));
                    }
                    logger.warn("Cannot find 'moduleAbsoluteUrl' entry in the create module actin response: {}", (Object)result);
                    throw new IOException("unknown");
                }
                moduleUrl = json.getString("moduleAbsoluteUrl");
            }
            catch (JSONException e) {
                logger.error("Unable to parse the response of the module creation action. Cause: " + e.getMessage(), (Throwable)e);
            }
        }
        return moduleUrl;
    }

    private String getToken(CloseableHttpClient client, HttpGet getMethod) throws IOException {
        String token;
        block16: {
            token = "";
            try (CloseableHttpResponse response = client.execute((ClassicHttpRequest)getMethod);){
                Source source = new Source((CharSequence)EntityUtils.toString((HttpEntity)response.getEntity()));
                if (source.getFirstElementByClass("file_upload") != null) {
                    List els = source.getFirstElementByClass("file_upload").getAllElements("input");
                    for (Element el : els) {
                        if (!StringUtils.equals((String)el.getAttributeValue("name"), (String)"form-token")) continue;
                        token = el.getAttributeValue("value");
                    }
                    break block16;
                }
                throw new IOException("Unable to get Private App Store site information, please check your credentials");
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
        return token;
    }

    String computeModuleJarUrl(String releaseVersion, ModuleReleaseInfo releaseInfo, Model model) {
        String groupId;
        StringBuilder url = new StringBuilder(64);
        url.append(releaseInfo.getRepositoryUrl());
        if (!releaseInfo.getRepositoryUrl().endsWith("/")) {
            url.append("/");
        }
        if ((groupId = model.getGroupId()) == null && model.getParent() != null) {
            groupId = model.getParent().getGroupId();
        }
        url.append(StringUtils.replace((String)groupId, (String)".", (String)"/"));
        url.append("/");
        url.append(model.getArtifactId());
        url.append("/");
        url.append(releaseVersion);
        url.append("/");
        url.append(model.getArtifactId());
        url.append("-");
        url.append(releaseVersion);
        url.append(".");
        String packaging = model.getPackaging();
        url.append(packaging == null || packaging.equals("bundle") ? "jar" : packaging);
        return url.toString();
    }

    public void setHttpClientService(HttpClientService httpClientService) {
        this.httpClientService = httpClientService;
    }
}

