/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.textextraction;

import java.io.Writer;
import javax.jcr.RepositoryException;
import org.drools.core.util.StringUtils;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.textextraction.ExtractionCheckStatus;
import org.jahia.services.textextraction.RepositoryFileFilter;
import org.jahia.services.textextraction.TextExtractionChecker;
import org.jahia.tools.OutWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TextExtractionHelper {
    private static final Logger logger = LoggerFactory.getLogger(TextExtractionHelper.class);
    private static final String CHECKING = "checking";
    private static final String FIXING = "fixing";
    private static final String REDOING = "redoing";
    private static boolean checkingExtractions;
    private static TextExtractionChecker extractionChecker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ExtractionCheckStatus checkMissingExtraction(boolean fixMissingExtraction, Writer statusOut) throws RepositoryException {
        if (checkingExtractions) {
            throw new IllegalStateException("The process fpr checking extractions is currently running. Cannot start the second process.");
        }
        checkingExtractions = true;
        long timer = System.currentTimeMillis();
        ExtractionCheckStatus status = new ExtractionCheckStatus();
        OutWrapper out = new OutWrapper(logger, statusOut);
        out.echo("Start {} missing extraction ", fixMissingExtraction ? FIXING : CHECKING);
        extractionChecker = new TextExtractionChecker(status, fixMissingExtraction, out);
        try {
            JCRCallback<Object> callback = new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    extractionChecker.perform(session);
                    return null;
                }
            };
            out.echo("Missing extractions in DEFAULT workspace for: ");
            JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, "default", null, callback);
            if (status.extractable == 0L) {
                out.echo("none");
            }
            long extractableInDefault = status.extractable;
            out.echo("\nMissing extractions in LIVE workspace for: ");
            JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, "live", null, callback);
            if (status.extractable == extractableInDefault) {
                out.echo("none");
            }
            checkingExtractions = false;
        }
        catch (Throwable throwable) {
            checkingExtractions = false;
            logger.info("Done {} text extractions in {} ms. Status: {}", new Object[]{fixMissingExtraction ? FIXING : CHECKING, System.currentTimeMillis() - timer, status});
            throw throwable;
        }
        logger.info("Done {} text extractions in {} ms. Status: {}", new Object[]{fixMissingExtraction ? FIXING : CHECKING, System.currentTimeMillis() - timer, status});
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ExtractionCheckStatus checkExtractionByFilter(boolean redoExtraction, RepositoryFileFilter filter, Writer statusOut) throws RepositoryException {
        if (checkingExtractions) {
            throw new IllegalStateException("The process for checking extractions is currently running. Cannot start the second process.");
        }
        checkingExtractions = true;
        long timer = System.currentTimeMillis();
        ExtractionCheckStatus status = new ExtractionCheckStatus();
        OutWrapper out = new OutWrapper(logger, statusOut);
        out.echo("Start {} extraction by filter", redoExtraction ? REDOING : CHECKING);
        extractionChecker = new TextExtractionChecker(status, redoExtraction, filter, out);
        try {
            JCRCallback<Object> callback = new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    extractionChecker.perform(session);
                    return null;
                }
            };
            if (StringUtils.isEmpty((CharSequence)filter.getWorkspace()) || "default".equals(filter.getWorkspace())) {
                out.echo("Extractions in DEFAULT workspace for: ");
                JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, "default", null, callback);
                if (status.extractable == 0L) {
                    out.echo("none");
                }
            }
            long extractableInDefault = status.extractable;
            if (StringUtils.isEmpty((CharSequence)filter.getWorkspace()) || "live".equals(filter.getWorkspace())) {
                out.echo("\nExtractions in LIVE workspace for: ");
                JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, "live", null, callback);
                if (status.extractable == extractableInDefault) {
                    out.echo("none");
                }
            }
            checkingExtractions = false;
        }
        catch (Throwable throwable) {
            checkingExtractions = false;
            logger.info("Done {} text extractions in {} ms. Status: {}", new Object[]{redoExtraction ? REDOING : CHECKING, System.currentTimeMillis() - timer, status});
            throw throwable;
        }
        logger.info("Done {} text extractions in {} ms. Status: {}", new Object[]{redoExtraction ? REDOING : CHECKING, System.currentTimeMillis() - timer, status});
        return status;
    }

    public static void forceStopExtractionCheck() {
        if (extractionChecker != null) {
            extractionChecker.stop();
        }
    }

    public static boolean isCheckingExtractions() {
        return checkingExtractions;
    }

    private TextExtractionHelper() {
    }
}

