/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm;

import java.util.ArrayList;
import java.util.List;
import org.drools.core.command.impl.AbstractInterceptor;
import org.kie.api.command.Command;

public class JBPMEventGeneratorInterceptor
extends AbstractInterceptor {
    private static List<JBPMEventListener> listeners = new ArrayList<JBPMEventListener>();

    public static boolean registerListener(JBPMEventListener listener) {
        if (listeners.contains(listener)) {
            return false;
        }
        return listeners.add(listener);
    }

    public static boolean unregisterListener(JBPMEventListener listener) {
        if (!listeners.contains(listener)) {
            return false;
        }
        return listeners.remove(listener);
    }

    public <T> T execute(Command<T> command) {
        for (JBPMEventListener listener : listeners) {
            if (!listener.canProcess(command)) continue;
            listener.beforeCommand(command);
        }
        Object result = this.getNext().execute(command);
        for (JBPMEventListener listener : listeners) {
            if (!listener.canProcess(command)) continue;
            listener.afterCommand(command);
        }
        return (T)result;
    }

    public static interface JBPMEventListener {
        public <T> boolean canProcess(Command<T> var1);

        public <T> void beforeCommand(Command<T> var1);

        public <T> void afterCommand(Command<T> var1);
    }
}

