/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm.command;

import java.util.List;
import java.util.Map;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.workflow.WorkflowTask;
import org.jahia.services.workflow.jbpm.BaseCommand;
import org.kie.api.runtime.KieSession;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.InternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignTaskCommand
extends BaseCommand<List<WorkflowTask>> {
    private static transient Logger logger = LoggerFactory.getLogger(AssignTaskCommand.class);
    private final String taskId;
    private final JahiaUser user;

    public AssignTaskCommand(String taskId, JahiaUser user) {
        this.taskId = taskId;
        this.user = user;
    }

    @Override
    public List<WorkflowTask> execute() {
        KieSession ksession = this.getKieSession();
        long id = Long.parseLong(this.taskId);
        Task task = this.getTaskService().getTaskById(id);
        Map<String, Object> taskInputParameters = this.getTaskInputParameters(task, ksession, this.getTaskService());
        Map<String, Object> taskOutputParameters = this.getTaskOutputParameters(task, taskInputParameters, ksession, this.getTaskService());
        if (this.user == null) {
            this.getTaskService().release(task.getId().longValue(), JCRSessionFactory.getInstance().getCurrentUser().getUserKey());
        } else if (task.getTaskData().getActualOwner() != null && this.user.getUserKey().equals(task.getTaskData().getActualOwner().getId())) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cannot assign task " + task.getId() + " to user " + this.user.getName() + ", user is already owner");
            }
        } else if (!this.checkParticipation(task, this.user)) {
            logger.error("Cannot assign task " + task.getId() + " to user " + this.user.getName() + ", user is not candidate");
        } else {
            this.getTaskService().claim(id, this.user.getUserKey());
        }
        JCRUserNode actualUser = null;
        if (task.getTaskData().getActualOwner() != null) {
            actualUser = this.getUserManager().lookupUserByPath(task.getTaskData().getActualOwner().getId());
        }
        if (actualUser != null) {
            taskOutputParameters.put("currentUser", this.user.getUserKey());
            ((InternalTaskService)this.getTaskService()).addContent(id, taskOutputParameters);
            this.updateTaskNode(actualUser.getJahiaUser(), (String)taskOutputParameters.get("task-" + id));
        }
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + String.format("%n taskId: %s", this.taskId) + String.format("%n user: %s", this.user != null ? this.user.getName() : null);
    }
}

