/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jahia.services.workflow.HistoryWorkflow;
import org.jahia.services.workflow.jbpm.BaseCommand;
import org.jbpm.process.audit.VariableInstanceLog;

public class GetHistoryWorkflowsForNodeCommand
extends BaseCommand<List<HistoryWorkflow>> {
    private final String nodeId;
    private final Locale uiLocale;

    public GetHistoryWorkflowsForNodeCommand(String nodeId, Locale uiLocale) {
        this.nodeId = nodeId;
        this.uiLocale = uiLocale;
    }

    @Override
    public List<HistoryWorkflow> execute() {
        List result = this.getEm().createQuery("FROM VariableInstanceLog v WHERE v.variableId = :variableId AND v.value = :variableValue").setParameter("variableId", (Object)"nodeId").setParameter("variableValue", (Object)this.nodeId).getResultList();
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> l = new ArrayList<String>();
        for (VariableInstanceLog log : result) {
            l.add(Long.toString(log.getProcessInstanceId()));
        }
        return this.getHistoryWorkflows(l, this.uiLocale);
    }

    @Override
    public String toString() {
        return super.toString() + String.format("%n nodeId: %s", this.nodeId) + String.format("%n uiLocale: %s", this.uiLocale);
    }
}

