/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm.command;

import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.jahia.services.workflow.Workflow;
import org.jahia.services.workflow.jbpm.BaseCommand;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;

public class GetWorkflowsForDefinitionCommand
extends BaseCommand<List<Workflow>> {
    private final String definition;
    private final Locale uiLocale;

    public GetWorkflowsForDefinitionCommand(String definition, Locale uiLocale) {
        this.definition = definition;
        this.uiLocale = uiLocale;
    }

    @Override
    public List<Workflow> execute() {
        LinkedList<Workflow> workflows = new LinkedList<Workflow>();
        for (Process process : this.getKieSession().getKieBase().getProcesses()) {
            List processInstanceLogs = this.getLogService().findActiveProcessInstances(process.getId());
            for (ProcessInstanceLog processInstanceLog : processInstanceLogs) {
                ProcessInstance processInstance = this.getKieSession().getProcessInstance(processInstanceLog.getProcessInstanceId());
                if (processInstance == null || !processInstance.getProcessName().equals(this.definition) || !(processInstance instanceof WorkflowProcessInstance)) continue;
                workflows.add(this.convertToWorkflow(processInstance, this.uiLocale, this.getKieSession(), this.getTaskService(), this.getLogService()));
            }
        }
        return workflows;
    }

    @Override
    public String toString() {
        return super.toString() + String.format("%n definition: %s", this.definition) + String.format("%n uiLocale: %s", this.uiLocale);
    }
}

