/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm.custom;

import java.util.Date;
import java.util.List;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.services.workflow.jbpm.custom.AbstractWorkItemHandler;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnpublishWorkItemHandler
extends AbstractWorkItemHandler
implements WorkItemHandler {
    private static transient Logger logger = LoggerFactory.getLogger(UnpublishWorkItemHandler.class);

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        List ids = (List)workItem.getParameter("nodeIds");
        String userKey = (String)workItem.getParameter("user");
        JCRSessionFactory sessionFactory = JCRSessionFactory.getInstance();
        JCRUserNode user = JahiaUserManagerService.getInstance().lookupUserByPath(userKey);
        JahiaUser currentUser = sessionFactory.getCurrentUser();
        if (user != null) {
            sessionFactory.setCurrentUser(user.getJahiaUser());
        }
        try {
            if (logger.isDebugEnabled()) {
                for (String id : ids) {
                    JCRNodeWrapper node = sessionFactory.getCurrentUserSession().getNodeByUUID(id);
                    logger.debug("Launching unpublication of node " + node.getPath() + " at " + new Date().toString());
                }
            }
            JCRPublicationService.getInstance().unpublish(ids, false);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        sessionFactory.setCurrentUser(currentUser);
        manager.completeWorkItem(workItem.getId(), null);
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        manager.abortWorkItem(workItem.getId());
    }
}

