/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.settings;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.settings.SystemPropertiesFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentVariablesPropertiesFactoryBean
extends SystemPropertiesFactoryBean {
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentVariablesPropertiesFactoryBean.class);

    protected String convertKey(String key) {
        return StringUtils.replace((String)StringUtils.replaceChars((String)key, (char)'_', (char)'.'), (String)"..", (String)"_");
    }

    @Override
    protected Properties createProperties() throws IOException {
        Properties props = this.processProperties(System.getenv());
        logger.info("Detected the following environment variables, which are converted into Java system properties and will be considered in the configuration: {}", (Object)props.keySet().toArray());
        this.setSystemProperties(props);
        return props;
    }

    protected Properties processProperties(Map<String, String> availableProps) {
        Properties props = new Properties();
        for (Map.Entry<String, String> entry : availableProps.entrySet()) {
            String key = entry.getKey();
            String effectiveKey = null;
            String value = entry.getValue();
            if (value == null) continue;
            if (StringUtils.isNotEmpty((String)this.getPrefix()) && key.toLowerCase().startsWith(this.getPrefix()) && key.length() > this.getPrefix().length()) {
                effectiveKey = key.substring(this.getPrefix().length());
            }
            if (effectiveKey == null) continue;
            props.put(this.convertKey(effectiveKey), value);
        }
        return props;
    }

    protected void setSystemProperties(Properties props) {
        for (Object keyObj : props.keySet()) {
            String key = keyObj.toString();
            logger.info("Setting system property: {}", (Object)key);
            JahiaContextLoaderListener.setSystemProperty(key, props.getProperty(key));
        }
    }
}

