/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.settings;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public class StringUtils {
    private StringUtils() {
    }

    public static String deleteFirstToken(String string, String token) {
        int position = string.indexOf(token);
        if (position == -1) {
            return string;
        }
        return string.substring(0, position) + string.substring(position + token.length(), string.length());
    }

    public static String replaceFirstToken(String string, String oldToken, String newToken) {
        int position = string.indexOf(oldToken);
        if (position == -1) {
            return string;
        }
        return string.substring(0, position) + newToken + string.substring(position + oldToken.length(), string.length());
    }

    public static String replaceLastToken(String string, String oldToken, String newToken) {
        int position = string.lastIndexOf(oldToken);
        if (position == -1) {
            return string;
        }
        return string.substring(0, position) + newToken + string.substring(position + oldToken.length(), string.length());
    }

    public static String replaceAllTokens(String string, String oldToken, String newToken) {
        int[] positions = StringUtils.getTokenPositions(string, oldToken);
        if (positions.length == 0) {
            return string;
        }
        StringBuilder ret = new StringBuilder();
        ret.append(string.substring(0, positions[0]));
        for (int i = 0; i < positions.length - 1; ++i) {
            ret.append(newToken);
            ret.append(string.substring(positions[i] + oldToken.length(), positions[i + 1]));
        }
        ret.append(newToken);
        ret.append(string.substring(positions[positions.length - 1] + oldToken.length(), string.length()));
        return ret.toString();
    }

    public static String cleanBeforeFirstToken(String string, String token, boolean keepToken) {
        int position = string.indexOf(token);
        if (position == -1) {
            return string;
        }
        return string.substring(keepToken ? position : position + token.length(), string.length());
    }

    public static String cleanAfterLastToken(String string, String token, boolean keepToken) {
        int position = string.lastIndexOf(token);
        if (position == -1) {
            return string;
        }
        return string.substring(0, keepToken ? position + token.length() : position);
    }

    public static int[] getTokenPositions(String string, String token) {
        int[] result = new int[]{};
        if (token.length() == 0) {
            return result;
        }
        int start = 0;
        int tempInd = string.indexOf(token, start);
        if (tempInd == -1) {
            return result;
        }
        ArrayList<Integer> positions = new ArrayList<Integer>();
        while (tempInd != -1) {
            positions.add(tempInd);
            start = tempInd + token.length();
            tempInd = string.indexOf(token, start);
        }
        int size = positions.size();
        result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (Integer)positions.get(i);
        }
        return result;
    }

    public static String[] split(String string, String splitToken) {
        String[] init = new String[]{string};
        if (splitToken.length() == 0) {
            return init;
        }
        int[] positions = StringUtils.getTokenPositions(string, splitToken);
        if (positions.length == 0) {
            return init;
        }
        ArrayList<String> splitted = new ArrayList<String>();
        if (0 < positions[0]) {
            splitted.add(string.substring(0, positions[0]));
        }
        for (int i = 0; i < positions.length - 1; ++i) {
            if (positions[i] + splitToken.length() >= positions[i + 1]) continue;
            splitted.add(string.substring(positions[i] + splitToken.length(), positions[i + 1]));
        }
        if (positions[positions.length - 1] < string.length()) {
            splitted.add(string.substring(positions[positions.length - 1] + splitToken.length()));
        }
        String[] result = new String[splitted.size()];
        for (int i = 0; i < splitted.size(); ++i) {
            result[i] = (String)splitted.get(i);
        }
        return result;
    }

    public static String[] removeDuplicatesFromSortedStringArray(String[] sortedArray) {
        ArrayList<String> unique = new ArrayList<String>();
        String temp = "";
        for (String aSortedArray : sortedArray) {
            if (temp.equals(aSortedArray)) continue;
            temp = aSortedArray;
            unique.add(temp);
        }
        String[] result = new String[unique.size()];
        for (int i = 0; i < unique.size(); ++i) {
            result[i] = (String)unique.get(i);
        }
        return result;
    }

    public static String[] sortStringArrayAndRemoveDuplicates(String[] array) {
        Arrays.sort(array);
        return StringUtils.removeDuplicatesFromSortedStringArray(array);
    }

    public static boolean isPartiallyContained(String path, String[] highlightedElements) {
        boolean result = false;
        for (int i = 0; !result && i < highlightedElements.length; ++i) {
            String highlighter = highlightedElements[i];
            if (highlighter.contains(".java")) {
                StringUtils.replaceLastToken(highlighter, ".java", "");
            }
            if (!path.contains(highlighter)) continue;
            result = true;
        }
        return result;
    }

    public static String[] removeStringsContainingToken(String[] stringList, String token) {
        ArrayList<String> cleared = new ArrayList<String>();
        for (String path : stringList) {
            if (path.contains(File.separator + token + File.separator)) continue;
            cleared.add(path);
        }
        String[] result = new String[cleared.size()];
        for (int i = 0; i < cleared.size(); ++i) {
            result[i] = (String)cleared.get(i);
        }
        return result;
    }
}

