/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.tools.patches;

import javax.servlet.Servlet;
import org.jahia.osgi.BundleUtils;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.tools.patches.PatchExecutor;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphqlPatcher
implements PatchExecutor {
    private static final Logger logger = LoggerFactory.getLogger(GraphqlPatcher.class);

    @Override
    public boolean canExecute(String name, String lifecyclePhase) {
        return name.endsWith(lifecyclePhase + ".graphql");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String executeScript(String name, String scriptContent) {
        try {
            JCRSessionFactory.getInstance().setCurrentUser(JahiaUserManagerService.getInstance().lookupRootUser().getJahiaUser());
            Servlet servlet = BundleUtils.getOsgiService(Servlet.class, "(component.name=graphql.kickstart.servlet.OsgiGraphQLHttpServlet)");
            String json = (String)servlet.getClass().getMethod("executeQuery", String.class).invoke((Object)servlet, scriptContent);
            logger.info("Graphql execution result : {}", (Object)json);
            JSONObject object = new JSONObject(json);
            if (object.has("errors") && object.getJSONArray("errors").length() > 0) {
                String string = ".failed";
                return string;
            }
            String string = ".installed";
            return string;
        }
        catch (Exception e) {
            logger.error("Execution of script failed with error: {}", (Object)e.getMessage(), (Object)e);
            String string = ".failed";
            return string;
        }
        finally {
            JCRSessionFactory.getInstance().setCurrentUser(null);
        }
    }
}

