/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.tools.patches;

import java.io.PrintWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.helpers.MessageFormatter;

public class LoggerWrapper
extends org.slf4j.ext.LoggerWrapper {
    private PrintWriter out;

    public LoggerWrapper(Logger logger, String fqcn, Writer out) {
        super(logger, fqcn);
        this.out = new PrintWriter(out, true);
    }

    public void error(String msg) {
        this.out(msg, null, null);
        super.error(msg);
    }

    public void error(String format, Object arg) {
        this.out(format, new Object[]{arg}, null);
        super.error(format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.out(format, new Object[]{arg1, arg2}, null);
        super.error(format, arg1, arg2);
    }

    public void error(String format, Object[] argArray) {
        this.out(format, argArray, null);
        super.error(format, argArray);
    }

    public void error(String msg, Throwable t) {
        this.out(msg, null, t);
        super.error(msg, t);
    }

    public void info(Object msg) {
        this.info(String.valueOf(msg));
    }

    public void info(String msg) {
        this.out(msg, null, null);
        super.info(msg);
    }

    public void info(String format, Object arg) {
        this.out(format, new Object[]{arg}, null);
        super.info(format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.out(format, new Object[]{arg1, arg2}, null);
        super.info(format, arg1, arg2);
    }

    public void info(String format, Object[] argArray) {
        this.out(format, argArray, null);
        super.info(format, argArray);
    }

    public void info(String msg, Throwable t) {
        this.out(msg, null, t);
        super.info(msg, t);
    }

    private void out(String format, Object[] argArray, Throwable t) {
        this.out.println(argArray != null ? MessageFormatter.arrayFormat((String)format, (Object[])argArray) : format);
        if (t != null) {
            this.out.println(t.getMessage());
            t.printStackTrace(this.out);
        }
    }

    public void warn(String msg) {
        this.out(msg, null, null);
        super.warn(msg);
    }

    public void warn(String format, Object arg) {
        this.out(format, new Object[]{arg}, null);
        super.warn(format, arg);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.out(format, new Object[]{arg1, arg2}, null);
        super.warn(format, arg1, arg2);
    }

    public void warn(String format, Object[] argArray) {
        this.out(format, argArray, null);
        super.warn(format, argArray);
    }

    public void warn(String msg, Throwable t) {
        this.out(msg, null, t);
        super.warn(msg, t);
    }
}

