/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import org.jahia.tools.jvm.ThreadMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoadAverage
implements Runnable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected double oneMinuteLoad = 0.0;
    protected double fiveMinuteLoad = 0.0;
    protected double fifteenMinuteLoad = 0.0;
    private long calcFreqMillis = 5000L;
    private double loggingTriggerValue;
    private double threadDumpTriggerValue;
    private Thread loadCalcThread;
    private final String threadName;
    private boolean running = false;
    private String displayName;
    private boolean threadDumpOnHighLoad;

    public void setLoggingTriggerValue(double loggingTriggerValue) {
        this.loggingTriggerValue = loggingTriggerValue;
    }

    public double getLoggingTriggerValue() {
        return this.loggingTriggerValue;
    }

    public void setCalcFrequencyInMillisec(long millisec) {
        this.calcFreqMillis = millisec;
    }

    public abstract double getCount();

    public void tickCallback() {
        if (this.oneMinuteLoad > this.getLoggingTriggerValue()) {
            this.logger.info(this.getInfo());
            if (this.isThreadDumpOnHighLoad() && this.oneMinuteLoad > this.getThreadDumpTriggerValue()) {
                ThreadMonitor.getInstance().dumpThreadInfo(false, true);
            }
        }
    }

    public String getInfo() {
        return this.getDisplayName() + " = " + this.oneMinuteLoad + " " + this.fiveMinuteLoad + " " + this.fifteenMinuteLoad;
    }

    public LoadAverage(String threadName) {
        this.threadName = threadName;
    }

    public void start() {
        if (this.calcFreqMillis > 0L) {
            this.loadCalcThread = new Thread((Runnable)this, this.threadName);
            this.loadCalcThread.setDaemon(true);
            this.running = true;
            this.loadCalcThread.start();
        }
    }

    public void stop() {
        if (this.running) {
            this.running = false;
            this.loadCalcThread.interrupt();
            try {
                this.loadCalcThread.join(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void run() {
        double calcFreqDouble = (double)this.calcFreqMillis / 1000.0;
        while (this.running) {
            double timeInMinutes = 1.0;
            this.oneMinuteLoad = this.oneMinuteLoad * Math.exp(-calcFreqDouble / (60.0 * timeInMinutes)) + this.getCount() * (1.0 - Math.exp(-calcFreqDouble / (60.0 * timeInMinutes)));
            timeInMinutes = 5.0;
            this.fiveMinuteLoad = this.fiveMinuteLoad * Math.exp(-calcFreqDouble / (60.0 * timeInMinutes)) + this.getCount() * (1.0 - Math.exp(-calcFreqDouble / (60.0 * timeInMinutes)));
            timeInMinutes = 15.0;
            this.fifteenMinuteLoad = this.fifteenMinuteLoad * Math.exp(-calcFreqDouble / (60.0 * timeInMinutes)) + this.getCount() * (1.0 - Math.exp(-calcFreqDouble / (60.0 * timeInMinutes)));
            this.tickCallback();
            try {
                Thread.sleep(this.calcFreqMillis);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public double getOneMinuteLoad() {
        return this.oneMinuteLoad;
    }

    public double getFiveMinuteLoad() {
        return this.fiveMinuteLoad;
    }

    public double getFifteenMinuteLoad() {
        return this.fifteenMinuteLoad;
    }

    public String getDisplayName() {
        return this.displayName != null ? this.displayName : this.threadName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isThreadDumpOnHighLoad() {
        return this.threadDumpOnHighLoad;
    }

    public void setThreadDumpOnHighLoad(boolean threadDumpOnHighLoad) {
        this.threadDumpOnHighLoad = threadDumpOnHighLoad;
    }

    public double getThreadDumpTriggerValue() {
        return this.threadDumpTriggerValue > 0.0 ? this.threadDumpTriggerValue : this.loggingTriggerValue;
    }

    public void setThreadDumpTriggerValue(double threadDumpTriggerValue) {
        this.threadDumpTriggerValue = threadDumpTriggerValue;
    }
}

