/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.subject.Subject;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.settings.SettingsBean;
import org.springframework.core.io.Resource;

public final class WebUtils {
    public static String escapePath(String path) {
        return path != null ? Text.escapePath((String)path) : null;
    }

    public static Subject getAuthenticatedSubject(HttpServletRequest request) throws AuthenticationException {
        String[] authData;
        Subject subject = SecurityUtils.getSubject();
        if (subject == null) {
            return null;
        }
        if (!subject.isAuthenticated() && (authData = WebUtils.getBasicAuthData(request)) != null) {
            subject.login((AuthenticationToken)new UsernamePasswordToken(authData[0], authData[1]));
        }
        return subject;
    }

    public static String[] getBasicAuthData(HttpServletRequest request) {
        String decoded;
        String[] tokens;
        String[] authStr;
        String header = request.getHeader("Authorization");
        if (header != null && (authStr = header.split(" ")).length >= 2 && authStr[0].equalsIgnoreCase("BASIC") && (tokens = (decoded = Base64.decodeToString((String)authStr[1])).split(":")).length >= 2) {
            return new String[]{tokens[0], tokens[1]};
        }
        return null;
    }

    public static String getInternetExplorerCompatibility(HttpServletRequest request) {
        String theme;
        String compatibility = SettingsBean.getInstance().getInternetExplorerCompatibility();
        if (request != null && "IE=10".equals(compatibility) && (theme = WebUtils.getUITheme(request)) != null && !"default".equals(theme)) {
            compatibility = "IE=11";
        }
        return compatibility;
    }

    public static InputStream getResourceAsStream(String path) throws IOException {
        InputStream is = null;
        String string = path = path.length() > 0 && path.charAt(0) != '/' ? "/" + path : path;
        if (path.startsWith("/modules/")) {
            Resource r;
            String module = StringUtils.substringAfter((String)path, (String)"/modules/");
            String remainingPath = StringUtils.substringAfter((String)module, (String)"/");
            module = StringUtils.substringBefore((String)module, (String)"/");
            JahiaTemplatesPackage pack = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(module);
            if (pack != null && (r = pack.getResource(remainingPath)) != null) {
                is = r.getInputStream();
            }
        } else {
            is = JahiaContextLoaderListener.getServletContext().getResourceAsStream(path);
        }
        return is;
    }

    public static String getResourceAsString(String path) throws IOException {
        InputStream is = WebUtils.getResourceAsStream(path);
        String content = null;
        if (is != null) {
            try {
                content = IOUtils.toString((InputStream)is);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return content;
    }

    public static String getUITheme(HttpServletRequest request) {
        JahiaUser jahiaUser;
        HttpSession session;
        String theme = request.getParameter("jahia.ui.theme");
        if (theme == null && (session = request.getSession(false)) != null && (theme = (String)session.getAttribute("jahia.ui.theme")) == null && (jahiaUser = (JahiaUser)session.getAttribute("org.jahia.usermanager.jahiauser")) != null && (theme = jahiaUser.getProperty("jahia.ui.theme")) == null) {
            theme = "jahia-anthracite";
        }
        return theme;
    }

    public static String lookupResourceAsString(String ... lookupPaths) throws IOException {
        String path;
        String text = null;
        String[] stringArray = lookupPaths;
        int n = stringArray.length;
        for (int i = 0; i < n && (text = WebUtils.getResourceAsString(path = stringArray[i])) == null; ++i) {
        }
        return text;
    }

    public static void setCacheHeaders(long expiresSeconds, HttpServletResponse response) {
        response.setHeader("Cache-Control", "public, max-age=" + expiresSeconds);
        response.setDateHeader("Expires", System.currentTimeMillis() + expiresSeconds * 1000L);
    }

    public static void setNoCacheHeaders(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, proxy-revalidate, max-age=0");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 295075800000L);
    }

    public static void setFileDownloadHeaders(HttpServletResponse response, String fileName) {
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
    }

    public static String urlDecode(String url) {
        try {
            return URLDecoder.decode(url, SettingsBean.getInstance().getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private WebUtils() {
    }
}

