/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.comparator;

import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import org.jahia.services.categories.Category;
import org.jahia.services.categories.CategoryBean;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.VersionInfo;
import org.jahia.utils.i18n.ResourceBundleMarker;

public class NumericStringComparator<T>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 5685606235122904838L;
    private Locale locale;

    public NumericStringComparator(Locale locale) {
        this.locale = locale;
    }

    @Override
    public int compare(T c1, T c2) throws ClassCastException {
        if (c1 == null) {
            return 1;
        }
        if (c2 == null) {
            return -1;
        }
        String s1 = this.getStringValueForObjectComparison(c1);
        String s2 = this.getStringValueForObjectComparison(c2);
        int idx1 = this.getFirstDigitIndex(s1);
        int idx2 = this.getFirstDigitIndex(s2);
        if (idx1 == -1 || idx2 == -1 || !s1.substring(0, idx1).equals(s2.substring(0, idx2))) {
            return Collator.getInstance(this.locale).compare(s1, s2);
        }
        int edx1 = this.getLastDigitIndex(s1, idx1);
        int edx2 = this.getLastDigitIndex(s2, idx2);
        String sub1 = this.removeLastDigits(s1, idx1, edx1);
        String sub2 = this.removeLastDigits(s2, idx2, edx2);
        int zero1 = this.countZeroes(sub1);
        int zero2 = this.countZeroes(sub2);
        if ((sub1 = sub1.substring(zero1)).equals(sub2 = sub2.substring(zero2))) {
            int ret = 0;
            if (zero1 > zero2) {
                ret = 1;
            } else if (zero1 < zero2) {
                ret = -1;
            }
            s1 = edx1 == -1 ? "" : s1.substring(edx1);
            s2 = edx2 == -1 ? "" : s2.substring(edx2);
            int comp = s1.compareTo(s2);
            if (comp != 0) {
                ret = comp;
            }
            return ret;
        }
        if (sub1.length() != sub2.length()) {
            return sub1.length() < sub2.length() ? -1 : 1;
        }
        char[] chr1 = sub1.toCharArray();
        char[] chr2 = sub2.toCharArray();
        int sz = chr1.length;
        for (int i = 0; i < sz; ++i) {
            if (chr1[i] == chr2[i]) continue;
            return chr1[i] < chr2[i] ? -1 : 1;
        }
        return 0;
    }

    protected int getFirstDigitIndex(String str) {
        return this.getFirstDigitIndex(str, 0);
    }

    protected int getFirstDigitIndex(String str, int start) {
        return this.getFirstDigitIndex(str.toCharArray(), start);
    }

    protected int getFirstDigitIndex(char[] chrs, int start) {
        int sz = chrs.length;
        for (int i = start; i < sz; ++i) {
            if (!Character.isDigit(chrs[i])) continue;
            return i;
        }
        return -1;
    }

    protected int getLastDigitIndex(String str, int start) {
        return this.getLastDigitIndex(str.toCharArray(), start);
    }

    protected int getLastDigitIndex(char[] chrs, int start) {
        int sz = chrs.length;
        for (int i = start; i < sz; ++i) {
            if (Character.isDigit(chrs[i])) continue;
            return i;
        }
        return -1;
    }

    protected int countZeroes(String str) {
        int count = 0;
        for (int i = 0; i < str.length() && str.charAt(i) == '0'; ++i) {
            ++count;
        }
        return count;
    }

    protected boolean containsOnly(String str, char ch) {
        return this.containsOnly(str.toCharArray(), ch);
    }

    protected boolean containsOnly(char[] chrs, char ch) {
        int sz = chrs.length;
        for (int i = 0; i < sz; ++i) {
            if (chrs[i] == ch) continue;
            return false;
        }
        return true;
    }

    private String getStringValueForObjectComparison(T c1) {
        String s1;
        if (c1 instanceof ResourceBundleMarker) {
            s1 = ((ResourceBundleMarker)c1).getValue();
        } else if (c1.getClass() == Category.class) {
            Category cat = (Category)c1;
            s1 = cat.getTitle(JCRSessionFactory.getInstance().getCurrentLocale());
            if (s1 == null || s1.length() == 0) {
                s1 = cat.getKey();
            }
        } else if (c1 instanceof CategoryBean) {
            CategoryBean cat = (CategoryBean)c1;
            s1 = cat.getKey();
        } else if (c1.getClass() == Version.class) {
            Version res = (Version)c1;
            try {
                s1 = res.getName();
            }
            catch (RepositoryException e) {
                s1 = "error";
            }
        } else if (c1.getClass() == VersionInfo.class) {
            VersionInfo res = (VersionInfo)c1;
            s1 = res.getLabel();
            if (s1 == null) {
                try {
                    s1 = res.getVersion().getName();
                }
                catch (RepositoryException e) {
                    s1 = "error";
                }
            }
        } else {
            s1 = c1.toString();
        }
        return s1;
    }

    private String removeLastDigits(String s1, int idx1, int edx1) {
        String sub1 = edx1 == -1 ? s1.substring(idx1) : s1.substring(idx1, edx1);
        return sub1;
    }
}

