/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.zip;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class DirectoryZipInputStream
extends ZipInputStream {
    File sourceDirectory;
    List<File> sourceDirectoryEntries;
    Iterator<File> sourceDirectoryEntriesIterator;
    File currentEntry;
    FileInputStream currentEntryInputStream;
    ZipEntry currentZipEntry;

    public DirectoryZipInputStream(File sourceDirectory) {
        super(new ByteArrayInputStream(new byte[0]));
        this.sourceDirectory = sourceDirectory;
        this.sourceDirectoryEntries = new ArrayList<File>(FileUtils.listFilesAndDirs((File)sourceDirectory, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE));
        if (this.sourceDirectoryEntries.get(0).equals(sourceDirectory)) {
            this.sourceDirectoryEntries.remove(0);
        } else if (this.sourceDirectoryEntries.get(this.sourceDirectoryEntries.size() - 1).equals(sourceDirectory)) {
            this.sourceDirectoryEntries.remove(this.sourceDirectoryEntries.size() - 1);
        }
        this.sourceDirectoryEntriesIterator = this.sourceDirectoryEntries.iterator();
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    @Override
    public ZipEntry getNextEntry() throws IOException {
        if (this.currentEntryInputStream != null) {
            this.closeEntry();
        }
        if (!this.sourceDirectoryEntriesIterator.hasNext()) {
            return null;
        }
        this.currentEntry = this.sourceDirectoryEntriesIterator.next();
        String currentEntryName = this.currentEntry.getPath();
        if (currentEntryName.startsWith(this.sourceDirectory.getPath() + File.separator)) {
            currentEntryName = currentEntryName.substring(this.sourceDirectory.getPath().length() + 1);
        }
        this.currentZipEntry = this.currentEntry.isDirectory() && !currentEntryName.endsWith("/") ? new ZipEntry(currentEntryName + "/") : new ZipEntry(currentEntryName);
        this.currentZipEntry.setSize(this.currentEntry.length());
        this.currentZipEntry.setTime(this.currentEntry.lastModified());
        if (!this.currentEntry.isDirectory()) {
            this.currentEntryInputStream = new FileInputStream(this.currentEntry);
        }
        return this.currentZipEntry;
    }

    @Override
    public void closeEntry() throws IOException {
        if (this.currentEntryInputStream != null) {
            this.currentEntryInputStream.close();
            this.currentEntryInputStream = null;
        }
    }

    @Override
    public int available() throws IOException {
        return this.currentEntryInputStream.available();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.currentEntryInputStream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.currentEntryInputStream.skip(n);
    }

    @Override
    public void close() throws IOException {
        if (this.currentEntryInputStream != null) {
            this.currentEntryInputStream.close();
        }
    }

    @Override
    protected ZipEntry createZipEntry(String name) {
        return new ZipEntry(name);
    }

    @Override
    public int read() throws IOException {
        return this.currentEntryInputStream.read();
    }

    @Override
    protected void fill() throws IOException {
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.currentEntryInputStream.read(b);
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.currentEntryInputStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.currentEntryInputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.currentEntryInputStream.markSupported();
    }
}

