/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.wise;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.jahia.utils.maven.plugin.contentgenerator.wise.bo.TaskBO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskService {
    private static TaskService instance;
    private Log logger = new SystemStreamLog();

    private TaskService() {
    }

    public static TaskService getInstance() {
        if (instance == null) {
            instance = new TaskService();
        }
        return instance;
    }

    public List<TaskBO> generateTasks(int nbTasks, Integer nbUsers) {
        ArrayList<TaskBO> tasks = new ArrayList<TaskBO>();
        String candidate = "root";
        String creator = "root";
        Random rand = new Random();
        for (int i = 1; i <= nbTasks; ++i) {
            this.logger.info((CharSequence)("Generating task " + i + "/" + nbTasks));
            if (nbUsers != null && nbUsers.compareTo(0) > 0) {
                int idAssignee = rand.nextInt(nbUsers - 1);
                candidate = "user" + idAssignee;
                int idCreator = rand.nextInt(nbUsers - 1);
                creator = "user" + idCreator;
            }
            tasks.add(new TaskBO("Task " + i, creator, candidate, "New task " + i));
        }
        return tasks;
    }
}

