/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jahia.configuration.deployers.ServerDeploymentFactory;
import org.jahia.configuration.deployers.ServerDeploymentInterface;

public abstract class AbstractManagementMojo
extends AbstractMojo {
    protected String targetServerType = "tomcat";
    protected String targetServerVersion = "";
    protected String targetServerDirectory;
    public String webAppDirName;
    protected File baseDir;
    protected File output;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    protected MavenProject project;
    protected ArtifactRepository localRepository;
    private ServerDeploymentInterface deployer;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ServerDeploymentFactory.setTargetServerDirectory((String)this.targetServerDirectory);
        this.doValidate();
        this.doExecute();
    }

    public void doValidate() throws MojoExecutionException, MojoFailureException {
    }

    public abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    protected List<File> getDependencies(String[] artifacts) throws ArtifactNotFoundException, ArtifactResolutionException {
        ArrayList<File> list = new ArrayList<File>();
        for (int i = 0; i < artifacts.length; ++i) {
            String curFQN = artifacts[i];
            StringTokenizer tokens = new StringTokenizer(curFQN, ":");
            String groupId = tokens.nextToken();
            String artifactId = tokens.nextToken();
            String versionId = tokens.nextToken();
            String typeId = "jar";
            if (tokens.hasMoreTokens()) {
                typeId = tokens.nextToken();
            }
            Artifact artifact = this.artifactFactory.createArtifactWithClassifier(groupId, artifactId, versionId, typeId, null);
            this.artifactResolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
            if (artifact.getFile() == null) {
                this.getLog().warn((CharSequence)("Unable to find file for artifact: " + artifact.getArtifactId()));
            }
            list.add(artifact.getFile());
        }
        return list;
    }

    protected int updateFiles(File sourceFolder, File destFolder) throws IOException {
        return this.updateFiles(sourceFolder, destFolder, null);
    }

    protected int updateFiles(File sourceFolder, File destFolder, String excluded) throws IOException {
        return this.updateFiles(sourceFolder, sourceFolder, destFolder, excluded);
    }

    protected int updateFiles(File sourceFolder, File originalSourceFolder, File destFolder, String excluded) throws IOException {
        long timer = System.currentTimeMillis();
        List filesToUpdate = org.codehaus.plexus.util.FileUtils.getFileNames((File)sourceFolder, (String)"**", (String)excluded, (boolean)false);
        int cnt = 0;
        for (String sourceFile : filesToUpdate) {
            File destFile = new File(destFolder, sourceFile);
            File origFile = new File(sourceFolder, sourceFile);
            File origSourceFile = new File(originalSourceFolder, sourceFile);
            long date = origFile.lastModified();
            if (origSourceFile.exists()) {
                date = origSourceFile.lastModified();
            }
            if (destFile.exists() && destFile.lastModified() >= date) continue;
            this.getLog().debug((CharSequence)("Copy " + origFile + " to " + destFile));
            FileUtils.copyFile((File)origFile, (File)destFile);
            ++cnt;
        }
        this.getLog().debug((CharSequence)("Copy took " + (System.currentTimeMillis() - timer)));
        timer = System.currentTimeMillis();
        org.codehaus.plexus.util.FileUtils.copyDirectoryLayout((File)sourceFolder, (File)destFolder, null, null);
        this.getLog().debug((CharSequence)("Dir layout took " + (System.currentTimeMillis() - timer)));
        return cnt;
    }

    protected String getWebappDeploymentDirName() {
        String dirName = this.getDeployer().getWebappDeploymentDirNameOverride();
        return dirName != null ? dirName : (this.webAppDirName != null ? this.webAppDirName : "jahia");
    }

    protected File getWebappDeploymentDir() throws Exception {
        return new File(this.targetServerDirectory, this.getDeployer().getDeploymentDirPath(this.getWebappDeploymentDirName(), "war"));
    }

    private ServerDeploymentInterface getDeployer() {
        if (this.deployer == null) {
            this.deployer = ServerDeploymentFactory.getInstance().getImplementation(this.targetServerType, this.targetServerVersion);
        }
        return this.deployer;
    }

    protected File getWarSarRarDeploymentDir(Artifact artifact) throws Exception {
        File dir = artifact.getType().equals("rar") || artifact.getType().equals("sar") || artifact.getArtifactId().equals("config") ? new File(this.targetServerDirectory, this.getDeployer().getDeploymentDirPath(artifact.getArtifactId(), artifact.getType())) : this.getWebappDeploymentDir();
        return dir;
    }
}

