/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.jahia.utils.maven.plugin.contentgenerator.CategoryService;
import org.jahia.utils.maven.plugin.contentgenerator.DatabaseService;
import org.jahia.utils.maven.plugin.contentgenerator.FileService;
import org.jahia.utils.maven.plugin.contentgenerator.OutputService;
import org.jahia.utils.maven.plugin.contentgenerator.PageService;
import org.jahia.utils.maven.plugin.contentgenerator.SiteService;
import org.jahia.utils.maven.plugin.contentgenerator.TagService;
import org.jahia.utils.maven.plugin.contentgenerator.UserGroupService;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ArticleBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ExportBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.GroupBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.SiteBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.UserBO;
import org.jdom.Document;
import org.jdom.Element;
import org.w3c.dom.DOMException;

public class ContentGeneratorService {
    private Log logger = new SystemStreamLog();
    public static ContentGeneratorService instance;
    public static int currentPageIndex;
    public static int currentFileIndex;

    private ContentGeneratorService() {
    }

    public static ContentGeneratorService getInstance() {
        if (instance == null) {
            instance = new ContentGeneratorService();
        }
        return instance;
    }

    public void generatePages(ExportBO export, List<ArticleBO> articles) throws MojoExecutionException, IOException {
        if (!"none".equals(export.getAddFilesToPage()) && export.getFileNames().isEmpty()) {
            throw new MojoExecutionException("Directory containing files to include is empty, use jahia-cg:generate-files first");
        }
        currentPageIndex = 0;
        PageService pageService = new PageService();
        pageService.createTopPages(export, articles);
    }

    public void generateFiles(ExportBO export) throws MojoExecutionException {
        this.logger.info((CharSequence)"Jahia files generator starts");
        Integer numberOfFilesToGenerate = export.getNumberOfFilesToGenerate();
        if (numberOfFilesToGenerate == null) {
            throw new MojoExecutionException("numberOfFilesToGenerate parameter is null");
        }
        List<ArticleBO> articles = DatabaseService.getInstance().selectArticles(export, export.getNumberOfFilesToGenerate());
        int indexArticle = 0;
        for (int i = 0; i < numberOfFilesToGenerate; ++i) {
            if (indexArticle == articles.size()) {
                indexArticle = 0;
            }
            File outputFile = new File(export.getFilesDirectory(), "file." + i + ".txt");
            try {
                FileUtils.writeStringToFile((File)outputFile, (String)articles.get(indexArticle).getContent());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Can't create new file: " + e.getMessage());
            }
            ++indexArticle;
        }
        FileService fileService = new FileService();
        this.logger.debug((CharSequence)export.getFilesDirectory().getAbsolutePath());
        List<String> filesNamesAvailable = fileService.getFileNamesAvailable(export.getFilesDirectory());
        export.setFileNames(filesNamesAvailable);
    }

    public String generateSites(ExportBO export) throws MojoExecutionException, DOMException, ParserConfigurationException {
        String globalArchivePath = null;
        OutputService os = new OutputService();
        UserGroupService userGroupService = new UserGroupService();
        ArrayList<File> globalFilesToZip = new ArrayList<File>();
        try {
            if (!"none".equals(export.getAddFilesToPage()) && export.getFileNames().isEmpty()) {
                this.generateFiles(export);
            }
            List<UserBO> users = userGroupService.generateUsers(export.getNumberOfUsers(), 0, 0, null);
            File tmpUsers = new File(export.getOutputDir(), "users");
            tmpUsers.mkdir();
            File repositoryUsers = new File(tmpUsers, "repository.xml");
            Document usersRepositoryDocument = userGroupService.createUsersRepository(users);
            os.writeJdomDocumentToFile(usersRepositoryDocument, repositoryUsers);
            ArrayList<File> filesToZip = new ArrayList<File>();
            File contentUsers = userGroupService.createFileTreeForUsers(users, tmpUsers);
            filesToZip.add(repositoryUsers);
            filesToZip.add(contentUsers);
            File usersArchive = os.createSiteArchive("users.zip", export.getOutputDir(), filesToZip);
            globalFilesToZip.add(usersArchive);
            ArrayList<String> userNames = new ArrayList<String>();
            for (UserBO user : users) {
                userNames.add(user.getName());
            }
            File f = new File(export.getOutputDir(), "users.txt");
            f.delete();
            os.appendPathToFile(f, userNames);
            String baseSiteKey = export.getSiteKey();
            export.getMapFile().delete();
            SiteService siteService = new SiteService();
            TagService tagService = new TagService();
            CategoryService categoryService = new CategoryService();
            List<ArticleBO> articles = DatabaseService.getInstance().selectArticles(export, export.getTotalPages());
            for (int i = 0; i < export.getNumberOfSites(); ++i) {
                this.logger.debug((CharSequence)("Generating site #" + (i + 1)));
                export.setRootPageName("home");
                SiteBO site = new SiteBO();
                String siteKey = baseSiteKey + (i > 0 ? Integer.valueOf(i + 1) : "");
                export.setSiteKey(siteKey);
                site.setSiteKey(siteKey);
                this.generatePages(export, articles);
                this.logger.debug((CharSequence)"Pages generated, now site");
                filesToZip = new ArrayList();
                File tempOutputDir = siteService.createSiteDirectory(siteKey, new File(export.getOutputDir()));
                File propertiesFile = siteService.createPropertiesFile(siteKey, export.getSiteLanguages(), "templates-web-blue-qa", tempOutputDir);
                filesToZip.add(propertiesFile);
                File filesFile = null;
                if (!"none".equals(export.getAddFilesToPage())) {
                    FileService fileService = new FileService();
                    File filesDirectory = siteService.createFilesDirectoryTree(siteKey, tempOutputDir);
                    filesToZip.add(new File(tempOutputDir + "/content"));
                    List<File> filesToCopy = fileService.getFilesAvailable(export.getFilesDirectory());
                    fileService.copyFilesForAttachment(filesToCopy, filesDirectory);
                    filesFile = new File(export.getOutputDir(), "jcrFiles.xml");
                    fileService.createAndPopulateFilesXmlFile(filesFile, filesToCopy);
                }
                File groupsFile = null;
                if (export.getNumberOfUsers() > 0) {
                    List<GroupBO> groups = userGroupService.generateGroups(export.getNumberOfGroups(), export.getNumberOfUsersPerGroup(), users);
                    Element groupsNode = userGroupService.generateJcrGroups(siteKey, groups);
                    Document groupsDoc = new Document(groupsNode);
                    groupsFile = new File(export.getOutputDir(), "groups.xml");
                    os.writeJdomDocumentToFile(groupsDoc, groupsFile);
                }
                Element tagList = tagService.createTagListElement();
                List<Element> tags = tagService.createTags(export.getNumberOfTags());
                tagList.addContent(tags);
                Document tagsDoc = new Document(tagList);
                File tagsFile = new File(export.getOutputDir(), "tags.xml");
                os.writeJdomDocumentToFile(tagsDoc, tagsFile);
                File repositoryFile = siteService.createAndPopulateRepositoryFile(tempOutputDir, site, export.getOutputFile(), filesFile, groupsFile, tagsFile);
                filesToZip.add(repositoryFile);
                String zipFileName = siteKey + ".zip";
                File siteArchive = os.createSiteArchive(zipFileName, export.getOutputDir(), filesToZip);
                filesToZip.clear();
                globalFilesToZip.add(siteArchive);
            }
            Document systemSiteRepository = siteService.createSystemSiteRepository();
            Element categories = categoryService.createCategories(export.getNumberOfCategories(), export.getNumberOfCategoryLevels(), export);
            categoryService.insertCategoriesIntoSiteRepository(systemSiteRepository, categories);
            String systemSiteRepositoryFileName = "repository.xml";
            File systemSiteRepositoryFile = new File(export.getOutputDir(), systemSiteRepositoryFileName);
            os.writeJdomDocumentToFile(systemSiteRepository, systemSiteRepositoryFile);
            filesToZip.add(systemSiteRepositoryFile);
            File systemSiteArchive = os.createSiteArchive("systemsite.zip", export.getOutputDir(), filesToZip);
            globalFilesToZip.add(systemSiteArchive);
            this.logger.info((CharSequence)"System site archive created");
            File globalArchive = os.createSiteArchive("import.zip", export.getOutputDir(), globalFilesToZip);
            globalArchivePath = globalArchive.getAbsolutePath();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception while creating the website ZIP archive: " + e);
        }
        return globalArchivePath;
    }

    public Integer getTotalNumberOfPagesNeeded(Integer nbPagesTopLevel, Integer nbLevels, Integer nbPagesPerLevel) {
        Double nbPages = new Double(0.0);
        for (double d = (double)nbLevels.intValue(); d > 0.0; d -= 1.0) {
            nbPages = nbPages + Math.pow(nbPagesPerLevel.doubleValue(), d);
        }
        nbPages = nbPages * (double)nbPagesTopLevel.intValue() + (double)nbPagesTopLevel.intValue();
        return new Integer(nbPages.intValue());
    }

    public String getDateForJcrImport(Date date) {
        GregorianCalendar gc = (GregorianCalendar)GregorianCalendar.getInstance();
        if (date != null) {
            gc.setTime(date);
        }
        StringBuffer sbNewDate = new StringBuffer();
        sbNewDate.append(gc.get(1));
        sbNewDate.append("-");
        sbNewDate.append(gc.get(2));
        sbNewDate.append("-");
        sbNewDate.append(gc.get(5));
        sbNewDate.append("T");
        sbNewDate.append(gc.get(11));
        sbNewDate.append(":");
        sbNewDate.append(gc.get(12));
        sbNewDate.append(":");
        sbNewDate.append(gc.get(13));
        sbNewDate.append(".");
        sbNewDate.append(gc.get(14));
        sbNewDate.append(gc.get(15));
        return sbNewDate.toString();
    }

    static {
        currentPageIndex = 0;
        currentFileIndex = 0;
    }
}

