/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.jahia.utils.maven.plugin.contentgenerator.ArticleService;
import org.jahia.utils.maven.plugin.contentgenerator.ContentGeneratorService;
import org.jahia.utils.maven.plugin.contentgenerator.FileService;
import org.jahia.utils.maven.plugin.contentgenerator.OutputService;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ArticleBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ExportBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.PageBO;
import org.jahia.utils.maven.plugin.contentgenerator.properties.ContentGeneratorCst;
import org.jdom.Document;

public class PageService {
    private Log logger = new SystemStreamLog();
    String sep;
    private Random random = new Random();
    private static List<String> oftenUsedDescriptionWords;
    private static List<String> seldomUsedDescriptionWords;
    private static Integer nbOftenKeywordsAlreadyAssigned;
    private static Integer nbSeldomKeywordsAlreadyAssigned;

    public PageService() {
        this.sep = System.getProperty("file.separator");
        oftenUsedDescriptionWords = Arrays.asList(ContentGeneratorCst.OFTEN_USED_DESCRIPTION_WORDS.split("\\s*,\\s*"));
        seldomUsedDescriptionWords = Arrays.asList(ContentGeneratorCst.SELDOM_USED_DESCRIPTION_WORDS.split("\\s*,\\s*"));
        nbOftenKeywordsAlreadyAssigned = 0;
        nbSeldomKeywordsAlreadyAssigned = 0;
    }

    public void createTopPages(ExportBO export, List<ArticleBO> articles) throws IOException {
        OutputService os = new OutputService();
        ArticleService articleService = ArticleService.getInstance();
        this.logger.info((CharSequence)"Creating top pages");
        PageBO pageTopLevel = null;
        HashMap<String, ArticleBO> articlesMap = new HashMap<String, ArticleBO>();
        for (String language : export.getSiteLanguages()) {
            articlesMap.put(language, articleService.getArticle(articles));
        }
        String rootPageName = export.getRootPageName();
        OutputService outService = new OutputService();
        outService.initOutputFile(export.getOutputFile());
        outService.appendStringToFile(export.getOutputFile(), export.toString());
        ArrayList<PageBO> listeTopPages = new ArrayList<PageBO>();
        for (int i = 1; i <= export.getNbPagesTopLevel(); ++i) {
            for (String language : export.getSiteLanguages()) {
                articlesMap.put(language, articleService.getArticle(articles));
            }
            pageTopLevel = this.createNewPage(export, null, articlesMap, export.getNbSubLevels() + 1, this.createSubPages(export, articles, export.getNbSubLevels(), export.getMaxArticleIndex()));
            outService.appendPageToFile(export.getOutputFile(), pageTopLevel);
            listeTopPages.add(pageTopLevel);
        }
        this.logger.info((CharSequence)"Pages path are being written to the map file");
        List<String> pagesPath = this.getPagesPath(listeTopPages, "/sites/" + export.getSiteKey() + "/" + rootPageName);
        outService.appendPathToFile(export.getMapFile(), pagesPath);
        PageBO rootPage = this.createNewPage(export, rootPageName, articlesMap, export.getNbSubLevels() + 1, listeTopPages);
        outService.appendStringToFile(export.getOutputFile(), rootPage.getJcrXml());
        Document pagesDocument = new Document(rootPage.getElement());
        os.writeJdomDocumentToFile(pagesDocument, export.getOutputFile());
    }

    public List<PageBO> createSubPages(ExportBO export, List<ArticleBO> articles, Integer level, Integer maxArticleIndex) {
        ArticleService articleService = ArticleService.getInstance();
        ArrayList<PageBO> listePages = new ArrayList<PageBO>();
        int nbPagesPerLevel = export.getNbSubPagesPerPage();
        listePages.clear();
        if (level > 0) {
            for (int i = 0; i < nbPagesPerLevel; ++i) {
                HashMap<String, ArticleBO> articlesMap = new HashMap<String, ArticleBO>();
                for (String language : export.getSiteLanguages()) {
                    articlesMap.put(language, articleService.getArticle(articles));
                }
                PageBO page = this.createNewPage(export, null, articlesMap, level, this.createSubPages(export, articles, level - 1, maxArticleIndex + 1));
                listePages.add(page);
            }
        }
        return listePages;
    }

    public PageBO createNewPage(ExportBO export, String pageName, Map<String, ArticleBO> articlesMap, int level, List<PageBO> subPages) {
        ++ContentGeneratorService.currentPageIndex;
        boolean addFile = false;
        if ("all".equals(export.getAddFilesToPage())) {
            addFile = true;
        } else if ("random".equals(export.getAddFilesToPage())) {
            Random random = new Random();
            addFile = random.nextBoolean();
        }
        String fileName = null;
        if (addFile) {
            FileService fileService = new FileService();
            fileName = fileService.getFileName(export.getFileNames());
        }
        this.logger.debug((CharSequence)("\t\tCreating new page level " + level + " - Page " + ContentGeneratorService.currentPageIndex + " - Articles " + articlesMap + " - file attached " + fileName));
        String template = "events";
        Integer indexPagesWithList = export.getNbPagesWithTplList();
        Integer indexPagesWithQuery = export.getNbPagesWithTplList() + export.getNbPagesWithTplQuery();
        if (ContentGeneratorService.currentPageIndex <= indexPagesWithList) {
            template = "qa-list";
        }
        if (ContentGeneratorService.currentPageIndex > indexPagesWithList && ContentGeneratorService.currentPageIndex <= indexPagesWithQuery) {
            template = "qa-query";
        }
        if (pageName == null) {
            pageName = template + ContentGeneratorService.currentPageIndex;
        }
        HashMap<String, List<String>> acls = new HashMap<String, List<String>>();
        if ((double)this.random.nextFloat() < export.getGroupAclRatio() && export.getNumberOfGroups() > 0) {
            acls.put("g:group" + this.random.nextInt(export.getNumberOfGroups()), Arrays.asList("editor"));
        }
        if ((double)this.random.nextFloat() < export.getUsersAclRatio() && export.getNumberOfUsers() > 0) {
            acls.put("u:user" + this.random.nextInt(export.getNumberOfUsers()), Arrays.asList("editor"));
        }
        Integer idCategory = null;
        float firstThird = export.getTotalPages() / 3;
        if ((float)ContentGeneratorService.currentPageIndex <= firstThird && export.getNumberOfCategories() > 0) {
            idCategory = this.random.nextInt(export.getNumberOfCategories());
            this.logger.debug((CharSequence)("Add " + pageName + " to category " + idCategory));
        }
        Integer idTag = null;
        if ((float)ContentGeneratorService.currentPageIndex <= firstThird && export.getNumberOfTags() > 0) {
            idTag = this.random.nextInt(export.getNumberOfTags());
            this.logger.debug((CharSequence)("Tag " + pageName + " with tag " + idTag));
        }
        Boolean visibilityOnPage = Boolean.FALSE;
        if ((float)ContentGeneratorService.currentPageIndex <= firstThird && export.getVisibilityEnabled().booleanValue()) {
            visibilityOnPage = Boolean.TRUE;
            this.logger.debug((CharSequence)"Visibility enabled");
        }
        String oftenKeywords = this.getOftenKeywords(export.getTotalPages());
        String seldomKeywords = this.getSeldomKeywords(export.getTotalPages());
        String description = oftenKeywords + " " + seldomKeywords;
        PageBO page = new PageBO(pageName, articlesMap, level, subPages, export.getPagesHaveVanity(), export.getSiteKey(), fileName, export.getNumberOfBigTextPerPage(), acls, idCategory, idTag, visibilityOnPage, export.getVisibilityStartDate(), export.getVisibilityEndDate(), description, template);
        return page;
    }

    public List<String> getPagesPath(List<PageBO> pages, String path) {
        ArrayList<String> siteMap = new ArrayList<String>();
        if (path == null) {
            path = "";
        }
        for (PageBO page : pages) {
            String newPath = path + "/" + page.getUniqueName();
            siteMap.add(newPath);
            if (page.getSubPages() == null) continue;
            siteMap.addAll(this.getPagesPath(page.getSubPages(), newPath));
        }
        return siteMap;
    }

    private String getOftenKeywords(int nbOfPagesToCreate) {
        Integer nbKeywordsAvailable = oftenUsedDescriptionWords.size();
        double ratio = (double)ContentGeneratorCst.OFTEN_USED_DESCRIPTION_WORDS_COUNTER.intValue() * (double)nbKeywordsAvailable.intValue() / (double)nbOfPagesToCreate;
        double nbKeywordsToGet = (double)(ContentGeneratorService.currentPageIndex + 1) * ratio - (double)nbOftenKeywordsAlreadyAssigned.intValue();
        nbKeywordsToGet = Math.floor(nbKeywordsToGet);
        HashSet<Object> keywords = new HashSet();
        if ((double)nbKeywordsAvailable.intValue() <= nbKeywordsToGet) {
            keywords = new HashSet<String>(oftenUsedDescriptionWords);
        } else {
            int i = 1;
            Random r = new Random();
            while ((double)i <= nbKeywordsToGet) {
                int randomId = r.nextInt(nbKeywordsAvailable - 1);
                boolean added = keywords.add(oftenUsedDescriptionWords.get(randomId));
                if (!added) continue;
                ++i;
            }
        }
        StringBuffer sb = new StringBuffer();
        Iterator iterator = keywords.iterator();
        while (iterator.hasNext()) {
            sb = sb.append((String)iterator.next() + " ");
        }
        nbOftenKeywordsAlreadyAssigned = nbOftenKeywordsAlreadyAssigned + (int)nbKeywordsToGet;
        return sb.toString();
    }

    private String getSeldomKeywords(int nbOfPagesToCreate) {
        Integer nbKeywordsAvailable = seldomUsedDescriptionWords.size();
        double ratio = (double)ContentGeneratorCst.SELDOM_USED_DESCRIPTION_WORDS_COUNTER.intValue() * (double)nbKeywordsAvailable.intValue() / (double)nbOfPagesToCreate;
        double nbKeywordsToGet = (double)(ContentGeneratorService.currentPageIndex + 1) * ratio - (double)nbSeldomKeywordsAlreadyAssigned.intValue();
        nbKeywordsToGet = Math.floor(nbKeywordsToGet);
        HashSet<Object> keywords = new HashSet();
        if ((double)nbKeywordsAvailable.intValue() <= nbKeywordsToGet) {
            keywords = new HashSet<String>(seldomUsedDescriptionWords);
        } else {
            int i = 1;
            Random r = new Random();
            while ((double)i <= nbKeywordsToGet) {
                int randomId = r.nextInt(nbKeywordsAvailable - 1);
                boolean added = keywords.add(seldomUsedDescriptionWords.get(randomId));
                if (!added) continue;
                ++i;
            }
        }
        StringBuffer sb = new StringBuffer();
        Iterator iterator = keywords.iterator();
        while (iterator.hasNext()) {
            sb = sb.append((String)iterator.next() + " ");
        }
        nbSeldomKeywordsAlreadyAssigned = nbSeldomKeywordsAlreadyAssigned + (int)nbKeywordsToGet;
        return sb.toString();
    }
}

