/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.bo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ArticleBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.NewsBO;
import org.jahia.utils.maven.plugin.contentgenerator.properties.ContentGeneratorCst;
import org.jdom.Content;
import org.jdom.Element;

public class PageBO {
    private Element pageElement;
    private String uniqueName;
    private Map<String, ArticleBO> articles;
    private Integer level;
    private List<PageBO> subPages;
    private PageBO parentPage;
    private Boolean hasVanity;
    private String siteKey;
    private String fileName;
    private Integer numberBigText;
    private Map<String, List<String>> acls;
    private Integer idCategory;
    private Integer idTag;
    private Boolean visibilityEnabled;
    private String visibilityStartDate;
    private String visibilityEndDate;
    private String description;
    private String pageTemplate;

    public void setIdCategory(Integer idCategory) {
        this.idCategory = idCategory;
    }

    public void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public List<PageBO> getSubPages() {
        return this.subPages;
    }

    public void setSubPages(List<PageBO> subPages) {
        this.subPages = subPages;
    }

    public PageBO getParentPage() {
        return this.parentPage;
    }

    public void setParentPage(PageBO parentPage) {
        this.parentPage = parentPage;
    }

    public Map<String, ArticleBO> getArticles() {
        return this.articles;
    }

    public void setArticles(Map<String, ArticleBO> articles) {
        this.articles = articles;
    }

    public Boolean getHasVanity() {
        return this.hasVanity;
    }

    public void setHasVanity(Boolean hasVanity) {
        this.hasVanity = hasVanity;
    }

    public String getSiteKey() {
        return this.siteKey;
    }

    public void setSiteKey(String siteKey) {
        this.siteKey = siteKey;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Integer getNumberBigText() {
        return this.numberBigText;
    }

    public void setNumberBigText(Integer numberBigText) {
        this.numberBigText = numberBigText;
    }

    public Map<String, List<String>> getAcls() {
        return this.acls;
    }

    public void setAcls(Map<String, List<String>> acls) {
        this.acls = acls;
    }

    public Integer getIdTag() {
        return this.idTag;
    }

    public void setIdTag(Integer idTag) {
        this.idTag = idTag;
    }

    public void setVisibilityEnabled(Boolean visibilityEnabled) {
        this.visibilityEnabled = visibilityEnabled;
    }

    public void setVisibilityStartDate(String visibilityStartDate) {
        this.visibilityStartDate = visibilityStartDate;
    }

    public void setVisibilityEndDate(String visibilityEndDate) {
        this.visibilityEndDate = visibilityEndDate;
    }

    public PageBO(String pUniqueName, Map<String, ArticleBO> articles, int pLevel, List<PageBO> pSubPages, Boolean pHasVanity, String pSiteKey, String pFileName, Integer pNumberBigText, Map<String, List<String>> acls, Integer idCategory, Integer idTag, Boolean visibilityEnabled, String visibilityStartDate, String visibilityEndDate, String description, String pageTemplate) {
        this.articles = articles;
        this.level = pLevel;
        this.subPages = pSubPages;
        this.uniqueName = pUniqueName;
        this.hasVanity = pHasVanity;
        this.siteKey = pSiteKey;
        this.fileName = pFileName;
        this.numberBigText = pNumberBigText;
        this.acls = acls;
        this.idCategory = idCategory;
        this.idTag = idTag;
        this.visibilityEnabled = visibilityEnabled;
        this.visibilityStartDate = visibilityStartDate;
        this.visibilityEndDate = visibilityEndDate;
        this.description = description;
        this.pageTemplate = pageTemplate;
    }

    public Element getElement() {
        if (this.pageElement == null) {
            this.pageElement = new Element(this.getUniqueName());
            this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_JCR);
            this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_NT);
            this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_JNT);
            this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_TEST);
            this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_SV);
            this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_JMIX);
            this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_J);
            this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_SV);
            this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_REP);
            this.pageElement.setAttribute("changefreq", "monthly");
            this.pageElement.setAttribute("templateNode", "/sites/" + this.getSiteKey() + "/templates/base/" + this.pageTemplate, ContentGeneratorCst.NS_J);
            this.pageElement.setAttribute("primaryType", "jnt:page", ContentGeneratorCst.NS_JCR);
            this.pageElement.setAttribute("priority", "0.5");
            String mixinTypes = "jmix:sitemap";
            if (this.getHasVanity().booleanValue()) {
                mixinTypes = mixinTypes + " jmix:vanityUrlMapped";
            }
            this.pageElement.setAttribute("mixinTypes", mixinTypes, ContentGeneratorCst.NS_JCR);
            if (this.idCategory != null) {
                this.pageElement.setAttribute("jcategorized", null, ContentGeneratorCst.NS_JMIX);
                this.pageElement.setAttribute("defaultCategory", "/sites/systemsite/categories/category" + this.idCategory, ContentGeneratorCst.NS_J);
            }
            if (this.idTag != null) {
                this.pageElement.setAttribute("tags", "/sites/" + this.siteKey + "/tags/tag" + this.idTag, ContentGeneratorCst.NS_J);
            }
            for (Map.Entry<String, ArticleBO> entry : this.articles.entrySet()) {
                Element translationNode = new Element("translation_" + entry.getKey(), ContentGeneratorCst.NS_J);
                translationNode.setAttribute("language", entry.getKey(), ContentGeneratorCst.NS_JCR);
                translationNode.setAttribute("mixinTypes", "mix:title", ContentGeneratorCst.NS_JCR);
                translationNode.setAttribute("primaryType", "jnt:translation", ContentGeneratorCst.NS_JCR);
                translationNode.setAttribute("title", entry.getValue().getTitle(), ContentGeneratorCst.NS_JCR);
                if (StringUtils.isNotEmpty((String)this.description)) {
                    translationNode.setAttribute("description", this.description, ContentGeneratorCst.NS_JCR);
                }
                this.pageElement.addContent((Content)translationNode);
            }
            if (!this.acls.isEmpty()) {
                Element aclNode = new Element("acl", ContentGeneratorCst.NS_J);
                aclNode.setAttribute("inherit", "true", ContentGeneratorCst.NS_J);
                aclNode.setAttribute("primaryType", "jnt:acl", ContentGeneratorCst.NS_JCR);
                for (Map.Entry<String, List<String>> entry : this.acls.entrySet()) {
                    String roles = "";
                    for (String s : entry.getValue()) {
                        roles = roles + s + " ";
                    }
                    Element aceNode = new Element("GRANT_" + entry.getKey().replace(":", "_"));
                    aceNode.setAttribute("aceType", "GRANT", ContentGeneratorCst.NS_J);
                    aceNode.setAttribute("principal", entry.getKey(), ContentGeneratorCst.NS_J);
                    aceNode.setAttribute("protected", "false", ContentGeneratorCst.NS_J);
                    aceNode.setAttribute("roles", roles.trim(), ContentGeneratorCst.NS_J);
                    aceNode.setAttribute("primaryType", "jnt:ace", ContentGeneratorCst.NS_JCR);
                    aclNode.addContent((Content)aceNode);
                }
                this.pageElement.addContent((Content)aclNode);
            }
            Element listNode = new Element("listA");
            listNode.setAttribute("primaryType", "jnt:contentList", ContentGeneratorCst.NS_JCR);
            if (this.pageTemplate.equals("qa-list")) {
                ArrayList<String> languages = new ArrayList<String>();
                for (Map.Entry<String, ArticleBO> entry : this.articles.entrySet()) {
                    languages.add(entry.getKey());
                }
                for (int i = 1; i <= ContentGeneratorCst.NB_NEWS_IN_QALIST; ++i) {
                    listNode.addContent((Content)new NewsBO(this.uniqueName + "-" + "news" + i, languages).getElement());
                }
            } else if (this.pageTemplate.equals("events")) {
                for (int i = 1; i <= this.numberBigText; ++i) {
                    Element bigTextNode = new Element("bigText_" + i);
                    bigTextNode.setAttribute("primaryType", "jnt:bigText", ContentGeneratorCst.NS_JCR);
                    bigTextNode.setAttribute("mixinTypes", "jmix:renderable", ContentGeneratorCst.NS_JCR);
                    for (Map.Entry<String, ArticleBO> entry : this.articles.entrySet()) {
                        Element translationNode = new Element("translation_" + entry.getKey(), ContentGeneratorCst.NS_J);
                        translationNode.setAttribute("language", entry.getKey(), ContentGeneratorCst.NS_JCR);
                        translationNode.setAttribute("primaryType", "jnt:translation", ContentGeneratorCst.NS_JCR);
                        translationNode.setAttribute("text", entry.getValue().getContent());
                        bigTextNode.addContent((Content)translationNode);
                    }
                    listNode.addContent((Content)bigTextNode);
                }
            }
            if (this.getFileName() != null) {
                Element randomFileNode = new Element("rand-file");
                randomFileNode.setAttribute("primaryType", "jnt:fileReference", ContentGeneratorCst.NS_JCR);
                Element fileTranslationNode = new Element("translation_en", ContentGeneratorCst.NS_J);
                fileTranslationNode.setAttribute("language", "en", ContentGeneratorCst.NS_JCR);
                fileTranslationNode.setAttribute("primaryType", "jnt:translation", ContentGeneratorCst.NS_JCR);
                fileTranslationNode.setAttribute("title", "My file", ContentGeneratorCst.NS_JCR);
                randomFileNode.addContent((Content)fileTranslationNode);
                Element publicationNode = new Element("publication");
                publicationNode.setAttribute("primaryType", "jnt:publication", ContentGeneratorCst.NS_JCR);
                Element publicationTranslationNode = new Element("translation_en", ContentGeneratorCst.NS_J);
                publicationTranslationNode.setAttribute("author", "Jahia Content Generator");
                publicationTranslationNode.setAttribute("body", "&lt;p&gt;  Random publication&lt;/p&gt;");
                publicationTranslationNode.setAttribute("title", "Random publication", ContentGeneratorCst.NS_JCR);
                publicationTranslationNode.setAttribute("file", "/sites/" + this.getSiteKey() + "/files/contributed/" + ISO9075.encode((String)this.getFileName()));
                publicationTranslationNode.setAttribute("language", "en", ContentGeneratorCst.NS_JCR);
                publicationTranslationNode.setAttribute("primaryType", "jnt:translation", ContentGeneratorCst.NS_JCR);
                publicationTranslationNode.setAttribute("source", "Jahia");
                publicationNode.addContent((Content)publicationTranslationNode);
                listNode.addContent((Content)publicationNode);
            }
            this.pageElement.addContent((Content)listNode);
            if (this.getHasVanity().booleanValue()) {
                Element vanityNode = new Element("vanityUrlMapping");
                vanityNode.setAttribute("primaryType", "jnt:vanityUrls", ContentGeneratorCst.NS_JCR);
                Element vanitySubNode = new Element(this.getUniqueName());
                vanitySubNode.setAttribute("active", "true", ContentGeneratorCst.NS_J);
                vanitySubNode.setAttribute("default", "true", ContentGeneratorCst.NS_J);
                vanitySubNode.setAttribute("url", "/" + this.getUniqueName(), ContentGeneratorCst.NS_J);
                vanitySubNode.setAttribute("language", "en", ContentGeneratorCst.NS_JCR);
                vanitySubNode.setAttribute("primaryType", "jnt:vanityUrl", ContentGeneratorCst.NS_JCR);
                vanityNode.addContent((Content)vanitySubNode);
                this.pageElement.addContent((Content)vanityNode);
            }
            if (this.visibilityEnabled.booleanValue()) {
                Element visibilityNode = new Element("conditionalVisibility", ContentGeneratorCst.NS_J);
                visibilityNode.setAttribute("conditionalVisibility", null, ContentGeneratorCst.NS_J);
                visibilityNode.setAttribute("forceMatchAllConditions", "true", ContentGeneratorCst.NS_J);
                visibilityNode.setAttribute("primaryType", "jnt:conditionalVisibility", ContentGeneratorCst.NS_JCR);
                Element visibilityConditionNode = new Element("startEndDateCondition0", ContentGeneratorCst.NS_JNT);
                visibilityConditionNode.setAttribute("primaryType", "jnt:startEndDateCondition", ContentGeneratorCst.NS_JCR);
                visibilityConditionNode.setAttribute("start", this.visibilityStartDate);
                visibilityConditionNode.setAttribute("end", this.visibilityEndDate);
                visibilityNode.addContent((Content)visibilityConditionNode);
                this.pageElement.addContent((Content)visibilityNode);
            }
            if (null != this.subPages) {
                for (PageBO subPage : this.subPages) {
                    this.pageElement.addContent((Content)subPage.getElement());
                }
            }
        }
        return this.pageElement;
    }

    public String getJcrXml() {
        return this.getElement().getText();
    }

    public String formatForXml(String s) {
        String formattedString = StringUtils.replace((String)s, (String)"&", (String)"&amp;");
        formattedString = StringUtils.replace((String)formattedString, (String)"\"", (String)" &quot;");
        formattedString = StringUtils.replace((String)formattedString, (String)"<", (String)"&lt;");
        formattedString = StringUtils.replace((String)formattedString, (String)">", (String)"&gt;");
        formattedString = StringUtils.replace((String)formattedString, (String)"'", (String)"&#39;");
        return formattedString;
    }
}

