/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.osgi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.manager.BasicScmManager;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.git.gitexe.GitExeScmProvider;
import org.apache.maven.scm.provider.svn.svnexe.SvnExeScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.tika.io.IOUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.jahia.commons.Version;
import org.jahia.utils.maven.plugin.AbstractManagementMojo;
import org.jahia.utils.migration.Migrators;

public class ConvertToOSGI
extends AbstractManagementMojo {
    private static Map<String, String> jahiaManifestAttributes = new HashMap<String, String>();
    private boolean performMigration = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        BasicScmManager scmManager = new BasicScmManager();
        scmManager.setScmProvider("svn", (ScmProvider)new SvnExeScmProvider());
        scmManager.setScmProvider("git", (ScmProvider)new GitExeScmProvider());
        File pomXmlFile = new File(this.baseDir, "pom.xml");
        String scmURL = null;
        FileReader reader = null;
        ScmRepository scmRepository = null;
        try {
            reader = new FileReader(pomXmlFile);
            Model model = new MavenXpp3Reader().read((Reader)reader);
            scmURL = model.getScm().getConnection();
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
            IOUtils.closeQuietly((Reader)reader);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)reader);
        }
        IOUtils.closeQuietly((Reader)reader);
        try {
            scmRepository = scmManager.makeScmRepository(scmURL);
        }
        catch (ScmRepositoryException e) {
            e.printStackTrace();
        }
        catch (NoSuchScmProviderException e) {
            e.printStackTrace();
        }
        File webapp = new File(this.baseDir, "src/main/webapp");
        File resources = new File(this.baseDir, "src/main/resources");
        try {
            if (resources.exists()) {
                File oldWorkflowDir = new File(resources, "org/jahia/services/workflow");
                File newWorkflowDirParent = new File(resources, "org/jahia/modules/custom");
                if (oldWorkflowDir.exists()) {
                    ScmFileSet filesToRemove = new ScmFileSet(oldWorkflowDir, null, null);
                    this.getLog().info((CharSequence)("Moving " + oldWorkflowDir + " to " + newWorkflowDirParent + "..."));
                    FileUtils.moveDirectoryToDirectory((File)oldWorkflowDir, (File)newWorkflowDirParent, (boolean)true);
                    scmManager.remove(scmRepository, filesToRemove, "remove workflow dir");
                    scmManager.add(scmRepository, new ScmFileSet(newWorkflowDirParent, null, null));
                }
            }
            if (webapp.exists()) {
                List<File> filesToRemove = this.listFilesAndDirectories(webapp);
                this.getLog().info((CharSequence)("Removing " + new File(webapp, "WEB-INF/web.xml") + " no longer needed..."));
                File webXml = new File(webapp, "WEB-INF/web.xml");
                FileUtils.deleteQuietly((File)webXml);
                this.getLog().info((CharSequence)("Moving contents of directory " + webapp + " into directory " + resources + "..."));
                this.moveWithMerge(webapp, resources);
                scmManager.add(scmRepository, new ScmFileSet(new File(""), resources));
                List<File> filesToAdd = this.listFilesAndDirectories(resources);
                scmManager.add(scmRepository, new ScmFileSet(resources, filesToAdd), "add resources files");
                scmManager.remove(scmRepository, new ScmFileSet(webapp, filesToRemove), "remove webapps files");
            }
            this.getLog().info((CharSequence)"Performing Maven project modifications...");
            this.parsePom();
            scmManager.add(scmRepository, new ScmFileSet(new File(""), pomXmlFile));
            if (this.performMigration) {
                this.getLog().info((CharSequence)"Performing needed migration modifications");
            } else {
                this.getLog().info((CharSequence)"Checking for migration issues...");
            }
            List<String> messages = this.checkForMigrationIssues(this.baseDir, this.performMigration);
            if (messages.size() > 0) {
                this.getLog().info((CharSequence)"=====================================================================================================================");
                this.getLog().info((CharSequence)"Transformation messages:");
                this.getLog().info((CharSequence)"---------------------------------------------------------------------------------------------------------------------");
                for (String message : messages) {
                    this.getLog().info((CharSequence)message);
                }
                this.getLog().info((CharSequence)"---------------------------------------------------------------------------------------------------------------------");
                if (!this.performMigration) {
                    this.getLog().info((CharSequence)"None of the source code files were modified. If you would like to have the goal convert the files, please");
                    this.getLog().info((CharSequence)"relaunch the convert-to-osgi goal using the following parameter : ");
                    this.getLog().info((CharSequence)"   mvn jahia:convert-to-osgi -Djahia.osgi.conversion.performMigration=true");
                    this.getLog().info((CharSequence)"---------------------------------------------------------------------------------------------------------------------");
                } else {
                    this.getLog().info((CharSequence)"Source files were modified. Please review all code changes to make sure everything is ok as detection may have ");
                    this.getLog().info((CharSequence)"matched false statements (100% automatic conversion is not guaranteed by this tool.");
                    this.getLog().info((CharSequence)"---------------------------------------------------------------------------------------------------------------------");
                }
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ScmException e) {
            e.printStackTrace();
        }
    }

    private List<File> listFilesAndDirectories(File rootFolder) {
        ArrayList<File> files = new ArrayList<File>();
        for (File f : rootFolder.listFiles()) {
            files.add(f);
            if (!f.isDirectory()) continue;
            files.addAll(this.listFilesAndDirectories(f));
        }
        return files;
    }

    private boolean checkProjectParent(MavenProject p, String groupId, String artifactId) {
        MavenProject parent = p.getParent();
        if (parent == null) {
            return false;
        }
        if (groupId.equals(parent.getGroupId()) && artifactId.equals(parent.getArtifactId())) {
            return true;
        }
        return this.checkProjectParent(parent, groupId, artifactId);
    }

    private void moveWithMerge(File src, File dst) throws IOException {
        File[] files;
        for (File file : files = src.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.startsWith(".");
            }
        })) {
            if (file.isDirectory()) {
                File subDir = new File(dst, file.getName());
                if (subDir.exists()) {
                    this.moveWithMerge(file, subDir);
                    continue;
                }
                FileUtils.moveDirectoryToDirectory((File)file, (File)dst, (boolean)true);
                continue;
            }
            FileUtils.moveFileToDirectory((File)file, (File)dst, (boolean)true);
        }
    }

    private void parsePom() throws DocumentException, IOException {
        Element mavenWarPluginArtifactId;
        SAXReader reader = new SAXReader();
        File pom = new File(this.baseDir, "pom.xml");
        Document pomDocument = reader.read(pom);
        Document bundleModuleDocument = reader.read(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("bundleModule.xml"));
        Element root = pomDocument.getRootElement();
        Element packaging = root.element("packaging");
        if (packaging == null) {
            root.addElement("packaging");
        } else if (packaging.getTextTrim().toLowerCase().equals("war")) {
            packaging.setText("bundle");
        } else {
            this.getLog().info((CharSequence)("Non WAR packaging found : " + packaging.getTextTrim() + ", not modifying it to bundle, but you might want to double-check this."));
        }
        Element dependencies = root.element("dependencies");
        if (dependencies == null) {
            dependencies = root.addElement("dependencies");
        }
        List dependenciesTemplate = bundleModuleDocument.selectNodes("/project/*[local-name()='dependencies']/*");
        for (Element dep : dependenciesTemplate) {
            dependencies.add(dep.detach());
        }
        Element plugins = (Element)pomDocument.selectSingleNode("/project/*[local-name()='build']/*[local-name()='plugins']");
        if (plugins != null && (mavenWarPluginArtifactId = (Element)plugins.selectSingleNode("//*[local-name()='artifactId'][text()='maven-war-plugin']")) != null) {
            Element previousPluginConfig = (Element)mavenWarPluginArtifactId.getParent().detach();
            Element manifestEntries = previousPluginConfig.element("configuration").element("archive").element("manifestEntries");
            Element pluginTemplate = (Element)bundleModuleDocument.selectSingleNode("/project/*[local-name()='build']/*[local-name()='plugins']/*[local-name()='plugin']");
            if (pluginTemplate != null) {
                Element instructionsTemplate = (Element)pluginTemplate.element("configuration").element("instructions").detach();
                Element instructions = pluginTemplate.element("configuration").addElement("instructions");
                this.generateBundlePlugin(manifestEntries, instructions, instructionsTemplate);
                if (!instructions.elements().isEmpty()) {
                    plugins.add(pluginTemplate.detach());
                }
            }
        }
        XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(pom), OutputFormat.createPrettyPrint());
        writer.write(pomDocument);
        writer.close();
    }

    private void generateBundlePlugin(Element manifestEntries, Element instructions, Element instructionsTemplate) {
        Element depends = manifestEntries.element("depends");
        String dependsStr = null;
        if (depends != null) {
            dependsStr = depends.getText();
        }
        if (dependsStr != null && !dependsStr.trim().equals("default") && !dependsStr.trim().equals("Default Jahia Templates")) {
            instructions.addElement("Jahia-Depends").setText(dependsStr);
        }
        Element moduleType = manifestEntries.element("module-type");
        String moduleTypeStr = null;
        if (moduleType != null) {
            moduleTypeStr = moduleType.getText();
        }
        if (moduleTypeStr != null && !moduleTypeStr.equals("module")) {
            instructions.addElement("Jahia-Module-Type").setText(moduleTypeStr);
        }
        for (String name : jahiaManifestAttributes.keySet()) {
            Element element = manifestEntries.element(name);
            if (element == null) continue;
            element.setName(jahiaManifestAttributes.get(name));
            instructions.add(element.detach());
        }
    }

    public List<String> checkForMigrationIssues(File currentFile, boolean performMigration) throws FileNotFoundException {
        File[] currentChildren;
        ArrayList<String> messages = new ArrayList<String>();
        if (currentFile.isFile()) {
            FileInputStream fileInputStream = new FileInputStream(currentFile);
            ByteArrayOutputStream byteArrayOutputStream = null;
            if (performMigration) {
                byteArrayOutputStream = new ByteArrayOutputStream();
            }
            messages.addAll(Migrators.getInstance().migrate((InputStream)fileInputStream, (OutputStream)byteArrayOutputStream, currentFile.getPath(), new Version("6.6"), new Version("7.0"), performMigration));
            IOUtils.closeQuietly((InputStream)fileInputStream);
            if (performMigration && messages.size() > 0 && byteArrayOutputStream.size() > 0) {
                this.getLog().info((CharSequence)("Renaming existing file " + currentFile + " to " + currentFile.getName() + ".backup"));
                if (!currentFile.renameTo(new File(currentFile.getPath() + ".backup"))) {
                    this.getLog().error((CharSequence)("Error renaming " + currentFile + "!"));
                }
                byte[] byteArray = byteArrayOutputStream.toByteArray();
                this.getLog().info((CharSequence)("Writing modified file " + currentFile + "..."));
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
                FileOutputStream fileOutputStream = new FileOutputStream(currentFile);
                long bytesCopied = 0L;
                try {
                    bytesCopied = IOUtils.copyLarge((InputStream)byteArrayInputStream, (OutputStream)fileOutputStream);
                    fileOutputStream.flush();
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)("Error writing to file " + currentFile), (Throwable)e);
                }
                this.getLog().info((CharSequence)("Wrote " + bytesCopied + " bytes to file " + currentFile));
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
            }
            return messages;
        }
        if (!currentFile.isDirectory()) {
            this.getLog().warn((CharSequence)("Found non-file or directory at " + currentFile + ",ignoring..."));
            return messages;
        }
        for (File currentChild : currentChildren = currentFile.listFiles()) {
            messages.addAll(this.checkForMigrationIssues(currentChild, performMigration));
        }
        return messages;
    }

    static {
        jahiaManifestAttributes.put("definitions", "Jahia-Definitions");
        jahiaManifestAttributes.put("initial-imports", "Jahia-Initial-Imports");
        jahiaManifestAttributes.put("resource-bundle", "Jahia-Resource-Bundle");
        jahiaManifestAttributes.put("deploy-on-site", "Jahia-Deploy-On-Site");
    }
}

