/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.osgi;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jahia.utils.maven.plugin.SLF4JLoggerToMojoLogBridge;
import org.jahia.utils.osgi.PropertyFileUtils;
import org.jahia.utils.osgi.parsers.Parsers;
import org.jahia.utils.osgi.parsers.ParsingContext;
import org.slf4j.Logger;

public class DependenciesMojo
extends AbstractMojo {
    private static final Set<String> SUPPORTED_FILE_EXTENSIONS_TO_SCAN = new HashSet<String>(Arrays.asList("jsp", "jspf", "tag", "tagf", "cnd", "drl", "xml", "groovy"));
    private static final Set<String> DEPENDENCIES_SCAN_PACKAGING = new HashSet<String>(Arrays.asList("jar", "war"));
    private static final Set<String> DEPENDENCIES_SCAN_SCOPES = new HashSet<String>(Arrays.asList("provided", "compile", "runtime"));
    private Set<String> dependenciesThatCanBeSkipped = new TreeSet<String>();
    protected MavenProject project;
    protected List<String> artifactExcludes = new ArrayList<String>();
    protected List<String> scanDirectories = new ArrayList<String>();
    protected List<String> excludeFromDirectoryScan = new ArrayList<String>();
    protected String projectOutputDirectory;
    protected File propertiesInputFile;
    protected File propertiesOutputFile;
    protected String systemExtraCapabilitiesPropertyName = "org.osgi.framework.system.capabilities.extra";
    protected boolean contentDefinitionCapabilitiesActivated = true;
    protected String existingImports = "";
    private List<Pattern> artifactExclusionPatterns = new ArrayList<Pattern>();
    private Set<String> artifactsToSkip = new TreeSet<String>();
    private Logger logger = new SLF4JLoggerToMojoLogBridge(this.getLog());

    public void setLog(Log log) {
        super.setLog(log);
        this.logger = new SLF4JLoggerToMojoLogBridge(log);
    }

    /*
     * WARNING - void declaration
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getGroupId().equals("org.jahia.modules") && this.project.getArtifactId().equals("jahia-modules") || !"jar".equals(this.project.getPackaging()) && !"bundle".equals(this.project.getPackaging()) && !"war".equals(this.project.getPackaging())) {
            return;
        }
        long startTime = System.currentTimeMillis();
        ParsingContext parsingContext = new ParsingContext();
        if (this.existingImports != null) {
            parsingContext.addAllPackageImports(Arrays.asList(StringUtils.split((String)this.existingImports, (String)", \n\r")));
        }
        this.buildExclusionPatterns(parsingContext);
        this.readArtifactsToSkip(parsingContext);
        long timer = System.currentTimeMillis();
        try {
            this.scanClassesBuildDirectory(parsingContext);
            this.getLog().info((CharSequence)("Scanned classes directory in " + (System.currentTimeMillis() - timer) + " ms. Found " + parsingContext.getProjectPackages().size() + " project packages."));
            timer = System.currentTimeMillis();
            int scanned = this.scanDependencies(parsingContext);
            this.getLog().info((CharSequence)("Scanned " + scanned + " project dependencies in " + (System.currentTimeMillis() - timer) + " ms. Currently we have " + parsingContext.getProjectPackages().size() + " project packages."));
        }
        catch (IOException e) {
            throw new MojoFailureException("Error while scanning dependencies", (Throwable)e);
        }
        if (this.scanDirectories.isEmpty()) {
            this.scanDirectories.add(this.project.getBasedir() + "/src/main/resources");
            this.scanDirectories.add(this.project.getBasedir() + "/src/main/import");
            this.scanDirectories.add(this.project.getBasedir() + "/src/main/webapp");
        }
        timer = System.currentTimeMillis();
        for (String string : this.scanDirectories) {
            File scanDirectoryFile = new File(string);
            if (!scanDirectoryFile.exists()) {
                this.getLog().debug((CharSequence)("Couldn't find directory " + scanDirectoryFile + ", skipping !"));
                continue;
            }
            try {
                this.getLog().info((CharSequence)("Scanning resource directory " + scanDirectoryFile + "..."));
                this.processDirectoryTlds(scanDirectoryFile, parsingContext);
                this.processDirectory(scanDirectoryFile, parsingContext);
            }
            catch (IOException e) {
                throw new MojoFailureException("Error processing resource directory " + scanDirectoryFile, (Throwable)e);
            }
        }
        this.getLog().info((CharSequence)("Scanned resource directories in " + (System.currentTimeMillis() - timer) + " ms. Currently we have " + parsingContext.getProjectPackages().size() + " project packages."));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Found project packages (potential exports) :");
            for (String string : parsingContext.getProjectPackages()) {
                this.getLog().debug((CharSequence)("  " + string));
            }
        }
        parsingContext.postProcess();
        if (parsingContext.getUnresolvedTaglibUris().size() > 0) {
            for (Map.Entry entry : parsingContext.getUnresolvedTaglibUris().entrySet()) {
                for (String unresolvedUriForJsp : (Set)entry.getValue()) {
                    this.getLogger().warn("JSP " + (String)entry.getKey() + " has a reference to taglib " + unresolvedUriForJsp + " that is not in the project's dependencies !");
                }
            }
        }
        StringBuilder generatedPackageBuffer = new StringBuilder(256);
        boolean bl = false;
        Map<String, String> importOverrides = this.getPackageImportOverrides();
        if (importOverrides != null) {
            this.getLog().info((CharSequence)("Considering provided Import-Package-Override: " + StringUtils.join(importOverrides.values(), (String)", ")));
        }
        for (String packageImport : parsingContext.getPackageImports()) {
            void var7_13;
            if (importOverrides != null && importOverrides.containsKey(packageImport)) {
                generatedPackageBuffer.append(importOverrides.get(packageImport));
            } else {
                generatedPackageBuffer.append(packageImport);
            }
            if (var7_13 < parsingContext.getPackageImports().size() - 1) {
                generatedPackageBuffer.append(",\n");
            }
            ++var7_13;
        }
        this.getLog().info((CharSequence)("Generated " + parsingContext.getPackageImports().size() + " package imports for project."));
        this.getLog().info((CharSequence)"Found referenced tag library URIs (from JSPs) :");
        for (String taglibUri : parsingContext.getTaglibUris()) {
            boolean externalTagLib;
            boolean foundInDependencies = parsingContext.getTaglibPackages().containsKey(taglibUri);
            String foundMessage = "";
            if (!foundInDependencies) {
                foundMessage = "NOT FOUND";
            }
            if (foundInDependencies && (externalTagLib = ((Boolean)parsingContext.getExternalTaglibs().get(taglibUri)).booleanValue())) {
                foundMessage = foundMessage + " provided";
            }
            this.getLog().info((CharSequence)("  " + taglibUri + " " + foundMessage));
        }
        StringBuilder contentTypeDefinitionsBuffer = new StringBuilder(256);
        if (parsingContext.getContentTypeDefinitions().size() > 0) {
            contentTypeDefinitionsBuffer.append("com.jahia.services.content; nodetypes:List<String>=\"");
            boolean bl2 = false;
            for (String contentTypeName : parsingContext.getContentTypeDefinitions()) {
                void var7_15;
                contentTypeDefinitionsBuffer.append(contentTypeName);
                if (var7_15 < parsingContext.getContentTypeDefinitions().size() - 1) {
                    contentTypeDefinitionsBuffer.append(",");
                }
                ++var7_15;
            }
            contentTypeDefinitionsBuffer.append("\"");
        }
        if (this.contentDefinitionCapabilitiesActivated) {
            this.getLog().info((CharSequence)("Found " + parsingContext.getContentTypeDefinitions().size() + " new content node type definitions in project."));
            this.getLog().debug((CharSequence)("Provide-Capability: " + contentTypeDefinitionsBuffer.toString()));
            this.project.getProperties().put("jahia.plugin.providedNodeTypes", contentTypeDefinitionsBuffer.toString());
        } else {
            this.project.getProperties().put("jahia.plugin.providedNodeTypes", "");
        }
        StringBuffer contentTypeReferencesBuffer = new StringBuffer();
        if (parsingContext.getContentTypeReferences().size() > 0) {
            boolean bl3 = false;
            for (String contentTypeReference : parsingContext.getContentTypeReferences()) {
                void var7_17;
                contentTypeReferencesBuffer.append("com.jahia.services.content; filter:=\"(nodetypes=" + contentTypeReference + ")\"");
                if (var7_17 < parsingContext.getContentTypeReferences().size() - 1) {
                    contentTypeReferencesBuffer.append(",");
                }
                ++var7_17;
            }
        }
        if (this.contentDefinitionCapabilitiesActivated) {
            this.getLog().info((CharSequence)("Found " + parsingContext.getContentTypeReferences().size() + " content node type definitions referenced in project."));
            this.getLog().debug((CharSequence)("Require-Capability: " + contentTypeReferencesBuffer.toString()));
            this.project.getProperties().put("jahia.plugin.requiredNodeTypes", contentTypeReferencesBuffer.toString());
        } else {
            this.project.getProperties().put("jahia.plugin.requiredNodeTypes", "");
        }
        String generatedPackageList = generatedPackageBuffer.toString();
        this.project.getProperties().put("jahia.plugin.projectPackageImport", generatedPackageList);
        this.getLog().debug((CharSequence)"Set project property jahia.plugin.projectPackageImport to package import list value: ");
        this.getLog().debug((CharSequence)generatedPackageList);
        if (this.propertiesOutputFile != null) {
            String[] extraCapabilitiesPropertyValue = new String[]{contentTypeDefinitionsBuffer.toString()};
            try {
                PropertyFileUtils.updatePropertyFile((File)this.propertiesInputFile, (File)this.propertiesOutputFile, (String)this.systemExtraCapabilitiesPropertyName, (String[])extraCapabilitiesPropertyValue, (Logger)new SLF4JLoggerToMojoLogBridge(this.getLog()));
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Error saving extra system capabilities to file " + this.propertiesOutputFile));
            }
        }
        this.getLog().info((CharSequence)("Took " + (System.currentTimeMillis() - startTime) + " ms for the dependencies analysis"));
    }

    private Map<String, String> getPackageImportOverrides() {
        HashMap<String, String> overrides = null;
        String importPackageOverride = null;
        try {
            importPackageOverride = ((Xpp3Dom)this.project.getPlugin("org.apache.felix:maven-bundle-plugin").getConfiguration()).getChild("instructions").getChild("Import-Package-Override").getValue();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (StringUtils.isNotEmpty(importPackageOverride)) {
            overrides = new HashMap<String, String>();
            for (String token : StringUtils.split((String)importPackageOverride, (String)",\n\r")) {
                if ((token = token.trim()).length() <= 0) continue;
                overrides.put(token.contains(";") ? StringUtils.substringBefore((String)token, (String)";").trim() : token, token);
            }
        }
        return overrides != null && !overrides.isEmpty() ? overrides : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readArtifactsToSkip(ParsingContext parsingContext) {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("dependenciesToSkip.txt");
        try {
            for (String dependency : IOUtils.readLines((InputStream)is)) {
                String d = dependency.trim();
                if (d.length() <= 0) continue;
                this.artifactsToSkip.add(d);
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Unable to read dependenciesToSkip.txt", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        this.getLog().info((CharSequence)(this.artifactsToSkip.size() + " artifacts will be skipped (as configured in the dependenciesToSkip.txt)"));
    }

    private void processProjectPackageEntry(String entry, String fileSeparator, ParsingContext parsingContext) {
        int lastSlash = entry.lastIndexOf(fileSeparator);
        if (lastSlash == -1) {
            return;
        }
        String entryPackage = StringUtils.replace((String)entry.substring(0, lastSlash), (String)fileSeparator, (String)".");
        if (!(!StringUtils.isNotEmpty((String)entryPackage) || parsingContext.getProjectPackages().contains(entryPackage) || entryPackage.startsWith("META-INF") || entryPackage.startsWith("OSGI-INF") || entryPackage.startsWith("OSGI-OPT") || entryPackage.startsWith("WEB-INF") || entryPackage.startsWith("org.osgi"))) {
            parsingContext.getProjectPackages().add(entryPackage);
        }
    }

    private void scanClassesBuildDirectory(ParsingContext parsingContext) throws IOException {
        String[] includedFiles;
        File outputDirectoryFile = new File(this.projectOutputDirectory);
        if (!outputDirectoryFile.exists()) {
            this.getLog().warn((CharSequence)("Couldn't scan project output directory " + outputDirectoryFile + " because it doesn't exist !"));
            return;
        }
        this.getLog().info((CharSequence)("Scanning project build directory " + outputDirectoryFile.getCanonicalPath()));
        DirectoryScanner ds = new DirectoryScanner();
        String[] excludes = new String[]{"META-INF/**", "OSGI-INF/**", "OSGI-OPT/**", "WEB-INF/**"};
        ds.setExcludes(excludes);
        ds.setBasedir(outputDirectoryFile);
        ds.setCaseSensitive(true);
        ds.scan();
        for (String includedFile : includedFiles = ds.getIncludedFiles()) {
            this.processProjectPackageEntry(includedFile, File.separator, parsingContext);
        }
    }

    private void buildExclusionPatterns(ParsingContext parsingContext) {
        if (this.artifactExcludes != null) {
            for (String artifactExclude : this.artifactExcludes) {
                int colonPos = artifactExclude.indexOf(":");
                String groupPattern = ".*";
                String artifactPattern = null;
                if (colonPos > -1) {
                    groupPattern = artifactExclude.substring(0, colonPos);
                    artifactPattern = artifactExclude.substring(colonPos + 1);
                } else {
                    artifactPattern = artifactExclude;
                }
                groupPattern = groupPattern.replaceAll("\\.", "\\\\.");
                groupPattern = groupPattern.replaceAll("\\*", ".*");
                artifactPattern = artifactPattern.replaceAll("\\.", "\\\\.");
                artifactPattern = artifactPattern.replaceAll("\\*", ".*");
                this.artifactExclusionPatterns.add(Pattern.compile(groupPattern + ":" + artifactPattern));
            }
        }
        if (this.artifactExclusionPatterns.size() > 0) {
            this.getLog().info((CharSequence)("Configured " + this.artifactExclusionPatterns.size() + " artifact exclusions for scanning project dependencies: " + this.artifactExclusionPatterns.toArray()));
        } else {
            this.getLog().info((CharSequence)"No artifact exclusions specified. Will scan all related dependencies of the project.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int scanDependencies(ParsingContext parsingContext) throws IOException {
        this.getLog().info((CharSequence)"Scanning project dependencies...");
        int scanned = 0;
        for (Artifact artifact : this.project.getArtifacts()) {
            if (!DEPENDENCIES_SCAN_PACKAGING.contains(artifact.getType()) || !DEPENDENCIES_SCAN_SCOPES.contains(artifact.getScope()) || this.isExcludedFromScan(artifact)) continue;
            boolean externalDependency = "provided".equals(artifact.getScope());
            long timer = System.currentTimeMillis();
            int scannedInJar = this.scanJar(artifact.getFile(), externalDependency, "war".equals(artifact.getType()) ? "WEB-INF/classes/" : "", parsingContext);
            long took = System.currentTimeMillis() - timer;
            if (this.getLog().isInfoEnabled() && scannedInJar > 0) {
                this.getLog().info((CharSequence)("Processed " + scannedInJar + (scanned == 1 ? " entry" : " entries") + " in " + (externalDependency ? "external " : "") + "dependency " + artifact + " in " + took + " ms"));
            }
            if (scannedInJar == 0 && !externalDependency) {
                this.dependenciesThatCanBeSkipped.add(artifact.toString());
            }
            ++scanned;
        }
        if (this.dependenciesThatCanBeSkipped.size() > 0) {
            File fld = new File(this.projectOutputDirectory).getParentFile();
            fld.mkdirs();
            File dependenciesFile = new File(fld, "dependenciesToSkip.txt");
            this.getLog().info((CharSequence)(this.dependenciesThatCanBeSkipped.size() + " dependencies could have been skipped" + " as they do not contain TLDs or other processable resources." + " See " + dependenciesFile + " for details."));
            FileOutputStream os = new FileOutputStream(dependenciesFile);
            try {
                IOUtils.writeLines(this.dependenciesThatCanBeSkipped, (String)"\n", (OutputStream)os);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)os);
            }
        }
        return scanned;
    }

    private boolean isExcludedFromScan(Artifact artifact) {
        String id = StringUtils.substringBeforeLast((String)artifact.toString(), (String)":");
        if (this.artifactsToSkip.contains(id) || id.contains(":") && this.artifactsToSkip.contains(StringUtils.substringBeforeLast((String)id, (String)":"))) {
            return true;
        }
        for (Pattern exclusionPattern : this.artifactExclusionPatterns) {
            Matcher exclusionMatcher = exclusionPattern.matcher(id = artifact.getGroupId() + ":" + artifact.getArtifactId());
            if (!exclusionMatcher.matches()) continue;
            this.getLog().info((CharSequence)("Ignoring artifact as the exclusion matched for " + id));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int scanJar(File jarFile, boolean externalDependency, String packageDirectory, ParsingContext parsingContext) throws IOException {
        int scanned = 0;
        JarInputStream jarInputStream = new JarInputStream(new FileInputStream(jarFile));
        try {
            JarEntry jarEntry = null;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                if (jarEntry.isDirectory()) continue;
                String entryName = jarEntry.getName();
                String ext = FileUtils.getExtension((String)entryName).toLowerCase();
                if (!externalDependency && entryName.startsWith(packageDirectory)) {
                    entryName = entryName.substring(packageDirectory.length());
                    this.processProjectPackageEntry(entryName, "/", parsingContext);
                }
                if (!"tld".equals(ext) && (!SUPPORTED_FILE_EXTENSIONS_TO_SCAN.contains(ext) || externalDependency) || entryName.endsWith("/pom.xml")) continue;
                ByteArrayOutputStream entryOutputStream = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)jarInputStream, (OutputStream)entryOutputStream);
                if ("tld".equals(ext)) {
                    this.getLog().debug((CharSequence)("\tscanning entry: " + jarEntry.getName()));
                    Parsers.getInstance().parse(0, jarEntry.getName(), (InputStream)new ByteArrayInputStream(entryOutputStream.toByteArray()), parsingContext, externalDependency, this.getLogger());
                    ++scanned;
                }
                if (externalDependency || !SUPPORTED_FILE_EXTENSIONS_TO_SCAN.contains(ext)) continue;
                this.getLog().debug((CharSequence)("\tscanning entry: " + jarEntry.getName()));
                if (!this.processNonTldFile(jarEntry.getName(), new ByteArrayInputStream(entryOutputStream.toByteArray()), parsingContext)) continue;
                ++scanned;
            }
        }
        finally {
            jarInputStream.close();
        }
        if (parsingContext.getAdditionalFilesToParse().size() > 0) {
            this.getLog().debug((CharSequence)"Processing additional files to parse...");
            JarFile jar = new JarFile(jarFile);
            for (String fileToParse : parsingContext.getAdditionalFilesToParse()) {
                JarEntry jarEntry = jar.getJarEntry(fileToParse);
                if (jarEntry != null) {
                    InputStream jarEntryInputStream = jar.getInputStream(jarEntry);
                    ByteArrayOutputStream entryOutputStream = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)jarEntryInputStream, (OutputStream)entryOutputStream);
                    if (this.processNonTldFile(jarEntry.getName(), new ByteArrayInputStream(entryOutputStream.toByteArray()), parsingContext)) {
                        ++scanned;
                    }
                    IOUtils.closeQuietly((InputStream)jarEntryInputStream);
                    continue;
                }
                this.getLog().warn((CharSequence)("Couldn't find additional file to parse " + fileToParse + " in JAR " + jarFile));
            }
            parsingContext.getAdditionalFilesToParse().clear();
        }
        return scanned;
    }

    private void processDirectoryTlds(File directoryFile, ParsingContext parsingContext) throws IOException {
        String[] includedFiles;
        DirectoryScanner ds = new DirectoryScanner();
        String[] excludes = this.excludeFromDirectoryScan.toArray(new String[this.excludeFromDirectoryScan.size()]);
        ds.setExcludes(excludes);
        ds.setIncludes(new String[]{"**/*.tld"});
        ds.setBasedir(directoryFile);
        ds.setCaseSensitive(true);
        ds.scan();
        for (String includedFile : includedFiles = ds.getIncludedFiles()) {
            Parsers.getInstance().parse(0, includedFile, (InputStream)new BufferedInputStream(new FileInputStream(new File(directoryFile, includedFile))), parsingContext, false, this.getLogger());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDirectory(File directoryFile, ParsingContext parsingContext) throws IOException {
        String[] includedFiles;
        DirectoryScanner ds = new DirectoryScanner();
        String[] excludes = this.excludeFromDirectoryScan.toArray(new String[this.excludeFromDirectoryScan.size()]);
        ds.setExcludes(excludes);
        ds.setBasedir(directoryFile);
        ds.setCaseSensitive(true);
        ds.scan();
        for (String includedFile : includedFiles = ds.getIncludedFiles()) {
            String ext = FileUtils.getExtension((String)includedFile).toLowerCase();
            if (!SUPPORTED_FILE_EXTENSIONS_TO_SCAN.contains(ext)) continue;
            BufferedInputStream fileInputStream = null;
            try {
                fileInputStream = new BufferedInputStream(new FileInputStream(new File(directoryFile, includedFile)));
                this.processNonTldFile(includedFile, fileInputStream, parsingContext);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
    }

    private boolean processNonTldFile(String fileName, InputStream inputStream, ParsingContext parsingContext) throws IOException {
        String ext = FileUtils.getExtension((String)fileName).toLowerCase();
        if (!SUPPORTED_FILE_EXTENSIONS_TO_SCAN.contains(ext)) {
            return false;
        }
        return Parsers.getInstance().parse(1, fileName, inputStream, parsingContext, false, this.getLogger());
    }

    private Logger getLogger() {
        return this.logger;
    }
}

