/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.osgi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jahia.utils.osgi.ClassDependencyTracker;

public class FindPackageUsesMojo
extends AbstractMojo {
    protected List<String> packageNames = new ArrayList<String>();
    protected MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.packageNames == null || this.packageNames.size() == 0) {
            this.getLog().warn((CharSequence)"No package names specified, will abort now !");
            return;
        }
        this.getLog().info((CharSequence)"Scanning project dependencies...");
        TreeMap packageResults = new TreeMap();
        for (Artifact artifact : this.project.getArtifacts()) {
            if (artifact.isOptional()) {
                this.getLog().debug((CharSequence)("Processing optional dependency " + artifact + "..."));
            }
            if (!artifact.getType().equals("jar")) {
                this.getLog().warn((CharSequence)("Found non JAR artifact " + artifact));
            }
            boolean currentTrailWasDisplayed = false;
            int trailDepth = artifact.getDependencyTrail().size();
            for (String packageName : this.packageNames) {
                Set<String> classesThatHaveDependency;
                TreeMap<String, Artifact> foundClasses = (TreeMap<String, Artifact>)packageResults.get(packageName);
                if (foundClasses == null) {
                    foundClasses = new TreeMap<String, Artifact>();
                }
                if (!((classesThatHaveDependency = this.findClassesThatUsePackage(artifact.getFile(), packageName)) != null & classesThatHaveDependency.size() > 0)) continue;
                ArrayList<String> trail = new ArrayList<String>(artifact.getDependencyTrail());
                if (artifact.isOptional()) {
                    trail.add("[optional]");
                }
                for (String classThatHasDependency : classesThatHaveDependency) {
                    if (!currentTrailWasDisplayed) {
                        this.displayTrailTree(this.project, artifact);
                        currentTrailWasDisplayed = true;
                    }
                    this.getLog().info((CharSequence)(this.getPaddingString(trailDepth) + "+--> Found class " + classThatHasDependency + " that uses package " + packageName));
                    foundClasses.put(classThatHasDependency, artifact);
                }
                packageResults.put(packageName, foundClasses);
            }
        }
        this.getLog().info((CharSequence)"=================================================================================");
        this.getLog().info((CharSequence)"SEARCH RESULTS SUMMARY");
        this.getLog().info((CharSequence)"---------------------------------------------------------------------------------");
        for (String packageName : this.packageNames) {
            if (!packageResults.containsKey(packageName)) {
                this.getLog().warn((CharSequence)("Couldn't find " + packageName + " uses anywhere !"));
                continue;
            }
            this.getLog().info((CharSequence)("Package " + packageName + " used in classes :"));
            Map foundClasses = (Map)packageResults.get(packageName);
            for (Map.Entry foundClass : foundClasses.entrySet()) {
                this.getLog().info((CharSequence)("  " + (String)foundClass.getKey() + " ( " + ((Artifact)foundClass.getValue()).getFile() + ")"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> findClassesThatUsePackage(File jarFile, String packageName) {
        Set<String> classesThatHaveDependency = new TreeSet<String>();
        InputStream jarInputStream = null;
        if (jarFile == null) {
            this.getLog().warn((CharSequence)"File is null !");
            return classesThatHaveDependency;
        }
        if (!jarFile.exists()) {
            this.getLog().warn((CharSequence)("File " + jarFile + " does not exist !"));
            return classesThatHaveDependency;
        }
        this.getLog().debug((CharSequence)("Scanning JAR " + jarFile + "..."));
        try {
            classesThatHaveDependency = ClassDependencyTracker.findDependencyInJar((File)jarFile, (String)packageName, (List)this.project.getTestClasspathElements());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DependencyResolutionRequiredException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(jarInputStream);
        }
        return classesThatHaveDependency;
    }

    private void displayTrailTree(MavenProject project, Artifact artifact) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (String trailEntry : artifact.getDependencyTrail()) {
            builder.append(trailEntry);
            Artifact dependencyArtifact = this.findArtifactInProject(project, trailEntry);
            if (dependencyArtifact != null) {
                if (dependencyArtifact.isOptional()) {
                    builder.append(" [OPTIONAL]");
                }
                if (dependencyArtifact.getScope() != null && dependencyArtifact.getScope().contains("provided")) {
                    builder.append(" [PROVIDED]");
                }
            }
            if (i < artifact.getDependencyTrail().size() - 1) {
                this.getLog().info((CharSequence)builder.toString());
                builder = new StringBuilder();
                builder.append(this.getPaddingString(i));
                builder.append("+- ");
            }
            ++i;
        }
        builder.append(" (" + artifact.getFile() + ") : ");
        this.getLog().info((CharSequence)builder.toString());
    }

    private Artifact findArtifactInProject(MavenProject project, String artifactIdentifier) {
        ArrayList<Artifact> results = new ArrayList<Artifact>();
        if (this.artifactMatches(project.getArtifact(), artifactIdentifier)) {
            results.add(project.getArtifact());
        }
        for (Artifact artifact : project.getArtifacts()) {
            if (!this.artifactMatches(artifact, artifactIdentifier)) continue;
            results.add(artifact);
        }
        if (results.size() > 1) {
            this.getLog().warn((CharSequence)("Found more than one matching dependency for identifier " + artifactIdentifier + ":"));
            for (Artifact resultArtifact : results) {
                this.getLog().warn((CharSequence)(" --> " + resultArtifact.toString()));
            }
            return null;
        }
        if (results.size() == 1) {
            return (Artifact)results.get(0);
        }
        this.getLog().warn((CharSequence)("Couldn't find project dependency for identifier " + artifactIdentifier + "!"));
        return null;
    }

    private boolean artifactMatches(Artifact artifact, String artifactIdentifier) {
        String[] artifactIdentifierParts = artifactIdentifier.split(":");
        String artifactGroupId = null;
        String artifactId = null;
        String artifactType = null;
        String artifactClassifier = null;
        String artifactVersion = null;
        artifactGroupId = artifactIdentifierParts[0];
        artifactId = artifactIdentifierParts[1];
        if (artifactIdentifierParts.length >= 5) {
            artifactType = artifactIdentifierParts[2];
            artifactClassifier = artifactIdentifierParts[3];
            artifactVersion = artifactIdentifierParts[4];
        } else {
            if (artifactIdentifierParts.length > 2) {
                artifactType = artifactIdentifierParts[2];
            }
            if (artifactIdentifierParts.length > 3) {
                artifactVersion = artifactIdentifierParts[3];
            }
        }
        if (!artifact.getGroupId().equals(artifactGroupId)) {
            return false;
        }
        if (!artifact.getArtifactId().equals(artifactId)) {
            return false;
        }
        if (artifactType != null && !artifact.getType().equals(artifactType)) {
            System.out.print(artifact.toString() + " == " + artifactIdentifier + " ? ");
            System.out.println("Type didn't match : " + artifact.getType() + " != " + artifactType);
            return false;
        }
        if (artifactClassifier != null && !artifactClassifier.equals(artifact.getClassifier())) {
            System.out.print(artifact.toString() + " == " + artifactIdentifier + " ? ");
            System.out.println("Classifier didn't match : " + artifact.getClassifier() + " != " + artifactClassifier);
            return false;
        }
        if (artifactVersion != null && !artifact.getBaseVersion().equals(artifactVersion)) {
            System.out.print(artifact.toString() + " == " + artifactIdentifier + " ? ");
            System.out.println("Version didn't match : " + artifact.getVersion() + " != " + artifactVersion);
            return false;
        }
        return true;
    }

    private String getPaddingString(int i) {
        StringBuilder builder = new StringBuilder();
        for (int j = 0; j < i; ++j) {
            builder.append("  ");
        }
        return builder.toString();
    }

    private String getTrail(Artifact artifact) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (String trailEntry : artifact.getDependencyTrail()) {
            builder.append(trailEntry);
            if (i < artifact.getDependencyTrail().size() - 1) {
                builder.append(" -> ");
            }
            ++i;
        }
        builder.append(" (" + artifact.getFile() + ") ");
        return builder.toString();
    }
}

