/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.osgi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.DependencyVisitor;
import org.sonatype.aether.graph.Exclusion;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.DependencyRequest;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.util.artifact.DefaultArtifact;

public class FindPackagesMojo
extends AbstractMojo {
    protected List<String> packageNames = new ArrayList<String>();
    protected MavenProject project;
    private RepositorySystem repoSystem;
    private RepositorySystemSession repoSession;
    private List<RemoteRepository> remoteRepos;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.packageNames == null || this.packageNames.size() == 0) {
            this.getLog().warn((CharSequence)"No package names specified, will abort now !");
            return;
        }
        this.getLog().info((CharSequence)"Scanning project dependencies...");
        HashMap<String, List<String>> foundPackages = new HashMap<String, List<String>>();
        for (org.apache.maven.artifact.Artifact artifact : this.project.getArtifacts()) {
            if (artifact.isOptional()) {
                this.getLog().debug((CharSequence)("Processing optional dependency " + artifact + "..."));
            }
            if (!artifact.getType().equals("jar")) {
                this.getLog().warn((CharSequence)("Found non JAR artifact " + artifact));
            }
            for (String packageName : this.packageNames) {
                if (!this.doesJarHavePackageName(artifact.getFile(), packageName)) continue;
                ArrayList<String> trail = new ArrayList<String>(artifact.getDependencyTrail());
                if (artifact.isOptional()) {
                    trail.add("[optional]");
                }
                this.getLog().info((CharSequence)("Found package " + packageName + " in " + this.getTrail(trail)));
                foundPackages.put(packageName, trail);
            }
        }
        for (String packageName : this.packageNames) {
            if (foundPackages.containsKey(packageName)) continue;
            this.getLog().warn((CharSequence)("Couldn't find " + packageName + " in normal project dependencies, will now search optional (and excluded) dependencies"));
            for (org.apache.maven.artifact.Artifact artifact : this.project.getArtifacts()) {
                DependencyNode dependencyNode;
                if (artifact.isOptional()) {
                    this.getLog().debug((CharSequence)("Processing optional artifact " + artifact + "..."));
                }
                if ((dependencyNode = this.getDependencyNode(artifact)) == null) continue;
                ArrayList<String> trail = new ArrayList<String>(artifact.getDependencyTrail());
                dependencyNode.accept((DependencyVisitor)new PackagerFinderDependencyVisitor(packageName, foundPackages, false, trail));
            }
        }
        this.getLog().info((CharSequence)"=================================================================================");
        this.getLog().info((CharSequence)"SEARCH RESULTS");
        this.getLog().info((CharSequence)"---------------------------------------------------------------------------------");
        for (String packageName : this.packageNames) {
            if (!foundPackages.containsKey(packageName)) {
                this.getLog().warn((CharSequence)("Couldn't find " + packageName + " anywhere !"));
                continue;
            }
            this.getLog().info((CharSequence)("Found package " + packageName + " in " + this.getTrail((List)foundPackages.get(packageName))));
        }
    }

    private DependencyNode getDependencyNode(org.apache.maven.artifact.Artifact artifact) {
        String artifactCoords = artifact.getGroupId() + ":" + artifact.getArtifactId();
        if (StringUtils.isNotEmpty((String)artifact.getType()) && !"*".equals(artifact.getType())) {
            artifactCoords = artifactCoords + ":" + artifact.getType();
        }
        if (StringUtils.isNotEmpty((String)artifact.getBaseVersion()) && !"*".equals(artifact.getBaseVersion())) {
            artifactCoords = artifactCoords + ":" + artifact.getBaseVersion();
        }
        return this.getDependencyNode(artifactCoords);
    }

    private DependencyNode resolveExclusion(DependencyNode dependencyNode, Exclusion exclusion) {
        if (dependencyNode.getDependency().getArtifact().getGroupId().equals(exclusion.getGroupId()) && dependencyNode.getDependency().getArtifact().getArtifactId().equals(exclusion.getArtifactId())) {
            return dependencyNode;
        }
        for (DependencyNode childNode : dependencyNode.getChildren()) {
            DependencyNode childDependency = this.resolveExclusion(childNode, exclusion);
            if (childDependency == null) continue;
            return childDependency;
        }
        return null;
    }

    private DependencyNode getDependencyNode(String artifactCoords) {
        ArtifactRequest request = new ArtifactRequest();
        DefaultArtifact aetherArtifact = new DefaultArtifact(artifactCoords);
        request.setArtifact((Artifact)aetherArtifact);
        request.setRepositories(this.remoteRepos);
        Dependency dependency = new Dependency((Artifact)aetherArtifact, "compile");
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(dependency);
        collectRequest.setRepositories(this.remoteRepos);
        DependencyNode dependencyNode = null;
        try {
            dependencyNode = this.repoSystem.collectDependencies(this.repoSession, collectRequest).getRoot();
            DependencyRequest dependencyRequest = new DependencyRequest(dependencyNode, null);
            this.repoSystem.resolveDependencies(this.repoSession, dependencyRequest);
        }
        catch (DependencyCollectionException e) {
            this.getLog().error((CharSequence)("Error collecting dependencies for " + artifactCoords + ": " + e.getMessage()));
        }
        catch (DependencyResolutionException e) {
            this.getLog().error((CharSequence)("Error resolving dependencies for " + artifactCoords + ": " + e.getMessage()));
        }
        return dependencyNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doesJarHavePackageName(File jarFile, String packageName) {
        JarInputStream jarInputStream = null;
        if (jarFile == null) {
            this.getLog().warn((CharSequence)"File is null !");
            return false;
        }
        if (!jarFile.exists()) {
            this.getLog().warn((CharSequence)("File " + jarFile + " does not exist !"));
            return false;
        }
        this.getLog().debug((CharSequence)("Scanning JAR " + jarFile + "..."));
        try {
            jarInputStream = new JarInputStream(new FileInputStream(jarFile));
            JarEntry jarEntry = null;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                String jarPackageName = jarEntry.getName().replaceAll("/", ".");
                if (jarPackageName.endsWith(".")) {
                    jarPackageName = jarPackageName.substring(0, jarPackageName.length() - 1);
                }
                if (!jarPackageName.equals(packageName)) continue;
                boolean bl = true;
                IOUtils.closeQuietly((InputStream)jarInputStream);
                return bl;
            }
            IOUtils.closeQuietly((InputStream)jarInputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(jarInputStream);
        }
        return false;
    }

    private String getTrail(List<String> dependencyTrail) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (String trailEntry : dependencyTrail) {
            builder.append(trailEntry);
            if (i < dependencyTrail.size() - 1) {
                builder.append(" -> ");
            }
            ++i;
        }
        return builder.toString();
    }

    public class PackagerFinderDependencyVisitor
    implements DependencyVisitor {
        private String packageName;
        private Map<String, List<String>> foundPackages;
        private boolean excludedDependency = false;
        private List<String> dependencyTrail = null;

        public PackagerFinderDependencyVisitor(String packageName, Map<String, List<String>> foundPackages, boolean excludedDependency, List<String> dependencyTrail) {
            this.packageName = packageName;
            this.foundPackages = foundPackages;
            this.excludedDependency = excludedDependency;
            this.dependencyTrail = new ArrayList<String>(dependencyTrail);
        }

        public boolean visitEnter(DependencyNode node) {
            if (node.getDependency().getArtifact().getFile() == null) {
                FindPackagesMojo.this.getLog().warn((CharSequence)("No local file for artifact " + node.getDependency().getArtifact()));
                return true;
            }
            if (node.getDependency().isOptional()) {
                FindPackagesMojo.this.getLog().debug((CharSequence)("Processing optional file " + node.getDependency().getArtifact().getFile() + "..."));
            }
            ArrayList<String> curTrail = new ArrayList<String>(this.dependencyTrail);
            String trailSuffix = "";
            if (!this.excludedDependency) {
                if (node.getDependency().isOptional()) {
                    trailSuffix = "[optional]";
                }
            } else {
                trailSuffix = node.getDependency().isOptional() ? "[excluded+optional]" : "[excluded]";
            }
            curTrail.add(node.toString() + trailSuffix);
            String trail = FindPackagesMojo.this.getTrail(this.dependencyTrail);
            if (FindPackagesMojo.this.doesJarHavePackageName(node.getDependency().getArtifact().getFile(), this.packageName)) {
                if (!this.excludedDependency) {
                    if (node.getDependency().isOptional()) {
                        FindPackagesMojo.this.getLog().info((CharSequence)(trail + ": Found package " + this.packageName + " in optional artifact " + node.getDependency().getArtifact().getFile()));
                    } else {
                        FindPackagesMojo.this.getLog().info((CharSequence)(trail + ": Found package " + this.packageName + " in artifact " + node.getDependency().getArtifact().getFile()));
                    }
                } else if (node.getDependency().isOptional()) {
                    FindPackagesMojo.this.getLog().warn((CharSequence)(trail + ": Found package " + this.packageName + " in optional excluded artifact " + node.getDependency().getArtifact().getFile()));
                } else {
                    FindPackagesMojo.this.getLog().warn((CharSequence)(trail + ": Found package " + this.packageName + " in excluded artifact " + node.getDependency().getArtifact().getFile()));
                }
                this.foundPackages.put(this.packageName, curTrail);
            } else {
                for (Exclusion exclusion : node.getDependency().getExclusions()) {
                    FindPackagesMojo.this.getLog().debug((CharSequence)(trail + ": Processing exclusion " + exclusion + " of artifact " + node.getDependency().getArtifact()));
                    DependencyNode exclusionNode = FindPackagesMojo.this.resolveExclusion(node, exclusion);
                    if (exclusionNode == null) continue;
                    exclusionNode.accept((DependencyVisitor)new PackagerFinderDependencyVisitor(this.packageName, this.foundPackages, true, new ArrayList<String>(curTrail)));
                }
            }
            return true;
        }

        public boolean visitLeave(DependencyNode node) {
            return true;
        }
    }
}

