/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.jahia.utils.maven.plugin.contentgenerator.bo.SiteBO;
import org.jahia.utils.maven.plugin.contentgenerator.properties.ContentGeneratorCst;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class SiteService {
    private Log logger = new SystemStreamLog();
    private String sep = System.getProperty("file.separator");

    public File createAndPopulateRepositoryFile(File tempOutputDir, SiteBO site, File pagesFile, File filesFile, File groupsFile, File tagsFile, File mountsFile) throws IOException {
        File repositoryFile = new File(tempOutputDir, "repository.xml");
        FileOutputStream output = new FileOutputStream(repositoryFile, true);
        IOUtils.write((String)site.getHeader(), (OutputStream)output);
        if (mountsFile != null) {
            IOUtils.copy((InputStream)new FileInputStream(mountsFile), (OutputStream)output);
        }
        if (filesFile != null) {
            IOUtils.copy((InputStream)new FileInputStream(filesFile), (OutputStream)output);
        }
        if (groupsFile != null) {
            IOUtils.copy((InputStream)new FileInputStream(groupsFile), (OutputStream)output);
        }
        if (tagsFile != null) {
            IOUtils.copy((InputStream)new FileInputStream(tagsFile), (OutputStream)output);
        }
        if (pagesFile != null) {
            IOUtils.copy((InputStream)new FileInputStream(pagesFile), (OutputStream)output);
        }
        IOUtils.write((String)site.getFooter(), (OutputStream)output);
        return repositoryFile;
    }

    public File createSiteDirectory(String siteKey, File destDir) throws IOException {
        File tempOutputDir = new File(destDir, siteKey);
        if (tempOutputDir.exists()) {
            FileUtils.deleteDirectory((File)tempOutputDir);
        }
        tempOutputDir.mkdir();
        this.logger.debug((CharSequence)("temp directory for site export: " + tempOutputDir.getAbsolutePath()));
        return tempOutputDir;
    }

    public File copyPagesFile(File pagesFile, File tempOutputDir) throws IOException {
        FileUtils.copyFileToDirectory((File)pagesFile, (File)tempOutputDir);
        File copy = new File(tempOutputDir, pagesFile.getName());
        File renamedCopy = new File(tempOutputDir, "repository.xml");
        copy.renameTo(renamedCopy);
        this.logger.debug((CharSequence)("new file containing pages: " + renamedCopy));
        return renamedCopy;
    }

    public File createFilesDirectoryTree(String siteKey, File tempOutputDir) throws IOException {
        String treePath = tempOutputDir + this.sep + "content" + this.sep + "sites" + this.sep + siteKey + this.sep + "files" + this.sep + "contributed";
        File treeFile = new File(treePath);
        FileUtils.forceMkdir((File)treeFile);
        return treeFile;
    }

    public File createPropertiesFile(String siteKey, List<String> languages, String templateSet, File tempOutputDir) throws FileNotFoundException, IOException {
        Properties siteProp = new Properties();
        siteProp.setProperty("sitetitle", siteKey);
        siteProp.setProperty("siteservername", "localhost");
        siteProp.setProperty("sitekey", siteKey);
        siteProp.setProperty("description", "Site generated by Jahia content generator");
        siteProp.setProperty("templatePackageName", templateSet);
        siteProp.setProperty("mixLanguage", Boolean.TRUE.toString());
        siteProp.setProperty("defaultLanguage", languages.get(0));
        siteProp.setProperty("installedModules.1", "default");
        siteProp.setProperty("installedModules.2", templateSet);
        siteProp.setProperty("installedModules.3", "publication");
        for (String language : languages) {
            siteProp.setProperty("language." + language + ".activated", Boolean.TRUE.toString());
            siteProp.setProperty("language." + language + ".mandatory", Boolean.FALSE.toString());
        }
        File propFile = new File(tempOutputDir, "site.properties");
        siteProp.store(new FileOutputStream(propFile), "Site generated by Jahia content generator");
        return propFile;
    }

    public Document insertGroupsIntoSiteRepository(Document repository, String siteKey, Element groups) {
        Element siteNode = repository.getRootElement().getChild("sites").getChild(siteKey);
        siteNode.addContent((Content)groups);
        return repository;
    }

    public Document createSystemSiteRepository() {
        this.logger.info((CharSequence)"Initialization of system site repository");
        Document systemSiteRepository = new Document();
        Element contentNode = new Element("content");
        contentNode.addNamespaceDeclaration(ContentGeneratorCst.NS_JCR);
        contentNode.addNamespaceDeclaration(ContentGeneratorCst.NS_JNT);
        contentNode.addNamespaceDeclaration(ContentGeneratorCst.NS_JMIX);
        contentNode.addNamespaceDeclaration(ContentGeneratorCst.NS_J);
        contentNode.addNamespaceDeclaration(ContentGeneratorCst.NS_NT);
        contentNode.addNamespaceDeclaration(ContentGeneratorCst.NS_SV);
        contentNode.addNamespaceDeclaration(ContentGeneratorCst.NS_MIX);
        contentNode.addNamespaceDeclaration(ContentGeneratorCst.NS_DOCNT);
        systemSiteRepository.setRootElement(contentNode);
        Element sitesNode = new Element("sites");
        sitesNode.setAttribute("primaryType", "jnt:virtualsitesFolder", ContentGeneratorCst.NS_JCR);
        contentNode.addContent((Content)sitesNode);
        Element systemSiteNode = new Element("systemsite");
        systemSiteNode.setAttribute("primaryType", "jnt:virtualsite", ContentGeneratorCst.NS_JCR);
        sitesNode.addContent((Content)systemSiteNode);
        return systemSiteRepository;
    }
}

