/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.mojo;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jahia.utils.maven.plugin.contentgenerator.FileService;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ExportBO;
import org.jahia.utils.maven.plugin.contentgenerator.properties.DatabaseProperties;

public abstract class AbstractContentGeneratorMojo
extends AbstractMojo {
    protected String mysql_host;
    protected String mysql_login;
    protected String mysql_password;
    protected String mysql_port = "3306";
    protected String mysql_db;
    protected String mysql_table;
    protected String outputDirectory;
    protected String outputFileName;
    protected String poolDirectory;

    public abstract void execute() throws MojoExecutionException, MojoFailureException;

    protected ExportBO initExport() throws MojoExecutionException {
        ExportBO export = new ExportBO();
        DatabaseProperties.HOSTNAME = this.mysql_host;
        DatabaseProperties.PORT = this.mysql_port;
        if (this.mysql_db == null) {
            throw new MojoExecutionException("No database name provided");
        }
        DatabaseProperties.DATABASE = this.mysql_db;
        if (this.mysql_login == null) {
            throw new MojoExecutionException("No database user provided");
        }
        DatabaseProperties.USER = this.mysql_login;
        if (this.mysql_password == null) {
            throw new MojoExecutionException("No database user password provided");
        }
        DatabaseProperties.PASSWORD = this.mysql_password;
        if (this.mysql_table == null) {
            this.getLog().info((CharSequence)"No MySQL table name provided, uses default \"articles\"");
            DatabaseProperties.TABLE = "articles";
        } else {
            DatabaseProperties.TABLE = this.mysql_table;
        }
        if (this.outputDirectory == null) {
            throw new MojoExecutionException("outputDirectory property can not be null");
        }
        File fOutputDirectory = new File(this.outputDirectory);
        if (!fOutputDirectory.exists()) {
            fOutputDirectory.mkdirs();
        } else {
            try {
                this.getLog().info((CharSequence)"Deleting output directory");
                FileUtils.deleteDirectory((File)fOutputDirectory);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Can not delete output directory");
                e.printStackTrace();
            }
            fOutputDirectory.mkdir();
        }
        File outputFile = new File(this.outputDirectory, this.outputFileName);
        export.setOutputFile(outputFile);
        export.setOutputDir(this.outputDirectory);
        String sep = System.getProperty("file.separator");
        File tmp = new File(this.outputDirectory + sep + "tmp");
        tmp.mkdir();
        ExportBO.tmp = tmp;
        File outputMapFile = new File(this.outputDirectory, "sitemap.txt");
        export.setMapFile(outputMapFile);
        if (!export.isDisableInternalFileReference()) {
            if (this.poolDirectory == null) {
                throw new MojoExecutionException("Pool directory property can not be null");
            }
            File fPoolDirectory = new File(this.poolDirectory);
            if (!fPoolDirectory.exists()) {
                fPoolDirectory.mkdirs();
            }
            export.setFilesDirectory(fPoolDirectory);
            FileService fileService = new FileService();
            List<String> filesNamesAvailable = fileService.getFileNamesAvailable(export.getFilesDirectory());
            export.setFileNames(filesNamesAvailable);
        }
        return export;
    }

    protected ExportBO initFilesProperties(ExportBO export) throws MojoExecutionException {
        return export;
    }
}

