/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.mojo;

import java.util.Arrays;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.StringUtils;
import org.jahia.utils.maven.plugin.contentgenerator.ContentGeneratorService;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ExportBO;
import org.jahia.utils.maven.plugin.contentgenerator.mojo.AbstractJahiaSiteMojo;
import org.jahia.utils.maven.plugin.contentgenerator.properties.ContentGeneratorCst;
import org.w3c.dom.DOMException;

public class GenerateSiteMojo
extends AbstractJahiaSiteMojo {
    protected Integer numberOfBigTextPerPage;
    protected Integer numberOfGroups;
    protected Integer numberOfUsersPerGroup;
    protected double groupAclRatio;
    protected double usersAclRatio;
    protected Integer numberOfSites;
    protected Boolean visibilityEnabled;
    protected String visibilityStartDate;
    protected String visibilityEndDate;
    protected Boolean pagesHaveVanity;
    protected String siteLanguages;
    protected String addFiles;
    protected Integer nbPagesOnTopLevel;
    protected Integer nbSubLevels;
    protected Integer nbPagesPerLevel;
    protected Integer percentagePagesWithTplList;
    protected Integer percentagePagesWithTplQuery;
    protected String cmisUrl;
    protected String cmisUser;
    protected String cmisPassword;
    protected String cmisRepositoryId;
    protected String cmisSiteName;
    protected Integer cmisNbAvailableFiles;
    protected boolean disableInternalFileReference;
    protected boolean disableExternalFileReference;

    @Override
    protected ExportBO initExport() throws MojoExecutionException {
        ContentGeneratorService contentGeneratorService = ContentGeneratorService.getInstance();
        ExportBO export = super.initExport();
        export.setNbPagesTopLevel(this.nbPagesOnTopLevel);
        export.setNbSubLevels(this.nbSubLevels);
        export.setNbSubPagesPerPage(this.nbPagesPerLevel);
        export.setNumberOfBigTextPerPage(this.numberOfBigTextPerPage);
        export.setNumberOfGroups(this.numberOfGroups);
        export.setNumberOfUsersPerGroup(this.numberOfUsersPerGroup);
        export.setGroupAclRatio(this.groupAclRatio);
        export.setUsersAclRatio(this.usersAclRatio);
        export.setNumberOfSites(this.numberOfSites);
        export.setPagesHaveVanity(this.pagesHaveVanity);
        export.setPercentagePagesWithTplList(this.percentagePagesWithTplList);
        export.setPercentagePagesWithTplQuery(this.percentagePagesWithTplQuery);
        export.setCmisUrl(this.cmisUrl);
        export.setCmisUser(this.cmisUser);
        export.setCmisPassword(this.cmisPassword);
        export.setCmisRepositoryId(this.cmisRepositoryId);
        export.setCmisSiteName(this.cmisSiteName);
        export.setDisableExternalFileReference(this.disableExternalFileReference);
        export.setDisableInternalFileReference(this.disableInternalFileReference);
        String[] aLanguages = StringUtils.split((String)this.siteLanguages, (String)",");
        export.setSiteLanguages(Arrays.asList(aLanguages));
        if (this.visibilityEnabled == null) {
            this.visibilityEnabled = Boolean.FALSE;
        }
        export.setVisibilityEnabled(this.visibilityEnabled);
        export.setVisibilityStartDate(this.visibilityStartDate);
        export.setVisibilityEndDate(this.visibilityEndDate);
        Integer totalPages = contentGeneratorService.getTotalNumberOfPagesNeeded(this.nbPagesOnTopLevel, this.nbSubLevels, this.nbPagesPerLevel);
        export.setTotalPages(totalPages);
        if (this.percentagePagesWithTplList > 0) {
            export.setNbPagesWithTplList(new Integer(totalPages / this.percentagePagesWithTplList));
        } else {
            export.setNbPagesWithTplList(0);
        }
        if (this.percentagePagesWithTplQuery > 0) {
            export.setNbPagesWithTplQuery(new Integer(totalPages / this.percentagePagesWithTplQuery));
        } else {
            export.setNbPagesWithTplQuery(0);
        }
        return export;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        ContentGeneratorService contentGeneratorService = ContentGeneratorService.getInstance();
        ExportBO export = this.initExport();
        if (export.getTotalPages().compareTo(ContentGeneratorCst.MAX_TOTAL_PAGES) > 0) {
            throw new MojoExecutionException("You asked to generate " + export.getTotalPages() + " pages, the maximum allowed is " + ContentGeneratorCst.MAX_TOTAL_PAGES);
        }
        this.getLog().info((CharSequence)"Jahia content generator starts");
        this.getLog().info((CharSequence)(export.getSiteKey() + " site will be created"));
        String zipFilePath = null;
        try {
            zipFilePath = contentGeneratorService.generateSites(export);
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        this.getLog().info((CharSequence)("Site archive created and available here: " + zipFilePath));
    }
}

