/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.wise.bo;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.jahia.utils.maven.plugin.contentgenerator.properties.ContentGeneratorCst;
import org.jahia.utils.maven.plugin.contentgenerator.wise.bo.FileBO;
import org.jdom.Content;
import org.jdom.Element;

public class FolderBO
implements Serializable,
Comparable<FolderBO> {
    private static final long serialVersionUID = 1L;
    Element folderElement;
    String folderName;
    List<FolderBO> subFolders;
    Set<FileBO> files;

    public FolderBO(String folderName, List<FolderBO> subFolders, Set<FileBO> files) {
        this.folderName = folderName;
        this.subFolders = subFolders;
        this.files = files;
    }

    public Set<FileBO> getFiles() {
        return this.files;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public List<FolderBO> getSubFolders() {
        return this.subFolders;
    }

    public Element getElement() {
        if (this.folderElement == null) {
            this.folderElement = new Element(this.folderName);
            this.folderElement.setAttribute("mixinTypes", "docmix:docspaceFolder", ContentGeneratorCst.NS_JCR);
            this.folderElement.setAttribute("primaryType", "jnt:folder", ContentGeneratorCst.NS_JCR);
            if (this.files != null) {
                for (FileBO file : this.files) {
                    this.folderElement.addContent((Content)file.getElement());
                }
            }
            if (this.subFolders != null) {
                for (FolderBO subFolder : this.subFolders) {
                    this.folderElement.addContent((Content)subFolder.getElement());
                }
            }
        }
        return this.folderElement;
    }

    @Override
    public int compareTo(FolderBO f) throws NullPointerException {
        return this.folderName.compareTo(f.getFolderName());
    }

    public String toString() {
        return this.folderName;
    }
}

