/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jahia.configuration.logging.AbstractLogger;
import org.jahia.configuration.modules.ModuleDeployer;
import org.jahia.utils.maven.plugin.AbstractManagementMojo;
import org.jahia.utils.maven.plugin.MojoLogger;

public class CopyTemplatesMojo
extends AbstractManagementMojo {
    protected boolean deployTests;
    protected boolean deployToServer;

    public void doExecute() throws MojoExecutionException, MojoFailureException {
        File target;
        Set dependencyFiles = this.project.getDependencyArtifacts();
        HashSet<Artifact> dependenciesToRemove = new HashSet<Artifact>();
        if (this.deployToServer) {
            try {
                target = new File(this.getWebappDeploymentDir(), "WEB-INF/var/shared_" + (this.getProjectStructureVersion() != 2 ? "templates" : "modules"));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Cannot deploy module", e);
            }
        } else {
            target = new File(this.output, "jahia/WEB-INF/var/shared_" + (this.getProjectStructureVersion() != 2 ? "templates" : "modules"));
        }
        ModuleDeployer deployer = new ModuleDeployer(target, (AbstractLogger)new MojoLogger(this.getLog()));
        for (Artifact dependencyFile : dependencyFiles) {
            File file = dependencyFile.getFile();
            if (!this.deployTests && (dependencyFile.getGroupId().equals("org.jahia.modules") || dependencyFile.getGroupId().equals("org.jahia.templates") || dependencyFile.getGroupId().endsWith(".jahia.modules")) || this.deployTests && dependencyFile.getGroupId().equals("org.jahia.test")) {
                try {
                    deployer.deployModule(file);
                    dependenciesToRemove.add(dependencyFile);
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)("Error when copying file " + file), (Throwable)e);
                }
            }
            if (!dependencyFile.getGroupId().equals("org.jahia.prepackagedsites")) continue;
            try {
                FileUtils.copyFile((File)file, (File)new File(this.output, "jahia/WEB-INF/var/prepackagedSites/" + dependencyFile.getArtifactId() + ".zip"));
                this.getLog().info((CharSequence)("Copy prepackaged site " + file.getName()));
                dependenciesToRemove.add(dependencyFile);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Error when copying file " + file), (Throwable)e);
            }
        }
        ArrayList dependencyList = new ArrayList(dependencyFiles);
        for (Artifact dependencyFile : dependenciesToRemove) {
            dependencyList.remove(dependencyFile);
        }
        this.project.setDependencyArtifacts(new LinkedHashSet(dependencyList));
    }
}

