/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.jahia.utils.maven.plugin.contentgenerator.bo.PageBO;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputService {
    private Log logger = new SystemStreamLog();
    private String sep = System.getProperty("file.separator");

    public void initOutputFile(File f) throws IOException {
        FileUtils.writeStringToFile((File)f, (String)"", (String)"UTF-8");
    }

    public void appendStringToFile(File f, String s) throws IOException {
        OutputStreamWriter fwriter = new OutputStreamWriter((OutputStream)new FileOutputStream(f, true), "UTF-8");
        BufferedWriter fOut = new BufferedWriter(fwriter);
        fOut.write(s);
        fOut.close();
    }

    public void appendPagesToFile(File f, List<PageBO> listePages) throws IOException {
        for (PageBO page : listePages) {
            this.appendPageToFile(f, page);
        }
    }

    public void appendPageToFile(File f, PageBO page) throws IOException {
        this.appendStringToFile(f, page.toString());
    }

    public void appendPathToFile(File f, List<String> paths) throws IOException {
        for (String path : paths) {
            path = path + "\n";
            this.appendStringToFile(f, path);
        }
    }

    public File createSiteArchive(String archiveName, String outputPath, List<File> filesToArchive) {
        File newZipArchive = null;
        try {
            ZipOutputStream zipOutput = new ZipOutputStream(new FileOutputStream(outputPath + this.sep + archiveName));
            for (File f : filesToArchive) {
                this.zipFile(f, zipOutput);
            }
            zipOutput.close();
            newZipArchive = new File(outputPath + this.sep + archiveName);
        }
        catch (IOException e) {
            this.logger.error((CharSequence)"Can not create ZIP file: ", (Throwable)e);
        }
        return newZipArchive;
    }

    private void zipFile(File f, ZipOutputStream out) throws IOException {
        this.zipFile(f, f.getName(), out);
    }

    private void zipFile(File f, String fileName, ZipOutputStream out) throws IOException {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (File subFile : files) {
                    String childName = fileName + this.sep + subFile.getName();
                    this.zipFile(subFile, childName, out);
                }
            }
        } else {
            int len;
            FileInputStream in = new FileInputStream(f);
            byte[] buf = new byte[1024];
            out.putNextEntry(new ZipEntry(fileName));
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            in.close();
        }
    }

    public void writeJdomDocumentToFile(Document doc, File file) throws IOException {
        XMLOutputter out = new XMLOutputter();
        OutputStreamWriter fwriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        BufferedWriter fOut = new BufferedWriter(fwriter);
        Format prettyFormat = Format.getPrettyFormat();
        prettyFormat.setOmitDeclaration(true);
        out.setFormat(prettyFormat);
        out.output(doc, (Writer)fOut);
        fOut.flush();
        fOut.close();
    }

    public void writeInputStreamToFile(InputStream is, File f) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        int read = 0;
        byte[] bytes = new byte[1024];
        while ((read = is.read(bytes)) != -1) {
            ((OutputStream)out).write(bytes, 0, read);
        }
        is.close();
        out.flush();
        ((OutputStream)out).close();
    }
}

