/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.qdox.junit;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import org.hamcrest.generator.qdox.JavaDocBuilder;
import org.hamcrest.generator.qdox.model.AbstractBaseJavaEntity;
import org.hamcrest.generator.qdox.model.AbstractJavaEntity;
import org.hamcrest.generator.qdox.model.JavaClass;
import org.hamcrest.generator.qdox.model.JavaField;
import org.hamcrest.generator.qdox.model.JavaMethod;
import org.hamcrest.generator.qdox.model.JavaSource;
import org.hamcrest.generator.qdox.model.Type;

public abstract class APITestCase
extends TestCase {
    private static Comparator ENTITY_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            AbstractBaseJavaEntity entity1 = (AbstractBaseJavaEntity)o1;
            AbstractBaseJavaEntity entity2 = (AbstractBaseJavaEntity)o2;
            return entity1.getName().compareTo(entity2.getName());
        }
    };

    public static void assertApiEquals(URL expected, URL actual) throws IOException {
        JavaDocBuilder builder = new JavaDocBuilder();
        builder.addSource(new InputStreamReader(expected.openStream()), expected.toExternalForm());
        builder.addSource(new InputStreamReader(actual.openStream()), actual.toExternalForm());
        JavaSource expectedSource = builder.getSources()[0];
        JavaSource actualsource = builder.getSources()[1];
        APITestCase.assertApiEquals(expectedSource, actualsource);
    }

    private static void assertApiEquals(JavaSource expected, JavaSource actual) {
        List<JavaClass> expectedClasses = Arrays.asList(expected.getClasses());
        Collections.sort(expectedClasses, ENTITY_COMPARATOR);
        List<JavaClass> actualClasses = Arrays.asList(actual.getClasses());
        Collections.sort(actualClasses, ENTITY_COMPARATOR);
        APITestCase.assertEquals("Number of classes should be equal", expectedClasses.size(), actualClasses.size());
        for (int i = 0; i < expectedClasses.size(); ++i) {
            APITestCase.assertClassesEqual(expectedClasses.get(i), actualClasses.get(i));
        }
    }

    private static void assertClassesEqual(JavaClass expected, JavaClass actual) {
        APITestCase.assertEquals("Package names should be equal", expected.getPackage(), actual.getPackage());
        APITestCase.assertModifiersEquals("Class modifiers should be equal", expected, actual);
        APITestCase.assertEquals("Class names should be equal", expected.getName(), actual.getName());
        if (expected.getSuperJavaClass() != null && actual.getSuperJavaClass() != null) {
            APITestCase.assertEquals("Super class should be equal", expected.getSuperJavaClass().getName(), actual.getSuperJavaClass().getName());
        }
        if (expected.getSuperJavaClass() == null ^ actual.getSuperJavaClass() == null) {
            APITestCase.fail("Super class should be equal");
        }
        APITestCase.assertInterfacesEqual(expected, actual);
        APITestCase.assertInnerClassesEquals(expected, actual);
        APITestCase.assertFieldsEqual(expected, actual);
        APITestCase.assertMethodsEqual(expected, actual);
    }

    private static void assertFieldEquals(JavaField expected, JavaField actual) {
        StringBuffer message = new StringBuffer("-> assertFieldEquals");
        message.append("\n\tExcepted : ");
        message.append(expected);
        message.append("\n\tActual : ");
        message.append(actual);
        message.append("\n");
        APITestCase.assertEquals(message.toString() + "Field types should be equal", expected.getType(), actual.getType());
        APITestCase.assertEquals(message.toString() + "Field names should be equal", expected.getName(), actual.getName());
        APITestCase.assertModifiersEquals(message.toString() + "Field modifiers should be equal", expected, actual);
    }

    private static void assertFieldsEqual(JavaClass expected, JavaClass actual) {
        List<JavaField> expectedFields = Arrays.asList(expected.getFields());
        Collections.sort(expectedFields, ENTITY_COMPARATOR);
        List<JavaField> actualFields = Arrays.asList(actual.getFields());
        Collections.sort(actualFields, ENTITY_COMPARATOR);
        StringBuffer message = new StringBuffer("-> assertFieldsEqual");
        message.append("\n\tExcepted : ");
        message.append(expectedFields);
        message.append("\n\tActual : ");
        message.append(actualFields);
        message.append("\n");
        APITestCase.assertEquals(message.toString() + "Number of fields should be equal", expectedFields.size(), actualFields.size());
        for (int i = 0; i < expectedFields.size(); ++i) {
            APITestCase.assertFieldEquals(expectedFields.get(i), actualFields.get(i));
        }
    }

    private static void assertInnerClassesEquals(JavaClass expected, JavaClass actual) {
        List<JavaClass> expectedInnerClasses = Arrays.asList(expected.getNestedClasses());
        Collections.sort(expectedInnerClasses, ENTITY_COMPARATOR);
        List<JavaClass> actualInnerClasses = Arrays.asList(actual.getNestedClasses());
        Collections.sort(actualInnerClasses, ENTITY_COMPARATOR);
        StringBuffer message = new StringBuffer("-> assertInnerClassesEquals");
        message.append("\n\tExcepted : ");
        message.append(expectedInnerClasses);
        message.append("\n\tActual : ");
        message.append(actualInnerClasses);
        message.append("\n");
        APITestCase.assertEquals(message.toString() + "Number of inner classes should be equal", expectedInnerClasses.size(), actualInnerClasses.size());
        for (int i = 0; i < expectedInnerClasses.size(); ++i) {
            APITestCase.assertClassesEqual(expectedInnerClasses.get(i), actualInnerClasses.get(i));
        }
    }

    private static void assertInterfacesEqual(JavaClass expected, JavaClass actual) {
        List<Type> expectedImplements = Arrays.asList(expected.getImplements());
        Collections.sort(expectedImplements);
        List<Type> actualImplements = Arrays.asList(actual.getImplements());
        Collections.sort(actualImplements);
        StringBuffer message = new StringBuffer("-> assertInnerClassesEquals");
        message.append("\n\tExcepted : ");
        message.append(expectedImplements);
        message.append("\n\tActual : ");
        message.append(actualImplements);
        message.append("\n");
        APITestCase.assertEquals(message.toString() + "Number of implemented interface should be equal", expectedImplements.size(), actualImplements.size());
        for (int i = 0; i < expectedImplements.size(); ++i) {
            APITestCase.assertEquals("Implemented interface should be equal", expectedImplements.get(i), actualImplements.get(i));
        }
    }

    private static void assertMethodsEqual(JavaClass expected, JavaClass actual) {
        List<JavaMethod> expectedMethods = Arrays.asList(expected.getMethods());
        Collections.sort(expectedMethods, ENTITY_COMPARATOR);
        List<JavaMethod> actualMethods = Arrays.asList(actual.getMethods());
        Collections.sort(actualMethods, ENTITY_COMPARATOR);
        StringBuffer message = new StringBuffer("-> assertMethodsEqual");
        message.append("\n\tExcepted : ");
        message.append(expectedMethods);
        message.append("\n\tActual : ");
        message.append(actualMethods);
        message.append("\n");
        APITestCase.assertEquals(message.toString() + "Number of methods should be equal", expectedMethods.size(), actualMethods.size());
        for (int i = 0; i < expectedMethods.size(); ++i) {
            APITestCase.assertEquals("Method should be equal", expectedMethods.get(i), actualMethods.get(i));
        }
    }

    private static void assertModifiersEquals(String msg, AbstractJavaEntity expected, AbstractJavaEntity actual) {
        List<String> expectedModifiers = Arrays.asList(expected.getModifiers());
        Collections.sort(expectedModifiers);
        List<String> actualModifiers = Arrays.asList(actual.getModifiers());
        Collections.sort(actualModifiers);
        StringBuffer message = new StringBuffer("-> assertModifiersEquals");
        message.append("\n\tExcepted : ");
        message.append(expectedModifiers);
        message.append("\n\tActual : ");
        message.append(actualModifiers);
        message.append("\n");
        APITestCase.assertEquals(message.toString() + msg + "\nNumber of modifiers should be equal", expectedModifiers.size(), actualModifiers.size());
        for (int i = 0; i < expectedModifiers.size(); ++i) {
            APITestCase.assertEquals(msg + "\n" + message.toString() + "\nModifier should be equal", (Object)expectedModifiers.get(i), (Object)actualModifiers.get(i));
        }
    }

    private static void assertNotDir(File expected, File actual) {
        if (expected.isDirectory()) {
            APITestCase.fail(expected.getAbsolutePath() + " - should not have been a directory");
        }
        if (actual.isDirectory()) {
            APITestCase.fail(actual.getAbsolutePath() + " - should not have been a directory");
        }
    }

    protected File getDir() {
        return new File(this.getClass().getResource("/" + this.getClass().getName().replace('.', '/') + ".class").getFile()).getParentFile();
    }

    protected File getRootDir() {
        File dir2 = this.getDir();
        StringTokenizer st = new StringTokenizer(this.getClass().getName(), ".");
        for (int i = 0; i < st.countTokens() - 1; ++i) {
            dir2 = dir2.getParentFile();
        }
        return dir2;
    }
}

