/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jahia.bin.Jahia;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.test.bin.BaseTestController;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaTestCase {
    public static final String ROOT_PASSWORD = "root1234";
    private static final String PORT = "9090";
    private static final String BASE_URL = "http://localhost:9090";
    private static boolean baseUrlForTestsLogged;
    private static Logger logger;
    private HttpClient client;

    protected static final HttpServletRequest getRequest() {
        return BaseTestController.getThreadLocalRequest();
    }

    protected static final HttpServletResponse getResponse() {
        return BaseTestController.getThreadLocalResponse();
    }

    protected static final JahiaUser getUser() {
        return JCRSessionFactory.getInstance().getCurrentUser();
    }

    protected static final JCRUserNode getUserNode(JahiaUser admin) {
        return ServicesRegistry.getInstance().getJahiaUserManagerService().lookupUserByPath(admin.getLocalPath());
    }

    protected static void publishAll(String nodeIdentifier) throws RepositoryException {
        JCRPublicationService.getInstance().publishByMainId(nodeIdentifier);
    }

    protected static void setSessionSite(JahiaSite site) {
    }

    protected static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected String getAsText(String relativeUrl) throws IOException {
        return this.getAsText(relativeUrl, 200);
    }

    protected String getAsText(String relativeUrl, int expectedResponseCode) throws IOException {
        return this.getAsText(relativeUrl, null, expectedResponseCode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getAsText(String relativeUrl, Map<String, String> requestHeaders, int expectedResponseCode, Map<String, List<String>> collectedResponseHeaders) {
        String body = "";
        GetMethod getMethod = this.createGetMethod(relativeUrl);
        if (requestHeaders != null && !requestHeaders.isEmpty()) {
            for (Map.Entry<String, String> header : requestHeaders.entrySet()) {
                getMethod.addRequestHeader(header.getKey(), header.getValue());
            }
        }
        try {
            int responseCode = this.getHttpClient().executeMethod((HttpMethod)getMethod);
            Assert.assertEquals("Response code for URL " + relativeUrl + " is incorrect", expectedResponseCode, responseCode);
            body = getMethod.getResponseBodyAsString();
            if (collectedResponseHeaders != null) {
                for (Header header : getMethod.getResponseHeaders()) {
                    String headerName = header.getName();
                    if (!collectedResponseHeaders.containsKey(headerName)) {
                        collectedResponseHeaders.put(headerName, new LinkedList());
                    }
                    collectedResponseHeaders.get(headerName).add(header.getValue());
                }
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            getMethod.releaseConnection();
        }
        return body;
    }

    protected GetMethod createGetMethod(String relativeUrl) {
        return new GetMethod(this.getBaseServerURL() + Jahia.getContextPath() + relativeUrl);
    }

    protected String getBaseServerURL() {
        String url;
        HttpServletRequest req = JahiaTestCase.getRequest();
        String string = url = req != null ? req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() : BASE_URL;
        if (!baseUrlForTestsLogged) {
            logger.info("Base URL for tests is: " + url);
            baseUrlForTestsLogged = true;
        }
        return url;
    }

    protected String getBaseServerURLPort() {
        HttpServletRequest req = JahiaTestCase.getRequest();
        return req != null ? String.valueOf(JahiaTestCase.getRequest().getServerPort()) : PORT;
    }

    protected HttpClient getHttpClient() {
        if (this.client == null) {
            this.client = new HttpClient();
        }
        return this.client;
    }

    protected void login(String username, String password) throws IOException {
        int statusCode = this.post((String)new StringBuilder().append((String)this.getBaseServerURL()).append((String)Jahia.getContextPath()).append((String)"/cms/login").toString(), (String[][])new String[][]{{"username", username}, {"password", password}, {"restMode", "true"}}).statusCode;
        Assert.assertEquals("Login failed for user", 200L, statusCode);
    }

    protected void loginRoot() throws IOException {
        this.login("root", ROOT_PASSWORD);
    }

    protected void logout() throws IOException {
        PostResult post = this.post(this.getBaseServerURL() + Jahia.getContextPath() + "/cms/logout", new String[][]{{"redirectActive", "false"}});
        if (post.statusCode != 200) {
            System.err.println("Method failed: " + post.statusLine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PostResult post(String url, String[] ... params) throws IOException {
        PostMethod method = new PostMethod(url);
        for (String[] param : params) {
            method.addParameter(param[0], param[1]);
        }
        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        int statusCode = 0;
        String statusLine = null;
        String responseBody = null;
        try {
            statusCode = this.getHttpClient().executeMethod((HttpMethod)method);
            statusLine = method.getStatusLine().toString();
            if (statusCode != 200) {
                logger.warn("Method failed: {}", (Object)statusLine);
            }
            responseBody = method.getResponseBodyAsString();
        }
        finally {
            method.releaseConnection();
        }
        return new PostResult(statusCode, statusLine, responseBody);
    }

    static {
        logger = LoggerFactory.getLogger(JahiaTestCase.class);
    }

    protected class PostResult {
        public int statusCode;
        public String statusLine;
        public String responseBody;

        PostResult(int statusCode, String statusLine, String responseBody) {
            this.statusCode = statusCode;
            this.statusLine = statusLine;
            this.responseBody = responseBody;
        }
    }
}

