/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.springframework.util.CollectionUtils;

public class PerformanceTestUtils {
    private PerformanceTestUtils() {
    }

    public static <E> Collection<E> getUniqueRandomElements(Collection<E> candidateElements, int numRandomElements) {
        return PerformanceTestUtils.getUniqueRandomElements(candidateElements, numRandomElements, null);
    }

    public static <E> Collection<E> getUniqueRandomElements(Collection<E> candidateElements, int numRandomElements, ElementRejector<E> rejector) {
        if (!(candidateElements instanceof Set)) {
            candidateElements = new LinkedHashSet<E>(candidateElements);
        }
        ArrayList result = new ArrayList(numRandomElements);
        candidateElements = new ArrayList<E>(candidateElements);
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while (result.size() < numRandomElements) {
            Object element = ((List)candidateElements).get(((Random)random).nextInt(candidateElements.size()));
            if (result.contains(element) || rejector != null && rejector.isToBeRejected(element)) continue;
            result.add(element);
        }
        return result;
    }

    public static TimingStatistics getTimingStatistics(Collection<Long> samples) {
        return new TimingStatisticsImpl(samples);
    }

    private static class TimingStatisticsImpl
    implements TimingStatistics {
        private ArrayList<Long> sortedSamples;
        private Long min;
        private Long max;
        private long avg;

        public TimingStatisticsImpl(Collection<Long> samples) {
            if (CollectionUtils.isEmpty(samples)) {
                throw new IllegalArgumentException();
            }
            this.sortedSamples = new ArrayList<Long>(samples);
            Collections.sort(this.sortedSamples);
            long total = 0L;
            for (long sample : this.sortedSamples) {
                if (sample < 0L) {
                    throw new IllegalArgumentException();
                }
                if (this.min == null || sample < this.min) {
                    this.min = sample;
                }
                if (this.max == null || sample > this.max) {
                    this.max = sample;
                }
                total += sample;
            }
            this.avg = Math.round((double)total / (double)this.getNumSamples());
        }

        @Override
        public int getNumSamples() {
            return this.sortedSamples.size();
        }

        @Override
        public long getMin() {
            return this.min;
        }

        @Override
        public long getMax() {
            return this.max;
        }

        @Override
        public long getAvg() {
            return this.avg;
        }

        @Override
        public long getPercentile(int percentile) {
            if (percentile <= 0 || percentile >= 100) {
                throw new IllegalArgumentException();
            }
            int index = (int)Math.ceil((float)this.getNumSamples() * ((float)percentile / 100.0f)) - 1;
            return this.sortedSamples.get(index);
        }
    }

    public static interface TimingStatistics {
        public int getNumSamples();

        public long getMin();

        public long getMax();

        public long getAvg();

        public long getPercentile(int var1);
    }

    public static interface ElementRejector<E> {
        public boolean isToBeRejected(E var1);
    }
}

