/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.util.DOMElementWriter;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SurefireJUnitXMLResultFormatter
extends RunListener {
    private static final double ONE_SECOND = 1000.0;
    private static final String UNKNOWN = "unknown";
    private static final String SYSTEM_ERR = "system-err";
    private static final String SYSTEM_OUT = "system-out";
    private static final String TESTSUITE = "testsuite";
    private static final String TESTCASE = "testcase";
    private static final String FAILURE = "failure";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TIME = "time";
    private static final String ATTR_ERRORS = "errors";
    private static final String ATTR_FAILURES = "failures";
    private static final String ATTR_TESTS = "tests";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_MESSAGE = "message";
    private static final String ATTR_CLASSNAME = "classname";
    private static final String TIMESTAMP = "timestamp";
    private static final String HOSTNAME = "hostname";
    private Document doc;
    private Element rootElement;
    private Map<Description, Element> testElements = new HashMap<Description, Element>();
    private Set<Description> failedTests = new HashSet<Description>();
    private Map<Description, Long> testStarts = new HashMap<Description, Long>();
    private OutputStream out;

    private static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exc) {
            throw new ExceptionInInitializerError(exc);
        }
    }

    public SurefireJUnitXMLResultFormatter() {
    }

    public SurefireJUnitXMLResultFormatter(OutputStream out) {
        this.setOutput(out);
    }

    public void setOutput(OutputStream out) {
        this.out = out;
    }

    public void setSystemOutput(String out) {
        this.formatOutput(SYSTEM_OUT, out);
    }

    public void setSystemError(String out) {
        this.formatOutput(SYSTEM_ERR, out);
    }

    @Override
    public void testRunStarted(Description description) throws Exception {
        this.doc = SurefireJUnitXMLResultFormatter.getDocumentBuilder().newDocument();
        this.rootElement = this.doc.createElement(TESTSUITE);
        String n = description.getDisplayName();
        this.rootElement.setAttribute(ATTR_NAME, n == null ? UNKNOWN : n);
        String timestamp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date());
        this.rootElement.setAttribute(TIMESTAMP, timestamp);
        this.rootElement.setAttribute(HOSTNAME, this.getHostname());
    }

    private String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    @Override
    public void testRunFinished(Result result) throws Exception {
        this.rootElement.setAttribute(ATTR_TESTS, "" + result.getRunCount());
        this.rootElement.setAttribute(ATTR_FAILURES, "" + result.getFailureCount());
        this.rootElement.setAttribute(ATTR_ERRORS, "" + result.getFailures().size());
        this.rootElement.setAttribute(ATTR_TIME, "" + (double)result.getRunTime() / 1000.0);
        if (this.out != null) {
            Writer wri = null;
            try {
                wri = new BufferedWriter(new OutputStreamWriter(this.out, "UTF8"));
                wri.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
                new DOMElementWriter().write(this.rootElement, wri, 0, "  ");
            }
            catch (IOException exc) {
                throw new Exception("Unable to write log file", exc);
            }
            finally {
                if (wri != null) {
                    try {
                        wri.flush();
                    }
                    catch (IOException iOException) {}
                }
                if (this.out != System.out && this.out != System.err) {
                    IOUtils.closeQuietly((Writer)wri);
                }
            }
        }
    }

    @Override
    public void testStarted(Description test) throws Exception {
        this.testStarts.put(test, new Long(System.currentTimeMillis()));
    }

    @Override
    public void testFinished(Description test) throws Exception {
        if (!this.testStarts.containsKey(test)) {
            this.testStarted(test);
        }
        Element currentTest = null;
        if (!this.failedTests.contains(test)) {
            currentTest = this.doc.createElement(TESTCASE);
            String n = test.getDisplayName();
            currentTest.setAttribute(ATTR_NAME, n == null ? UNKNOWN : n);
            currentTest.setAttribute(ATTR_CLASSNAME, test.getClassName());
            this.rootElement.appendChild(currentTest);
            this.testElements.put(test, currentTest);
        } else {
            currentTest = this.testElements.get(test);
        }
        Long l = this.testStarts.get(test);
        currentTest.setAttribute(ATTR_TIME, "" + (double)(System.currentTimeMillis() - l) / 1000.0);
    }

    @Override
    public void testFailure(Failure failure) throws Exception {
        if (failure.getDescription() != null) {
            this.testFinished(failure.getDescription());
            this.failedTests.add(failure.getDescription());
        }
        Element nested = this.doc.createElement(FAILURE);
        Element currentTest = null;
        currentTest = failure.getDescription() != null ? this.testElements.get(failure.getDescription()) : this.rootElement;
        currentTest.appendChild(nested);
        String message = failure.getMessage();
        if (message != null && message.length() > 0) {
            nested.setAttribute(ATTR_MESSAGE, failure.getMessage());
        }
        nested.setAttribute(ATTR_TYPE, failure.getClass().getName());
        String strace = failure.getTrace();
        Text trace = this.doc.createTextNode(strace);
        nested.appendChild(trace);
    }

    private void formatOutput(String type, String output) {
        Element nested = this.doc.createElement(type);
        this.rootElement.appendChild(nested);
        nested.appendChild(this.doc.createCDATASection(output));
    }
}

