/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.util.DOMElementWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SurefireTestNGXMLResultFormatter
implements ISuiteListener,
ITestListener {
    private static transient Logger logger = LoggerFactory.getLogger(SurefireTestNGXMLResultFormatter.class);
    private static final double ONE_SECOND = 1000.0;
    private static final String UNKNOWN = "unknown";
    private static final String SYSTEM_ERR = "system-err";
    private static final String SYSTEM_OUT = "system-out";
    private static final String TESTSUITE = "testsuite";
    private static final String TESTCASE = "testcase";
    private static final String FAILURE = "failure";
    private static final String SKIPPED = "skipped";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TIME = "time";
    private static final String ATTR_ERRORS = "errors";
    private static final String ATTR_FAILURES = "failures";
    private static final String ATTR_SKIPPED = "failures";
    private static final String ATTR_TESTS = "tests";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_MESSAGE = "message";
    private static final String ATTR_CLASSNAME = "classname";
    private static final String TIMESTAMP = "timestamp";
    private static final String HOSTNAME = "hostname";
    private Document doc;
    private Element rootElement;
    private Map<String, Element> testElements = new HashMap<String, Element>();
    private Set<String> failedTests = new HashSet<String>();
    private Map<String, Long> testStarts = new HashMap<String, Long>();
    private OutputStream out;

    private static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exc) {
            throw new ExceptionInInitializerError(exc);
        }
    }

    public SurefireTestNGXMLResultFormatter() {
    }

    public SurefireTestNGXMLResultFormatter(OutputStream out) {
        this.setOutput(out);
    }

    public void setOutput(OutputStream out) {
        this.out = out;
    }

    public void setSystemOutput(String out) {
        this.formatOutput(SYSTEM_OUT, out);
    }

    public void setSystemError(String out) {
        this.formatOutput(SYSTEM_ERR, out);
    }

    @Override
    public void onStart(ISuite suite) {
        this.doc = SurefireTestNGXMLResultFormatter.getDocumentBuilder().newDocument();
        this.rootElement = this.doc.createElement(TESTSUITE);
        String n = suite.getName();
        this.rootElement.setAttribute(ATTR_NAME, n == null ? UNKNOWN : n);
        String timestamp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date());
        this.rootElement.setAttribute(TIMESTAMP, timestamp);
        this.rootElement.setAttribute(HOSTNAME, this.getHostname());
    }

    private String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFinish(ISuite suite) {
        int tests = 0;
        int failures = 0;
        int skipped = 0;
        Date startDate = null;
        Date endDate = null;
        for (ISuiteResult suiteResult : suite.getResults().values()) {
            ITestContext context = suiteResult.getTestContext();
            tests += context.getAllTestMethods().length;
            failures += context.getFailedButWithinSuccessPercentageTests().size() + context.getFailedTests().size();
            skipped += context.getSkippedTests().size();
            if (startDate == null || startDate.after(context.getStartDate())) {
                startDate = context.getStartDate();
            }
            if (endDate != null && !endDate.before(context.getEndDate())) continue;
            endDate = context.getEndDate();
        }
        this.rootElement.setAttribute(ATTR_TESTS, "" + tests);
        this.rootElement.setAttribute("failures", "" + failures);
        this.rootElement.setAttribute(ATTR_ERRORS, "" + failures);
        this.rootElement.setAttribute("failures", "" + skipped);
        this.rootElement.setAttribute(ATTR_TIME, endDate != null ? "" + (double)(endDate.getTime() - startDate.getTime()) / 1000.0 : "0");
        if (this.out != null) {
            Writer wri = null;
            try {
                wri = new BufferedWriter(new OutputStreamWriter(this.out, "UTF8"));
                wri.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
                new DOMElementWriter().write(this.rootElement, wri, 0, "  ");
            }
            catch (IOException exc) {
                logger.error("Unable to write log file", (Throwable)exc);
            }
            finally {
                if (wri != null) {
                    try {
                        wri.flush();
                    }
                    catch (IOException iOException) {}
                }
                if (this.out != System.out && this.out != System.err) {
                    IOUtils.closeQuietly((Writer)wri);
                }
            }
        }
    }

    @Override
    public void onTestStart(ITestResult result) {
        this.testStarts.put(result.getName(), new Long(System.currentTimeMillis()));
    }

    private void testFinished(ITestResult result) {
        Element currentTest = null;
        if (!this.failedTests.contains(result.getName())) {
            currentTest = this.doc.createElement(TESTCASE);
            String n = SurefireTestNGXMLResultFormatter.getUserFriendlyTestName(result);
            currentTest.setAttribute(ATTR_NAME, n == null ? UNKNOWN : n);
            currentTest.setAttribute(ATTR_CLASSNAME, result.getTestClass().getName());
            this.rootElement.appendChild(currentTest);
            this.testElements.put(SurefireTestNGXMLResultFormatter.getUserFriendlyTestName(result), currentTest);
        } else {
            currentTest = this.testElements.get(SurefireTestNGXMLResultFormatter.getUserFriendlyTestName(result));
        }
        Long l = this.testStarts.get(result.getName());
        if (l != null) {
            currentTest.setAttribute(ATTR_TIME, "" + (double)(System.currentTimeMillis() - l) / 1000.0);
        } else {
            currentTest.setAttribute(ATTR_TIME, "0");
        }
    }

    @Override
    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.onTestFailure(result);
    }

    @Override
    public void onTestFailure(ITestResult result) {
        if (result.getName() != null) {
            this.testFinished(result);
            this.failedTests.add(result.getName());
        }
        Element nested = this.doc.createElement(FAILURE);
        Element currentTest = null;
        currentTest = SurefireTestNGXMLResultFormatter.getUserFriendlyTestName(result) != null ? this.testElements.get(SurefireTestNGXMLResultFormatter.getUserFriendlyTestName(result)) : this.rootElement;
        currentTest.appendChild(nested);
        String message = result.getThrowable().getMessage();
        if (message != null && message.length() > 0) {
            nested.setAttribute(ATTR_MESSAGE, result.getThrowable().getMessage());
        }
        nested.setAttribute(ATTR_TYPE, result.getClass().getName());
        StringWriter out = new StringWriter();
        result.getThrowable().printStackTrace(new PrintWriter(out));
        String strace = out.toString();
        Text trace = this.doc.createTextNode(strace);
        nested.appendChild(trace);
    }

    @Override
    public void onTestSkipped(ITestResult result) {
        if (result.getName() != null) {
            this.testFinished(result);
            this.failedTests.add(result.getName());
        }
        Element nested = this.doc.createElement(SKIPPED);
        Element currentTest = null;
        currentTest = SurefireTestNGXMLResultFormatter.getUserFriendlyTestName(result) != null ? this.testElements.get(SurefireTestNGXMLResultFormatter.getUserFriendlyTestName(result)) : this.rootElement;
        currentTest.appendChild(nested);
        String message = SKIPPED;
        if (message != null && message.length() > 0) {
            nested.setAttribute(ATTR_MESSAGE, message);
        }
    }

    @Override
    public void onTestSuccess(ITestResult result) {
        this.testFinished(result);
    }

    @Override
    public void onStart(ITestContext context) {
    }

    @Override
    public void onFinish(ITestContext context) {
    }

    private void formatOutput(String type, String output) {
        Element nested = this.doc.createElement(type);
        this.rootElement.appendChild(nested);
        nested.appendChild(this.doc.createCDATASection(output));
    }

    private static String getUserFriendlyTestName(ITestResult result) {
        return result.getName() + "(" + result.getTestClass().getName() + ")";
    }
}

