/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.jahia.exceptions.JahiaException;
import org.jahia.osgi.BundleResource;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.importexport.ImportExportBaseService;
import org.jahia.services.importexport.NoCloseZipInputStream;
import org.jahia.services.scheduler.SchedulerService;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.sites.SiteCreationInfo;
import org.jahia.settings.SettingsBean;
import org.jahia.test.JahiaAdminUser;
import org.jahia.test.ModuleTestHelper;
import org.jahia.utils.zip.DirectoryZipInputStream;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;

public class TestHelper {
    static Logger logger = LoggerFactory.getLogger(TestHelper.class);
    public static final String TCK_TEMPLATES = "Jahia Test";
    public static final String WEB_TEMPLATES = "templates-web";
    public static final String WEB_BLUE_TEMPLATES = "templates-web-blue";
    public static final String WEB_SPACE_TEMPLATES = "templates-web-space";
    public static final String INTRANET_TEMPLATES = "templates-intranet";
    public static final String BOOTSTRAP_ACME_SPACE_TEMPLATES = "bootstrap-acme-space-templates";
    public static final String DX_BASE_DEMO_TEMPLATES = "dx-base-demo-templates";

    public static JahiaSite createSite(SiteCreationInfo info) throws Exception {
        return TestHelper.createSite(info, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JahiaSite createSite(SiteCreationInfo info, String prepackedZIPFile, String siteZIPName) throws Exception {
        TestHelper.populateDefaults(info);
        TestHelper.deleteSiteIfPresent(info.getSiteKey());
        JahiaSite site = null;
        File siteZIPFile = null;
        try {
            String prepackedZipFileOrBundle;
            if (!StringUtils.isEmpty((String)prepackedZIPFile) && (siteZIPFile = TestHelper.importSharedAndGetSiteZipFileOfPrepackagedSite(prepackedZipFileOrBundle = ModuleTestHelper.ensurePrepackagedSiteExist(prepackedZIPFile), siteZIPName)) != null) {
                info.setFirstImport("fileImport");
                info.setFileImport((Resource)new FileSystemResource(siteZIPFile));
                List<String> modulesToInstall = TestHelper.readInstalledModules(siteZIPFile);
                Collections.reverse(modulesToInstall);
                for (String module : modulesToInstall) {
                    ModuleTestHelper.ensureModuleStarted(module);
                }
            }
            ModuleTestHelper.ensureModuleStarted(info.getTemplateSet());
            JahiaSitesService service = ServicesRegistry.getInstance().getJahiaSitesService();
            site = service.addSite(info);
            site = service.getSiteByKey(info.getSiteKey());
        }
        catch (Throwable throwable) {
            FileUtils.deleteQuietly(siteZIPFile);
            throw throwable;
        }
        FileUtils.deleteQuietly((File)siteZIPFile);
        return site;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File importSharedAndGetSiteZipFileOfPrepackagedSite(String prepackedZipFileOrBundle, String siteZIPName) {
        File siteZIPFile = null;
        File sharedZIPFile = null;
        NoCloseZipInputStream zis = null;
        try {
            zis = new NoCloseZipInputStream(TestHelper.getPrepackedSiteInputStream(prepackedZipFileOrBundle));
            ZipEntry z = null;
            while ((z = zis.getNextEntry()) != null) {
                boolean isUsersZip = "users.zip".equals(z.getName());
                if (!isUsersZip && !siteZIPName.equalsIgnoreCase(z.getName())) continue;
                File zipFile = File.createTempFile("import", ".zip");
                FileUtils.copyInputStreamToFile((InputStream)zis, (File)zipFile);
                if (isUsersZip) {
                    sharedZIPFile = zipFile;
                    continue;
                }
                siteZIPFile = zipFile;
            }
            if (sharedZIPFile != null) {
                ImportExportBaseService.getInstance().importSiteZip((Resource)new FileSystemResource(sharedZIPFile), null, null);
            }
        }
        catch (RepositoryException e) {
            logger.warn("shared.zip could not be imported", (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (zis != null) {
                try {
                    zis.reallyClose();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            FileUtils.deleteQuietly(sharedZIPFile);
        }
        return siteZIPFile;
    }

    private static InputStream getPrepackedSiteInputStream(String prepackedZipFileOrBundle) throws IOException {
        if (StringUtils.startsWith((String)prepackedZipFileOrBundle, (String)"bundle")) {
            String[] bundleInfos = StringUtils.split((String)prepackedZipFileOrBundle, (String)"#");
            BundleResource resource = new BundleResource(new URL(bundleInfos[0]), ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(bundleInfos[1]).getBundle());
            return new BufferedInputStream(resource.getInputStream());
        }
        return new FileInputStream(new File(prepackedZipFileOrBundle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readInstalledModules(File siteZipFile) throws IOException {
        LinkedList<String> modules = new LinkedList<String>();
        DirectoryZipInputStream zis2 = siteZipFile.isDirectory() ? new DirectoryZipInputStream(siteZipFile) : new NoCloseZipInputStream((InputStream)new BufferedInputStream(new FileInputStream(siteZipFile)));
        try {
            ZipEntry z;
            while ((z = zis2.getNextEntry()) != null) {
                try {
                    if (!"site.properties".equals(z.getName())) continue;
                    Properties p = new Properties();
                    p.load((InputStream)zis2);
                    TreeMap<Integer, String> im = new TreeMap<Integer, String>();
                    for (Object k : p.keySet()) {
                        String version;
                        String key = String.valueOf(k);
                        if (!key.startsWith("installedModules.") || !NumberUtils.isNumber((String)(version = StringUtils.substringAfter((String)key, (String)".")))) continue;
                        im.put(Integer.valueOf(version), p.getProperty(key));
                    }
                    modules.addAll(im.values());
                }
                finally {
                    zis2.closeEntry();
                }
            }
        }
        finally {
            if (zis2 instanceof NoCloseZipInputStream) {
                ((NoCloseZipInputStream)zis2).reallyClose();
            }
        }
        return modules;
    }

    private static void deleteSiteIfPresent(String siteKey) throws JahiaException {
        JahiaSitesService service = ServicesRegistry.getInstance().getJahiaSitesService();
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            JCRSiteNode existingSite = service.getSiteByKey(siteKey, session);
            if (existingSite != null) {
                service.removeSite((JahiaSite)existingSite);
                session.refresh(false);
            }
        }
        catch (RepositoryException ex) {
            logger.debug("Error while trying to remove the site", (Throwable)ex);
        }
    }

    private static void populateDefaults(SiteCreationInfo info) {
        long timestamp = System.currentTimeMillis();
        info.setSiteKey(StringUtils.defaultString((String)info.getSiteKey(), (String)("mySite-" + timestamp)));
        info.setTitle(StringUtils.defaultString((String)info.getTitle(), (String)info.getSiteKey()));
        info.setDescription(StringUtils.defaultString((String)info.getDescription(), (String)info.getTitle()));
        info.setServerName(StringUtils.defaultString((String)info.getServerName(), (String)("localhost" + timestamp)));
        info.setTemplateSet(StringUtils.defaultString((String)info.getTemplateSet(), (String)WEB_TEMPLATES));
        info.setLocale(StringUtils.defaultString((String)info.getLocale(), (String)SettingsBean.getInstance().getDefaultLanguageCode()));
        if (info.getSiteAdmin() == null) {
            info.setSiteAdmin(JahiaAdminUser.getAdminUser(null));
        }
    }

    public static JahiaSite createSite(String name) throws Exception {
        return TestHelper.createSite(SiteCreationInfo.builder().siteKey(name).build());
    }

    public static JahiaSite createSite(String name, String templateSet) throws Exception {
        return TestHelper.createSite(SiteCreationInfo.builder().siteKey(name).templateSet(templateSet).build());
    }

    public static JahiaSite createSite(String name, Set<String> languages, Set<String> mandatoryLanguages, boolean mixLanguagesActive) throws Exception {
        TestHelper.createSite(name);
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        JCRSiteNode site = (JCRSiteNode)session.getNode("/sites/" + name);
        if (!CollectionUtils.isEmpty(languages) && !languages.equals(site.getLanguages())) {
            site.setLanguages(languages);
        }
        if (!CollectionUtils.isEmpty(mandatoryLanguages) && !mandatoryLanguages.equals(site.getMandatoryLanguages())) {
            site.setMandatoryLanguages(mandatoryLanguages);
        }
        if (mixLanguagesActive != site.isMixLanguagesActive()) {
            site.setMixLanguagesActive(mixLanguagesActive);
        }
        session.save();
        return site;
    }

    public static JahiaSite createSite(String name, String serverName, String templateSet, String[] modulesToDeploy) throws Exception {
        return TestHelper.createSite(name, serverName, templateSet, null, null, modulesToDeploy);
    }

    public static JahiaSite createSite(String name, String serverName, String templateSet) throws Exception {
        return TestHelper.createSite(name, serverName, templateSet, null, null, null);
    }

    public static JahiaSite createSite(String name, String serverName, String templateSet, String prepackedZIPFile, String siteZIPName, String[] modulesToDeploy) throws Exception {
        return TestHelper.createSite(SiteCreationInfo.builder().siteKey(name).serverName(serverName).templateSet(templateSet).modulesToDeploy(modulesToDeploy).build(), prepackedZIPFile, siteZIPName);
    }

    public static JahiaSite createSite(String name, String serverName, String templateSet, String prepackedZIPFile, String siteZIPName) throws Exception {
        return TestHelper.createSite(name, serverName, templateSet, prepackedZIPFile, siteZIPName, null);
    }

    public static void deleteSite(String name) throws Exception {
        JahiaSitesService service = ServicesRegistry.getInstance().getJahiaSitesService();
        JahiaSite site = service.getSiteByKey(name);
        if (site != null) {
            service.removeSite(site);
        }
    }

    public static int createSubPages(Node currentNode, int level, int nbChildren) throws RepositoryException, LockException, ConstraintViolationException, NoSuchNodeTypeException, ItemExistsException, VersionException {
        return TestHelper.createSubPages(currentNode, level, nbChildren, null);
    }

    public static int createSubPages(Node currentNode, int level, int nbChildren, String titlePrefix) throws RepositoryException, LockException, ConstraintViolationException, NoSuchNodeTypeException, ItemExistsException, VersionException {
        int pagesCreated = 0;
        if (!currentNode.isCheckedOut()) {
            currentNode.checkout();
        }
        for (int i = 0; i < nbChildren; ++i) {
            Node newSubPage = currentNode.addNode("child" + Integer.toString(i), "jnt:page");
            newSubPage.setProperty("j:templateName", "simple");
            if (titlePrefix != null) {
                newSubPage.setProperty("jcr:title", titlePrefix + Integer.toString(i));
            }
            ++pagesCreated;
        }
        return pagesCreated;
    }

    public static JCRNodeWrapper createList(JCRNodeWrapper parentNode, String listName, int elementCount, String textPrefix) throws RepositoryException, LockException, ConstraintViolationException, NoSuchNodeTypeException, ItemExistsException, VersionException {
        JCRNodeWrapper contentList = parentNode.addNode(listName, "jnt:contentList");
        for (int i = 0; i < elementCount; ++i) {
            JCRNodeWrapper textNode = contentList.addNode(listName + "_text" + Integer.toString(i), "jnt:mainContent");
            textNode.setProperty("jcr:title", textPrefix + Integer.toString(i));
            textNode.setProperty("body", textPrefix + Integer.toString(i));
        }
        return contentList;
    }

    public static StringBuilder dumpTree(StringBuilder stringBuilder, Node startNode, int depth, boolean logAsError) throws RepositoryException {
        for (int i = 0; i < depth; ++i) {
            if (i == 0) {
                stringBuilder.append("+-");
                continue;
            }
            stringBuilder.append("--");
        }
        stringBuilder.append(startNode.getName());
        stringBuilder.append(" = ");
        stringBuilder.append(startNode.getIdentifier());
        stringBuilder.append("\n");
        NodeIterator childNodeIter = startNode.getNodes();
        while (childNodeIter.hasNext()) {
            Node currentChild = childNodeIter.nextNode();
            stringBuilder = TestHelper.dumpTree(stringBuilder, currentChild, depth + 1, logAsError);
        }
        return stringBuilder;
    }

    public static void triggerScheduledJobsAndWait() {
        long stepMillis = 100L;
        long maxWaitMillis = 60000L;
        SchedulerService schedulerService = ServicesRegistry.getInstance().getSchedulerService();
        schedulerService.triggerEndOfRequest();
        TestHelper.sleep(stepMillis);
        try {
            long count = 0L;
            while (schedulerService.getRAMScheduler().getTriggerNames("instant").length > 0 || schedulerService.getScheduler().getTriggerNames("instant").length > 0) {
                if (count == 0L) {
                    logger.info("Start waiting for background job completion...");
                }
                if (stepMillis * ++count > maxWaitMillis) {
                    logger.warn("Reached timeout of {} ms waitig for job completion. Stop waiting for them.");
                    break;
                }
                TestHelper.sleep(stepMillis);
            }
            logger.info("...stopped waiting for background job completion.");
        }
        catch (SchedulerException e) {
            logger.error(e.getMessage(), (Throwable)e);
            TestHelper.sleep(5000L);
        }
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

