/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.bin;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.test.JahiaAdminUser;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public abstract class BaseTestController
implements Controller {
    protected static ThreadLocal<HttpServletRequest> perThreadRequest = new ThreadLocal();
    protected static ThreadLocal<HttpServletResponse> perThreadResponse = new ThreadLocal();

    public static final HttpServletRequest getThreadLocalRequest() {
        return perThreadRequest.get();
    }

    public static final HttpServletResponse getThreadLocalResponse() {
        return perThreadResponse.get();
    }

    protected abstract void handleGet(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request.getMethod().equalsIgnoreCase("get")) {
            JahiaUser oldUser = JCRSessionFactory.getInstance().getCurrentUser();
            JCRSessionFactory.getInstance().setCurrentUser(JahiaAdminUser.getAdminUser(null));
            Locale oldLocale = (Locale)request.getSession(true).getAttribute("org.jahia.services.multilang.currentlocale");
            request.getSession(true).setAttribute("org.jahia.services.multilang.currentlocale", (Object)Locale.ENGLISH);
            perThreadRequest.set(request);
            perThreadResponse.set(response);
            try {
                this.handleGet(request, response);
            }
            finally {
                perThreadRequest.set(null);
                perThreadResponse.set(null);
                request.getSession(true).setAttribute("org.jahia.services.multilang.currentlocale", (Object)oldLocale);
                JCRSessionFactory.getInstance().setCurrentUser(oldUser);
            }
        } else {
            response.sendError(405);
        }
        return null;
    }
}

