/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.bin;

import java.io.IOException;
import javax.jcr.RepositoryException;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jahia.bin.FindPrincipal;
import org.jahia.bin.Jahia;
import org.jahia.exceptions.JahiaException;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindPrincipalTest
extends JahiaTestCase {
    private static Logger logger = LoggerFactory.getLogger(FindPrincipalTest.class);
    private HttpClient client;
    private static final String TESTSITE_NAME = "findPrincipalTestSite";
    private static final String SITECONTENT_ROOT_NODE = "/sites/findPrincipalTestSite";

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    try {
                        TestHelper.createSite(FindPrincipalTest.TESTSITE_NAME, "localhost", "templates-web");
                    }
                    catch (Exception ex) {
                        logger.warn("Exception during site creation", (Throwable)ex);
                        Assert.fail("Exception during site creation");
                    }
                    session.save();
                    return null;
                }
            });
        }
        catch (Exception ex) {
            logger.warn("Exception during test setUp", (Throwable)ex);
            Assert.fail();
        }
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
            if (session.nodeExists(SITECONTENT_ROOT_NODE)) {
                TestHelper.deleteSite(TESTSITE_NAME);
            }
            session.save();
        }
        catch (Exception ex) {
            logger.warn("Exception during test tearDown", (Throwable)ex);
        }
    }

    @Before
    public void setUp() throws Exception {
        this.client = new HttpClient();
        PostMethod loginMethod = new PostMethod(this.getLoginServletURL());
        try {
            loginMethod.addParameter("username", "root");
            loginMethod.addParameter("password", "root1234");
            loginMethod.addParameter("redirectActive", "false");
            loginMethod.addParameter("doLogin", "1");
            loginMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
            int statusCode = this.client.executeMethod((HttpMethod)loginMethod);
            Assert.assertEquals("Method failed: " + loginMethod.getStatusLine(), 200L, statusCode);
        }
        finally {
            loginMethod.releaseConnection();
        }
    }

    @After
    public void tearDown() throws Exception {
        PostMethod logoutMethod = new PostMethod(this.getLogoutServletURL());
        try {
            logoutMethod.addParameter("redirectActive", "false");
            logoutMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
            int statusCode = this.client.executeMethod((HttpMethod)logoutMethod);
            Assert.assertEquals("Method failed: " + logoutMethod.getStatusLine(), 200L, statusCode);
        }
        finally {
            logoutMethod.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFindUsers() throws IOException, JSONException, JahiaException {
        PostMethod method = new PostMethod(this.getFindPrincipalServletURL());
        try {
            method.addParameter("principalType", "users");
            method.addParameter("wildcardTerm", "*root*");
            method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
            int statusCode = this.client.executeMethod((HttpMethod)method);
            Assert.assertEquals("Method failed: " + method.getStatusLine(), 200L, statusCode);
            StringBuilder responseBodyBuilder = new StringBuilder();
            responseBodyBuilder.append("[").append(method.getResponseBodyAsString()).append("]");
            String responseBody = responseBodyBuilder.toString();
            JSONArray jsonResults = new JSONArray(responseBody);
            Assert.assertNotNull("A proper JSONObject instance was expected, got null instead", jsonResults);
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFindGroups() throws IOException, JSONException {
        PostMethod method = new PostMethod(this.getFindPrincipalServletURL());
        try {
            method.addParameter("principalType", "groups");
            method.addParameter("siteKey", TESTSITE_NAME);
            method.addParameter("wildcardTerm", "*administrators*");
            method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
            int statusCode = this.client.executeMethod((HttpMethod)method);
            Assert.assertEquals("Method failed: " + method.getStatusLine(), 200L, statusCode);
            StringBuilder responseBodyBuilder = new StringBuilder();
            responseBodyBuilder.append("[").append(method.getResponseBodyAsString()).append("]");
            String responseBody = responseBodyBuilder.toString();
            JSONArray jsonResults = new JSONArray(responseBody);
            Assert.assertNotNull("A proper JSONObject instance was expected, got null instead", jsonResults);
        }
        finally {
            method.releaseConnection();
        }
    }

    private String getLoginServletURL() {
        return this.getBaseServerURL() + Jahia.getContextPath() + "/cms/login";
    }

    private String getLogoutServletURL() {
        return this.getBaseServerURL() + Jahia.getContextPath() + "/cms/logout";
    }

    private String getFindPrincipalServletURL() {
        return this.getBaseServerURL() + Jahia.getContextPath() + FindPrincipal.getFindPrincipalServletPath();
    }
}

