/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.bin;

import java.io.IOException;
import java.util.Locale;
import javax.jcr.RepositoryException;
import org.jahia.bin.Find;
import org.jahia.bin.Jahia;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.exceptions.JahiaException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.sites.JahiaSite;
import org.jahia.settings.SettingsBean;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.jahia.utils.LanguageCodeConverters;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class FindTest
extends JahiaTestCase {
    private static final Logger logger = LoggerFactory.getLogger(FindTest.class);
    private static final String TESTSITE_NAME = "findTestSite";
    private static final String SITECONTENT_ROOT_NODE = "/sites/findTestSite";
    private static JahiaSite site;
    private static final String INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE = "English text";
    private static final String COMPLEX_QUERY_VALUE = "b:+-*\"&()[]{}$/\\%'";
    private static final String FIND_DISABLED = "jahia.find.disabled";
    private static String isFindDisabled;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    try {
                        site = TestHelper.createSite(FindTest.TESTSITE_NAME);
                        session.save();
                    }
                    catch (Exception ex) {
                        logger.warn("Exception during site creation", (Throwable)ex);
                        Assert.fail("Exception during site creation");
                    }
                    return null;
                }
            });
            JCRPublicationService jcrService = ServicesRegistry.getInstance().getJCRPublicationService();
            String defaultLanguage = site.getDefaultLanguage();
            Locale englishLocale = Locale.ENGLISH;
            JCRSessionWrapper englishEditSession = jcrService.getSessionFactory().getCurrentUserSession("default", englishLocale, LanguageCodeConverters.languageCodeToLocale((String)defaultLanguage));
            JCRNodeWrapper englishEditSiteRootNode = englishEditSession.getNode(SITECONTENT_ROOT_NODE);
            JCRNodeWrapper englishEditSiteHomeNode = englishEditSiteRootNode.getNode("home");
            JCRNodeWrapper contentList0 = TestHelper.createList(englishEditSiteHomeNode, "contentList0", 5, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
            JCRNodeWrapper complexValueNode = contentList0.addNode("complex-value", "jnt:mainContent");
            complexValueNode.setProperty("jcr:title", COMPLEX_QUERY_VALUE);
            complexValueNode.setProperty("body", COMPLEX_QUERY_VALUE);
            TestHelper.createList(englishEditSiteHomeNode, "contentList1", 5, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
            TestHelper.createList(englishEditSiteHomeNode, "contentList2", 5, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
            TestHelper.createList(englishEditSiteHomeNode, "contentList3", 5, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
            TestHelper.createList(englishEditSiteHomeNode, "contentList4", 5, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
            englishEditSession.save();
            isFindDisabled = SettingsBean.getInstance().getPropertiesFile().getProperty(FIND_DISABLED);
            FindTest.setFindServletDisabled("false");
        }
        catch (Exception ex) {
            logger.warn("Exception during test setUp", (Throwable)ex);
            Assert.fail();
        }
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
            if (session.nodeExists(SITECONTENT_ROOT_NODE)) {
                TestHelper.deleteSite(TESTSITE_NAME);
            }
            session.save();
        }
        catch (Exception ex) {
            logger.warn("Exception during test tearDown", (Throwable)ex);
        }
        finally {
            FindTest.setFindServletDisabled(isFindDisabled);
        }
    }

    private static void setFindServletDisabled(String disabled) {
        SettingsBean.getInstance().getPropertiesFile().setProperty(FIND_DISABLED, disabled);
        ApplicationContext ctx = (ApplicationContext)JahiaContextLoaderListener.getServletContext().getAttribute("org.springframework.web.servlet.FrameworkServlet.CONTEXT.RendererDispatcherServlet");
        Find findServlet = (Find)ctx.getBean("org.jahia.bin.Find");
        findServlet.setDisabled(Boolean.parseBoolean(disabled));
    }

    @Before
    public void setUp() throws Exception {
        this.loginRoot();
    }

    @After
    public void tearDown() throws Exception {
        this.logout();
    }

    @Test
    public void testFindEscapingWithXPath() throws IOException, JSONException, JahiaException {
        JahiaTestCase.PostResult post = this.post(this.getFindServletURL() + "/" + "default" + "/en", {"query", "/jcr:root/sites/findTestSite//element(*, nt:base)[jcr:contains(.,'{$q}')]"}, {"q", COMPLEX_QUERY_VALUE}, {"language", "xpath"}, {"propertyMatchRegexp", "{$q}.*"}, {"removeDuplicatePropValues", "true"}, {"depthLimit", "1"});
        Assert.assertEquals("Method failed: " + post.statusLine, 200L, post.statusCode);
        String responseBody = post.responseBody;
        if (!responseBody.startsWith("[")) {
            StringBuilder responseBodyBuilder = new StringBuilder();
            responseBodyBuilder.append("[").append(post.responseBody).append("]");
            responseBody = responseBodyBuilder.toString();
        }
        logger.debug("Status code={} JSON response={}", (Object)post.statusCode, (Object)post.responseBody);
        JSONArray jsonResults = new JSONArray(responseBody);
        Assert.assertNotNull("A proper JSONObject instance was expected, got null instead", jsonResults);
        Assert.assertTrue("Result should not be empty !", jsonResults.length() > 0);
        this.validateFindJSONResults(jsonResults, COMPLEX_QUERY_VALUE);
    }

    @Test
    public void testSimpleFindWithSQL2() throws IOException, JSONException {
        JahiaTestCase.PostResult post = this.post(this.getFindServletURL() + "/" + "default" + "/en", {"query", "select * from [nt:base] as base where isdescendantnode([/sites/findTestSite/]) and contains(base.*,'{$q}*')"}, {"q", INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE}, {"language", "JCR-SQL2"}, {"propertyMatchRegexp", "{$q}.*"}, {"removeDuplicatePropValues", "true"}, {"depthLimit", "1"}, {"getNodes", "true"});
        Assert.assertEquals("Method failed: " + post.statusLine, 200L, post.statusCode);
        String responseBody = post.responseBody;
        if (!responseBody.startsWith("[")) {
            StringBuilder responseBodyBuilder = new StringBuilder();
            responseBodyBuilder.append("[").append(post.responseBody).append("]");
            responseBody = responseBodyBuilder.toString();
        }
        logger.debug("Status code={} JSON response={}", (Object)post.statusCode, (Object)post.responseBody);
        JSONArray jsonResults = new JSONArray(responseBody);
        Assert.assertNotNull("A proper JSONObject instance was expected, got null instead", jsonResults);
        Assert.assertTrue("Result should not be empty !", jsonResults.length() > 0);
        this.validateFindJSONResults(jsonResults, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
    }

    @Test
    public void testFindEscapingWithSQL2() throws IOException, JSONException {
        JahiaTestCase.PostResult post = this.post(this.getFindServletURL() + "/" + "default" + "/en", {"query", "select * from [nt:base] as base where isdescendantnode([/sites/findTestSite/]) and contains(base.*,'{$q}')"}, {"q", COMPLEX_QUERY_VALUE}, {"language", "JCR-SQL2"}, {"propertyMatchRegexp", "{$q}.*"}, {"removeDuplicatePropValues", "true"}, {"depthLimit", "1"}, {"getNodes", "true"});
        Assert.assertEquals("Method failed: " + post.statusLine, 200L, post.statusCode);
        String responseBody = post.responseBody;
        if (!responseBody.startsWith("[")) {
            StringBuilder responseBodyBuilder = new StringBuilder();
            responseBodyBuilder.append("[").append(post.responseBody).append("]");
            responseBody = responseBodyBuilder.toString();
        }
        logger.debug("Status code={} JSON response={}", (Object)post.statusCode, (Object)post.responseBody);
        JSONArray jsonResults = new JSONArray(responseBody);
        Assert.assertNotNull("A proper JSONObject instance was expected, got null instead", jsonResults);
        Assert.assertTrue("Result should not be empty !", jsonResults.length() > 0);
        this.validateFindJSONResults(jsonResults, COMPLEX_QUERY_VALUE);
    }

    private String getFindServletURL() {
        return this.getBaseServerURL() + Jahia.getContextPath() + Find.getFindServletPath();
    }

    private void validateFindJSONResults(JSONArray jsonResults, String textToValidate) throws JSONException {
        for (int i = 0; i < jsonResults.length(); ++i) {
            if (jsonResults.get(i) instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)jsonResults.get(i);
                for (int j = 0; j < jsonArray.length(); ++j) {
                    this.validateFindJSONResults((JSONObject)jsonResults.get(j), textToValidate);
                }
                continue;
            }
            this.validateFindJSONResults((JSONObject)jsonResults.get(i), textToValidate);
        }
    }

    private void validateFindJSONResults(JSONObject jsonObject, String textToValidate) throws JSONException {
        if (jsonObject.has("jcr:score")) {
            jsonObject = jsonObject.getJSONObject("node");
        }
        JSONArray matchingPropertiesJSONArray = jsonObject.getJSONArray("matchingProperties");
        Assert.assertEquals("Expected two matching properties : jcr:title and body", 2L, matchingPropertiesJSONArray.length());
        for (int k = 0; k < matchingPropertiesJSONArray.length(); ++k) {
            String matchingPropertyName = (String)matchingPropertiesJSONArray.get(k);
            String propertyValue = jsonObject.getString(matchingPropertyName);
            Assert.assertNotNull("Property " + matchingPropertyName + " not found or null !", propertyValue);
            Assert.assertTrue("Expected matching property " + matchingPropertyName + " to start with value " + textToValidate, propertyValue.startsWith(textToValidate));
        }
    }

    @Test
    public void testFiltering() throws IOException, JSONException {
        JahiaTestCase.PostResult post = this.post(this.getFindServletURL() + "/" + "live" + "/en", {"query", "select * from [jnt:user] where ischildnode('/users/')"}, {"depthLimit", "10"});
        logger.debug("Status code={} JSON response=[]", (Object)post.statusCode, (Object)post.responseBody);
        Assert.assertFalse("Root user is not filtered out from the results", post.responseBody.contains("/users/root"));
        Assert.assertFalse("Password policy nodes are not filtered out from the results", post.responseBody.contains("jnt:passwordHistory"));
        post = this.post(this.getFindServletURL() + "/" + "live" + "/en", {"query", "select * from [jnt:user]"}, {"depthLimit", "10"}, {"limit", "10"});
        Assert.assertFalse("j:password property is not filtered out from the results", post.responseBody.contains("j:password"));
        Assert.assertFalse("Password policy nodes are not filtered out from the results", post.responseBody.contains("jnt:passwordHistory"));
    }
}

