/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.bin;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.jahia.bin.JahiaController;
import org.jahia.bin.errors.DefaultErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class LogWatcher
extends JahiaController {
    private static Logger logger = LoggerFactory.getLogger(LogWatcher.class);
    private Map<String, LogExceptionExtractor> errorLogAppenders = new HashMap<String, LogExceptionExtractor>();
    private static final String DEFAULT_APPENDER_KEY = "defaultAppenderKey";

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            if (request.getMethod().equalsIgnoreCase("GET")) {
                String operation = request.getParameter("op");
                String appenderKey = request.getParameter("key");
                if (StringUtils.isEmpty((String)appenderKey)) {
                    appenderKey = DEFAULT_APPENDER_KEY;
                }
                LogExceptionExtractor logAppender = this.errorLogAppenders.remove(appenderKey);
                org.apache.log4j.Logger rootLogger = org.apache.log4j.Logger.getRootLogger();
                if (logAppender != null) {
                    rootLogger.removeAppender((Appender)logAppender);
                    logger.info("Error logging (key=" + appenderKey + ") stopped");
                }
                if ("start".equals(operation)) {
                    logAppender = new LogExceptionExtractor();
                    logAppender.setName(appenderKey);
                    this.errorLogAppenders.put(appenderKey, logAppender);
                    logger.info("Error logging (key=" + appenderKey + ") started");
                    response.getWriter().println("OK");
                    rootLogger.addAppender((Appender)logAppender);
                } else if (logAppender != null) {
                    response.getWriter().println(logAppender.getErrorLogs());
                }
            } else if (request.getMethod().equals("OPTIONS")) {
                response.setHeader("Allow", "GET, OPTIONS");
            } else {
                response.sendError(405);
            }
        }
        catch (Exception e) {
            DefaultErrorHandler.getInstance().handle((Throwable)e, request, response);
        }
        return null;
    }

    class LogExceptionExtractor
    extends AppenderSkeleton {
        StringBuffer errorLogs = new StringBuffer();
        FastDateFormat timestampFormatter = FastDateFormat.getInstance((String)"yyyy-MM-dd hh:mm:ss,mmm");
        private String newLine = System.getProperty("line.separator") != null ? System.getProperty("line.separator") : "\n";
        long lastTimeStamp = 0L;

        protected void append(LoggingEvent event) {
            if (event.getLevel().toInt() >= 40000) {
                StringBuilder errorLog = new StringBuilder();
                if (event.timeStamp - this.lastTimeStamp > 2000L) {
                    errorLog.append(this.newLine);
                }
                errorLog.append(this.timestampFormatter.format(new Date(event.timeStamp))).append(" ").append(event.getRenderedMessage()).append(this.newLine);
                String[] throwableStringRep = event.getThrowableStrRep();
                if (throwableStringRep != null) {
                    for (String stacktraceLine : throwableStringRep) {
                        errorLog.append(stacktraceLine).append(this.newLine);
                    }
                    errorLog.append(this.newLine);
                }
                this.errorLogs.append(errorLog.toString());
                this.lastTimeStamp = event.timeStamp;
            }
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }

        public String getErrorLogs() {
            return this.errorLogs.toString();
        }
    }
}

