/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.bin;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jahia.bin.Jahia;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRVersionService;
import org.jahia.services.content.PublicationInfo;
import org.jahia.services.content.VersionInfo;
import org.jahia.services.sites.JahiaSite;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.comparator.NumericStringComparator;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderTest
extends JahiaTestCase {
    private static Logger logger = LoggerFactory.getLogger(RenderTest.class);
    private JahiaSite site;
    private static final String TESTSITE_NAME = "renderTest";
    private static final String SITECONTENT_ROOT_NODE = "/sites/renderTest";
    private static final String MAIN_CONTENT_TITLE = "Main content title update ";
    private static final String MAIN_CONTENT_BODY = "Main content body update ";
    private static int NUMBER_OF_VERSIONS = 5;
    private SimpleDateFormat yyyy_mm_dd_hh_mm_ss = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");

    @Before
    public void setUp() throws Exception {
        this.site = TestHelper.createSite(TESTSITE_NAME, "localhost" + System.currentTimeMillis(), "templates-intranet");
        Assert.assertNotNull(this.site);
        this.loginRoot();
    }

    @After
    public void tearDown() throws Exception {
        try {
            TestHelper.deleteSite(TESTSITE_NAME);
        }
        catch (Exception ex) {
            logger.warn("Exception during test tearDown", (Throwable)ex);
        }
        JCRSessionFactory.getInstance().closeAllSessions();
        this.logout();
    }

    private List<String> getUuids(List<PublicationInfo> publicationInfo) {
        LinkedList<String> uuids = new LinkedList<String>();
        for (PublicationInfo info : publicationInfo) {
            uuids.addAll(info.getAllUuids());
        }
        return uuids;
    }

    @Test
    public void testVersionRender() throws RepositoryException, ParseException, IOException {
        JCRPublicationService jcrService = ServicesRegistry.getInstance().getJCRPublicationService();
        JCRVersionService jcrVersionService = ServicesRegistry.getInstance().getJCRVersionService();
        JCRSessionWrapper editSession = jcrService.getSessionFactory().getCurrentUserSession("default", Locale.ENGLISH);
        JCRSessionWrapper liveSession = jcrService.getSessionFactory().getCurrentUserSession("live", Locale.ENGLISH);
        JCRNodeWrapper stageRootNode = editSession.getNode(SITECONTENT_ROOT_NODE);
        Node versioningTestActivity = editSession.getWorkspace().getVersionManager().createActivity("versioningTest");
        Node previousActivity = editSession.getWorkspace().getVersionManager().setActivity(versioningTestActivity);
        if (previousActivity != null) {
            logger.debug("Previous activity=" + previousActivity.getName() + " new activity=" + versioningTestActivity.getName());
        } else {
            logger.debug("New activity=" + versioningTestActivity.getName());
        }
        LinkedHashSet<String> languagesStringSet = new LinkedHashSet<String>();
        languagesStringSet.add(Locale.ENGLISH.toString());
        jcrService.publishByInfoList(jcrService.getPublicationInfo(stageRootNode.getNode("search-results").getIdentifier(), languagesStringSet, true, true, true, "default", "live"), "default", "live", Collections.emptyList());
        JCRNodeWrapper stageNode = stageRootNode.getNode("home");
        editSession.checkout((Node)stageNode);
        JCRNodeWrapper stagedSubPage = stageNode.addNode("home_subpage1", "jnt:page");
        stagedSubPage.setProperty("j:templateName", "simple");
        stagedSubPage.setProperty("jcr:title", "title0");
        editSession.save();
        List publicationInfo = jcrService.getPublicationInfo(stageNode.getIdentifier(), languagesStringSet, true, true, true, "default", "live");
        jcrService.publishByInfoList(publicationInfo, "default", "live", Collections.emptyList());
        String label = "published_at_" + this.yyyy_mm_dd_hh_mm_ss.format(GregorianCalendar.getInstance().getTime());
        List<String> uuids = this.getUuids(publicationInfo);
        jcrVersionService.addVersionLabel(uuids, label, "live");
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        for (int i = 1; i < NUMBER_OF_VERSIONS; ++i) {
            editSession.checkout((Node)stagedSubPage);
            stagedSubPage.setProperty("jcr:title", "title" + i);
            editSession.save();
            publicationInfo = jcrService.getPublicationInfo(stagedSubPage.getIdentifier(), languagesStringSet, true, true, true, "default", "live");
            jcrService.publishByInfoList(publicationInfo, "default", "live", Collections.emptyList());
            label = "published_at_" + this.yyyy_mm_dd_hh_mm_ss.format(GregorianCalendar.getInstance().getTime());
            uuids = this.getUuids(publicationInfo);
            jcrVersionService.addVersionLabel(uuids, label, "live");
            try {
                Thread.sleep(30000L);
                continue;
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        editSession.getWorkspace().getVersionManager().checkpoint(stagedSubPage.getPath());
        JCRNodeWrapper subPagePublishedNode = liveSession.getNode(stagedSubPage.getPath());
        List liveVersionInfos = jcrVersionService.getVersionInfos((Session)liveSession, subPagePublishedNode);
        Collections.sort(liveVersionInfos, new Comparator<VersionInfo>(){

            @Override
            public int compare(VersionInfo o1, VersionInfo o2) {
                NumericStringComparator numericStringComparator = new NumericStringComparator(Locale.ENGLISH);
                return numericStringComparator.compare((Object)o1.getLabel(), (Object)o2.getLabel());
            }
        });
        int index = 0;
        for (VersionInfo curVersionInfo : liveVersionInfos) {
            Version version = curVersionInfo.getVersion();
            if (version.getCreated() == null || curVersionInfo.getLabel() == null) continue;
            String responseBody = this.getAsText("/cms/render/live/en" + subPagePublishedNode.getPath() + ".html?v=" + (this.yyyy_mm_dd_hh_mm_ss.parse(curVersionInfo.getLabel().split("_at_")[1]).getTime() + 5000L));
            logger.debug("Response body=[" + responseBody + "]");
            Assert.assertFalse("Couldn't find expected value (title" + Integer.toString(index) + ") in response body", responseBody.indexOf("title" + Integer.toString(index)) < 0);
            ++index;
        }
        logger.debug("number of version: {}", (Object)index);
        Assert.assertEquals(NUMBER_OF_VERSIONS, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestAPI() throws RepositoryException, IOException, JSONException {
        JCRPublicationService jcrService = ServicesRegistry.getInstance().getJCRPublicationService();
        Locale englishLocale = LanguageCodeConverters.languageCodeToLocale((String)"en");
        JCRSessionWrapper editSession = jcrService.getSessionFactory().getCurrentUserSession("default", englishLocale);
        jcrService.getSessionFactory().getCurrentUserSession("live", englishLocale);
        JCRNodeWrapper stageRootNode = editSession.getNode(SITECONTENT_ROOT_NODE);
        JCRNodeWrapper stageNode = stageRootNode.getNode("home");
        JCRNodeWrapper stagedPageContent = stageNode.getNode("listA");
        JCRNodeWrapper mainContent = stagedPageContent.addNode("mainContent", "jnt:mainContent");
        mainContent.setProperty("jcr:title", "Main content title update 0");
        mainContent.setProperty("body", "Main content body update 0");
        editSession.save();
        PostMethod createPost = new PostMethod(this.getBaseServerURL() + Jahia.getContextPath() + "/cms/render/default/en" + SITECONTENT_ROOT_NODE + "/home/listA/*");
        createPost.addRequestHeader("x-requested-with", "XMLHttpRequest");
        createPost.addRequestHeader("accept", "application/json");
        createPost.addParameter("jcrNodeType", "jnt:mainContent");
        createPost.addParameter("jcr:title", "Main content title update 1");
        createPost.addParameter("body", "Main content body update 1");
        String responseBody = "";
        try {
            int responseCode = this.getHttpClient().executeMethod((HttpMethod)createPost);
            Assert.assertEquals("Error in response, code=" + responseCode, 201L, responseCode);
            responseBody = createPost.getResponseBodyAsString();
        }
        finally {
            createPost.releaseConnection();
        }
        JSONObject jsonResults = new JSONObject(responseBody);
        Assert.assertNotNull("A proper JSONObject instance was expected, got null instead", jsonResults);
        Assert.assertTrue("body property should be Main content body update 1", jsonResults.get("body").equals("Main content body update 1"));
    }
}

