/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.bin;

import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.test.TestHelper;
import org.jahia.test.bin.BaseTestController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCreateSiteServlet
extends BaseTestController {
    private static transient Logger logger = LoggerFactory.getLogger(TestCreateSiteServlet.class);
    private int numberOfParents = 0;
    private int numberOfChilds = 0;
    private int numberOfSubChilds = 0;
    private String siteKey = null;

    public void setNumberOfParents(int numberOfParents) {
        this.numberOfParents = numberOfParents;
    }

    public void setNumberOfChilds(int numberOfChilds) {
        this.numberOfChilds = numberOfChilds;
    }

    public void setNumberOfSubChilds(int numberOfSubChilds) {
        this.numberOfSubChilds = numberOfSubChilds;
    }

    public void setSiteKey(String siteKey) {
        this.siteKey = siteKey;
    }

    @Override
    protected void handleGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (httpServletRequest.getParameter("site").equals("ACME")) {
            if (httpServletRequest.getParameter("parents") != null) {
                this.setNumberOfParents(Integer.valueOf(httpServletRequest.getParameter("parents")));
            }
            if (httpServletRequest.getParameter("childs") != null) {
                this.setNumberOfChilds(Integer.valueOf(httpServletRequest.getParameter("childs")));
            }
            if (httpServletRequest.getParameter("subchilds") != null) {
                this.setNumberOfSubChilds(Integer.valueOf(httpServletRequest.getParameter("subchilds")));
            }
            if (httpServletRequest.getParameter("siteKey") != null) {
                this.setSiteKey(httpServletRequest.getParameter("siteKey"));
            }
            final JCRPublicationService jcrService = ServicesRegistry.getInstance().getJCRPublicationService();
            try {
                JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

                    public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        int numberOfSites = 0;
                        try {
                            numberOfSites = ServicesRegistry.getInstance().getJahiaSitesService().getNbSites();
                            if (TestCreateSiteServlet.this.siteKey == null) {
                                TestCreateSiteServlet.this.siteKey = "ACME" + numberOfSites;
                            }
                            TestHelper.createSite(TestCreateSiteServlet.this.siteKey, "localhost" + numberOfSites, "templates-web-blue", "prepackagedSites/acme.zip", "ACME.zip");
                            JCRNodeWrapper homeNode = session.getRootNode().getNode("sites/" + TestCreateSiteServlet.this.siteKey + "/home");
                            if (TestCreateSiteServlet.this.numberOfParents != 0) {
                                for (int i = 0; i < TestCreateSiteServlet.this.numberOfParents; ++i) {
                                    session.checkout((Node)homeNode);
                                    homeNode.getNode("news").copy(homeNode, "parents" + i, true);
                                    session.save();
                                    if (TestCreateSiteServlet.this.numberOfChilds == 0) continue;
                                    for (int j = 0; j < TestCreateSiteServlet.this.numberOfChilds; ++j) {
                                        session.checkout((Node)homeNode);
                                        homeNode.getNode("news").copy(homeNode.getNode("parents" + i), "news" + j, true);
                                        session.save();
                                        if (TestCreateSiteServlet.this.numberOfSubChilds == 0) continue;
                                        for (int k = 0; k < TestCreateSiteServlet.this.numberOfSubChilds; ++k) {
                                            session.checkout((Node)homeNode);
                                            homeNode.getNode("news").copy(homeNode.getNode("parents" + i + "/news" + j), "subnews" + k, true);
                                            session.save();
                                        }
                                    }
                                }
                            }
                            jcrService.publishByMainId(session.getRootNode().getNode("sites/" + TestCreateSiteServlet.this.siteKey).getIdentifier(), "default", "live", null, true, null);
                            session.save();
                            TestCreateSiteServlet.this.siteKey = null;
                        }
                        catch (Exception e) {
                            logger.error("Cannot create site", (Throwable)e);
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else if (httpServletRequest.getParameter("site").equals("mySite")) {
            try {
                int numberOfSites = ServicesRegistry.getInstance().getJahiaSitesService().getNbSites();
                TestHelper.createSite("mySite" + numberOfSites, "localhost" + numberOfSites, "templates-intranet");
            }
            catch (Exception e) {
                logger.warn("Exception during mySite Creation", (Throwable)e);
            }
        } else if (httpServletRequest.getParameter("site").equals("delete")) {
            try {
                for (JCRSiteNode siteToDelete : ServicesRegistry.getInstance().getJahiaSitesService().getSitesNodeList()) {
                    TestHelper.deleteSite(siteToDelete.getSiteKey());
                }
            }
            catch (Exception e) {
                logger.warn("Exception during test tearDown", (Throwable)e);
            }
        }
    }
}

