/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.bin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.history.NodeVersionHistoryListener;
import org.jahia.test.SurefireJUnitXMLResultFormatter;
import org.jahia.test.SurefireTestNGXMLResultFormatter;
import org.jahia.test.bin.BaseTestController;
import org.jahia.test.bin.TestBean;
import org.jahia.utils.ClassLoaderUtils;
import org.junit.internal.requests.FilterRequest;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.TestNG;
import org.testng.xml.Parser;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class TestServlet
extends BaseTestController {
    private static transient Logger logger = LoggerFactory.getLogger(TestServlet.class);

    @Override
    protected void handleGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String pathInfo = StringUtils.substringAfter((String)httpServletRequest.getPathInfo(), (String)"/test");
        boolean isHtmlOutput = ".html".equals(pathInfo);
        String xmlTest = httpServletRequest.getParameter("xmlTest");
        if (pathInfo.contains("selenium") || !StringUtils.isEmpty((String)xmlTest)) {
            JahiaTemplatesPackage seleniumModule = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById("selenium");
            if (seleniumModule == null) {
                throw new ServletException("Selenium module not found (or not started)");
            }
            TestNG myTestNG = new TestNG();
            SurefireTestNGXMLResultFormatter xmlResultFormatter = new SurefireTestNGXMLResultFormatter((OutputStream)httpServletResponse.getOutputStream());
            myTestNG.addListener(xmlResultFormatter);
            myTestNG.addListener(xmlResultFormatter);
            final Enumeration resources = seleniumModule.getBundle().findEntries("testng", StringUtils.defaultIfBlank((String)xmlTest, (String)"*.xml"), false);
            if (resources != null && resources.hasMoreElements()) {
                final ArrayList<XmlSuite> allSuites = new ArrayList<XmlSuite>();
                ClassLoaderUtils.executeWith((ClassLoader)seleniumModule.getClassLoader(), (ClassLoaderUtils.Callback)new ClassLoaderUtils.Callback<Boolean>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Boolean execute() {
                        while (resources.hasMoreElements()) {
                            InputStream is = null;
                            try {
                                is = ((URL)resources.nextElement()).openStream();
                                Parser parser = new Parser(is);
                                List<XmlSuite> suites = parser.parseToList();
                                for (XmlSuite suite : suites) {
                                    suite.setPreserveOrder("true");
                                    suite.setConfigFailurePolicy("continue");
                                    for (XmlTest test : suite.getTests()) {
                                        test.setPreserveOrder("true");
                                    }
                                }
                                allSuites.addAll(suites);
                            }
                            catch (Exception e) {
                                try {
                                    logger.error("Error executing test", (Throwable)e);
                                }
                                catch (Throwable throwable) {
                                    IOUtils.closeQuietly(is);
                                    throw throwable;
                                }
                                IOUtils.closeQuietly((InputStream)is);
                                continue;
                            }
                            IOUtils.closeQuietly((InputStream)is);
                        }
                        return Boolean.TRUE;
                    }
                });
                myTestNG.setXmlSuites(allSuites);
            } else {
                String className = pathInfo.substring(pathInfo.lastIndexOf(47) + 1);
                try {
                    Class<?> testClass = Class.forName(className);
                    List<Class<?>> classes = this.getTestClasses(testClass, new ArrayList());
                    if (!classes.isEmpty()) {
                        myTestNG.setTestClasses(classes.toArray(new Class[classes.size()]));
                    }
                }
                catch (Exception e) {
                    logger.error("Error executing test", (Throwable)e);
                }
            }
            String testOutputDirectory = httpServletRequest.getParameter("testOutputDirectory");
            if (!StringUtils.isEmpty((String)testOutputDirectory)) {
                myTestNG.setOutputDirectory(testOutputDirectory);
                logger.info("Output directory set to " + testOutputDirectory);
            }
            myTestNG.setConfigFailurePolicy("continue");
            myTestNG.setPreserveOrder(true);
            myTestNG.run();
        } else if (StringUtils.isNotEmpty((String)pathInfo) && !pathInfo.contains("*") && !pathInfo.trim().equals("/") && !isHtmlOutput) {
            this.runTest(httpServletRequest, httpServletResponse, pathInfo);
        } else {
            Pattern testNamePattern = !isHtmlOutput && StringUtils.isNotEmpty((String)pathInfo) && !pathInfo.trim().equals("/") ? Pattern.compile(pathInfo.length() > 1 && pathInfo.startsWith("/") ? pathInfo.substring(1) : pathInfo) : null;
            Set<String> testCases = this.getAllTestCases(Boolean.valueOf(httpServletRequest.getParameter("skipCoreTests")));
            PrintWriter pw = httpServletResponse.getWriter();
            LinkedList<String> tests = new LinkedList<String>();
            for (String o : testCases) {
                if (testNamePattern != null && !testNamePattern.matcher(o).matches()) continue;
                tests.add(o);
            }
            if (isHtmlOutput) {
                this.outputHtml(tests, httpServletRequest, httpServletResponse);
            } else {
                for (String c : tests) {
                    pw.println(c);
                }
            }
        }
    }

    private void outputHtml(List<String> tests, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html; charset=utf-8");
        PrintWriter pw = response.getWriter();
        pw.println("<!doctype html>");
        pw.println("");
        pw.println("<html lang=\"en\">");
        pw.println("<head>");
        pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>");
        pw.print("<link rel=\"stylesheet\" href=\"");
        pw.print(request.getContextPath());
        pw.println("/modules/tools/css/tools.css\" type=\"text/css\" />");
        pw.println("<title>DX Tests</title>");
        pw.println("</head>");
        pw.println("<body>");
        pw.println("<h1>");
        pw.println(tests.size());
        pw.println(" tests found");
        pw.println("</h1>");
        pw.println("<ul>");
        for (String test : tests) {
            pw.print("<li><a href=\"");
            pw.print(request.getContextPath());
            pw.print("/cms/test/");
            pw.print(test);
            pw.print("\">");
            pw.print(test);
            pw.println("</a></li>");
        }
        pw.println("</ul>");
        pw.println("</body>");
    }

    private void runTest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String pathInfo) {
        String className = pathInfo.substring(pathInfo.lastIndexOf(47) + 1);
        String methodName = httpServletRequest.getParameter("test");
        try {
            Class<?> testClass;
            JUnitCore junitcore = new JUnitCore();
            SurefireJUnitXMLResultFormatter xmlResultFormatter = new SurefireJUnitXMLResultFormatter((OutputStream)httpServletResponse.getOutputStream());
            junitcore.addListener(xmlResultFormatter);
            JahiaTemplatesPackage testPackage = this.findPackageForTestCase(className);
            Class<?> clazz = testClass = testPackage != null ? testPackage.getClassLoader().loadClass(className) : Class.forName(className);
            if (testClass == null) {
                throw new Exception("Couldn't find origin module for test " + className);
            }
            logger.info("Will use test class {}", (Object)testClass.getName());
            List<Class<?>> classes = this.getTestClasses(testClass, new ArrayList());
            if (classes.isEmpty()) {
                Description description = Description.createSuiteDescription(testClass);
                xmlResultFormatter.testRunStarted(description);
                xmlResultFormatter.testRunFinished(new Result());
            } else if (methodName != null) {
                logger.info("Executing test method {}.{}()", (Object)testClass.getName(), (Object)methodName);
                long start = System.currentTimeMillis();
                junitcore.run(Request.method(testClass, methodName));
                logger.info("Done executing test method {}.{}() in {} ms", new Object[]{testClass.getName(), methodName, System.currentTimeMillis() - start});
            } else {
                logger.info("Executing test classes {}", classes.toArray());
                long start = System.currentTimeMillis();
                final Set<String> ignoreTests = this.getIgnoreTests();
                Runner runner = new FilterRequest(Request.classes(classes.toArray(new Class[classes.size()])), new Filter(){

                    @Override
                    public boolean shouldRun(Description description) {
                        return !ignoreTests.contains(description.getDisplayName());
                    }

                    @Override
                    public String describe() {
                        return "Filter out Jahia configured methods";
                    }
                }).getRunner();
                if (runner instanceof ErrorReportingRunner) {
                    logger.warn("No tests remain after applying ignoreTests filter {} in {}", ignoreTests, (Object)classes.toArray());
                } else {
                    junitcore.run(runner);
                    logger.info("Done executing test classes {} in {} ms", (Object)classes.toArray(), (Object)(System.currentTimeMillis() - start));
                }
            }
        }
        catch (Exception e) {
            logger.error("Error executing test", (Throwable)e);
        }
    }

    private Set<String> getAllTestCases(boolean skipCore) {
        TreeSet<String> testCases = new TreeSet<String>();
        for (JahiaTemplatesPackage aPackage : ServicesRegistry.getInstance().getJahiaTemplateManagerService().getAvailableTemplatePackages()) {
            Map packageTestBeans;
            if (aPackage.getContext() == null || (packageTestBeans = aPackage.getContext().getBeansOfType(TestBean.class)).size() <= 0) continue;
            for (TestBean testBean : packageTestBeans.values()) {
                if (skipCore && testBean.isCoreTests()) continue;
                testCases.addAll(testBean.getTestCases());
            }
        }
        return testCases;
    }

    private JahiaTemplatesPackage findPackageForTestCase(String testCase) {
        for (JahiaTemplatesPackage aPackage : ServicesRegistry.getInstance().getJahiaTemplateManagerService().getAvailableTemplatePackages()) {
            Map packageTestBeans;
            if (aPackage.getContext() == null || (packageTestBeans = aPackage.getContext().getBeansOfType(TestBean.class)).size() <= 0) continue;
            for (TestBean testBean : packageTestBeans.values()) {
                for (String beanTestCase : testBean.getTestCases()) {
                    if (!beanTestCase.equals(testCase)) continue;
                    return aPackage;
                }
            }
        }
        return null;
    }

    private List<Class<?>> getTestClasses(Class<?> testClass, List<Class<?>> classes) {
        Method suiteMethod = null;
        try {
            suiteMethod = testClass.getMethod("suite", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (suiteMethod != null) {
            try {
                classes = this.getTestClasses((Test)suiteMethod.invoke(null, (Object[])new Class[0]), classes);
            }
            catch (Exception e) {
                logger.error("Error getting classes of suite", (Throwable)e);
            }
        } else {
            classes.add(testClass);
        }
        return classes;
    }

    private List<Class<?>> getTestClasses(Test test, List<Class<?>> classes) {
        if (test instanceof TestSuite) {
            HashSet tempClasses = new HashSet();
            Enumeration<Test> tests = ((TestSuite)test).tests();
            while (tests.hasMoreElements()) {
                Test currentTest = tests.nextElement();
                if (!(currentTest instanceof TestSuite) && tempClasses.contains(currentTest.getClass())) continue;
                classes = this.getTestClasses(currentTest, classes);
                tempClasses.add(currentTest.getClass());
            }
        } else {
            classes.add(test.getClass());
        }
        return classes;
    }

    private Set<String> getIgnoreTests() {
        HashSet<String> ignoreTests = new HashSet<String>();
        for (JahiaTemplatesPackage aPackage : ServicesRegistry.getInstance().getJahiaTemplateManagerService().getAvailableTemplatePackages()) {
            Map packageTestBeans;
            if (aPackage.getContext() == null || (packageTestBeans = aPackage.getContext().getBeansOfType(TestBean.class)).size() <= 0) continue;
            for (TestBean testBean : packageTestBeans.values()) {
                if (testBean.getIgnoredTests() == null) continue;
                ignoreTests.addAll(testBean.getIgnoredTests());
            }
        }
        return ignoreTests;
    }

    static {
        NodeVersionHistoryListener.setDisabled((boolean)true);
    }
}

