/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.performance.jackrabbit;

import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.sites.JahiaSite;
import org.jahia.test.TestHelper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

public class ConcurrentReadTest {
    private static transient Logger logger = LoggerFactory.getLogger(ConcurrentReadTest.class);
    private static final String TESTSITE_NAME = "jcrConcurrentReadTest";
    private static final String SITECONTENT_ROOT_NODE = "/sites/jcrConcurrentReadTest";
    private static final String INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE = "English text";
    public static final int NB_CHILDREN = 10;
    private static final int CHILD_COUNT = 1000;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        try {
            JahiaSite site = TestHelper.createSite(TESTSITE_NAME);
            JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    StopWatch stopWatch = new StopWatch("oneTimeSetUp");
                    stopWatch.start(Thread.currentThread().getName() + " creating set up nodes");
                    int pagesCreated = TestHelper.createSubPages((Node)session.getNode(ConcurrentReadTest.SITECONTENT_ROOT_NODE), 3, 10);
                    logger.info("Created " + pagesCreated + " page hierarchy.");
                    session.save();
                    stopWatch.stop();
                    logger.error(stopWatch.prettyPrint());
                    return null;
                }
            });
            Assert.assertNotNull(site);
        }
        catch (Exception ex) {
            logger.warn("Exception during test setUp", (Throwable)ex);
            Assert.fail();
        }
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        try {
            TestHelper.deleteSite(TESTSITE_NAME);
        }
        catch (Exception ex) {
            logger.warn("Exception during test tearDown", (Throwable)ex);
        }
    }

    @Test
    public void testCreateManyChildUnstructuredNodes() throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                StopWatch stopWatch = new StopWatch("testCreateManyChildUnstructuredNodes");
                stopWatch.start(Thread.currentThread().getName() + " creating unstructured nodes");
                JCRNodeWrapper currentNode = session.getNode(ConcurrentReadTest.SITECONTENT_ROOT_NODE);
                JCRNodeWrapper node = currentNode.addNode("testnodeUnstructured", "nt:unstructured");
                for (int i = 0; i < 1000; ++i) {
                    node.addNode("node" + i, "nt:unstructured");
                }
                session.save();
                stopWatch.stop();
                logger.error(stopWatch.prettyPrint());
                return null;
            }
        });
    }

    @Test
    public void testCreateManyChildPageNodes() throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                StopWatch stopWatch = new StopWatch("testCreateManyChildPageNodes");
                stopWatch.start(Thread.currentThread().getName() + " creating page nodes");
                JCRNodeWrapper currentNode = session.getNode(ConcurrentReadTest.SITECONTENT_ROOT_NODE);
                JCRNodeWrapper node = currentNode.addNode("testPageNode", "jnt:page");
                for (int i = 0; i < 1000; ++i) {
                    node.addNode("child" + Integer.toString(i), "jnt:page");
                }
                session.save();
                stopWatch.stop();
                logger.error(stopWatch.prettyPrint());
                return null;
            }
        });
    }

    @Test
    public void testConcurrentRead() throws InterruptedException, ExecutionException {
        int i;
        ExecutorService executor = Executors.newFixedThreadPool(300);
        ExecutorCompletionService<Boolean> service = new ExecutorCompletionService<Boolean>(executor);
        StopWatch stopWatch = new StopWatch("testConcurrentRead");
        stopWatch.start(Thread.currentThread().getName() + " only reading nodes");
        for (i = 0; i < 1000; ++i) {
            service.submit(new Reader(), Boolean.TRUE);
        }
        for (i = 0; i < 1000; ++i) {
            Boolean bl = (Boolean)service.take().get();
        }
        stopWatch.stop();
        logger.error(stopWatch.prettyPrint());
        executor.shutdown();
    }

    @Test
    public void testConcurrentReadWrite10Percent() throws InterruptedException, ExecutionException {
        int i;
        ExecutorService executor = Executors.newFixedThreadPool(300);
        ExecutorCompletionService<Boolean> service = new ExecutorCompletionService<Boolean>(executor);
        StopWatch stopWatch = new StopWatch("testConcurrentReadWrite10Percent");
        stopWatch.start(Thread.currentThread().getName() + " reading // writing nodes (10% writers)");
        for (i = 0; i < 1000; ++i) {
            if (i % 10 == 0) {
                service.submit(new Writer("jnt:page"), Boolean.TRUE);
                continue;
            }
            service.submit(new Reader(), Boolean.TRUE);
        }
        for (i = 0; i < 1000; ++i) {
            Boolean bl = (Boolean)service.take().get();
        }
        stopWatch.stop();
        logger.error(stopWatch.prettyPrint());
        executor.shutdown();
    }

    @Test
    public void testConcurrentReadWrite1Percent() throws InterruptedException, ExecutionException {
        int i;
        ExecutorService executor = Executors.newFixedThreadPool(300);
        ExecutorCompletionService<Boolean> service = new ExecutorCompletionService<Boolean>(executor);
        StopWatch stopWatch = new StopWatch("testConcurrentReadWrite1Percent");
        stopWatch.start(Thread.currentThread().getName() + " reading // writing nodes (1% writers)");
        for (i = 0; i < 1000; ++i) {
            if (i % 100 == 0) {
                service.submit(new Writer("jnt:page"), Boolean.TRUE);
                continue;
            }
            service.submit(new Reader(), Boolean.TRUE);
        }
        for (i = 0; i < 1000; ++i) {
            Boolean bl = (Boolean)service.take().get();
        }
        stopWatch.stop();
        logger.error(stopWatch.prettyPrint());
        executor.shutdown();
    }

    @Test
    public void testConcurrentReadWrite10PercentUnstructured() throws InterruptedException, ExecutionException {
        int i;
        ExecutorService executor = Executors.newFixedThreadPool(300);
        ExecutorCompletionService<Boolean> service = new ExecutorCompletionService<Boolean>(executor);
        StopWatch stopWatch = new StopWatch("testConcurrentReadWrite10PercentUnstructured");
        stopWatch.start(Thread.currentThread().getName() + " reading // writing nodes (10% writers)");
        for (i = 0; i < 1000; ++i) {
            if (i % 10 == 0) {
                service.submit(new Writer("nt:unstructured"), Boolean.TRUE);
                continue;
            }
            service.submit(new Reader(), Boolean.TRUE);
        }
        for (i = 0; i < 1000; ++i) {
            Boolean bl = (Boolean)service.take().get();
        }
        stopWatch.stop();
        logger.error(stopWatch.prettyPrint());
        executor.shutdown();
    }

    @Test
    public void testConcurrentSearchIsDescendant() throws InterruptedException, ExecutionException {
        int i;
        ExecutorService executor = Executors.newFixedThreadPool(300);
        ExecutorCompletionService<Boolean> service = new ExecutorCompletionService<Boolean>(executor);
        StopWatch stopWatch = new StopWatch("testConcurrentSearchIsDescendant");
        stopWatch.start(Thread.currentThread().getName() + " search jnt:pages nodes is descendant site node");
        for (i = 0; i < 1000; ++i) {
            service.submit(new Search("select * from [jnt:page] as page where isdescendantnode(page, 'path') "), Boolean.TRUE);
        }
        for (i = 0; i < 1000; ++i) {
            Boolean bl = (Boolean)service.take().get();
        }
        stopWatch.stop();
        logger.error(stopWatch.prettyPrint());
        executor.shutdown();
    }

    @Test
    public void testConcurrentSearchIsChild() throws InterruptedException, ExecutionException {
        int i;
        ExecutorService executor = Executors.newFixedThreadPool(300);
        ExecutorCompletionService<Boolean> service = new ExecutorCompletionService<Boolean>(executor);
        StopWatch stopWatch = new StopWatch("testConcurrentSearchIsChild");
        stopWatch.start(Thread.currentThread().getName() + " search jnt:pages nodes is child site node");
        for (i = 0; i < 1000; ++i) {
            service.submit(new Search("select * from [jnt:page] as page where ischildnode(page, 'path') "), Boolean.TRUE);
        }
        for (i = 0; i < 1000; ++i) {
            Boolean bl = (Boolean)service.take().get();
        }
        stopWatch.stop();
        logger.error(stopWatch.prettyPrint());
        executor.shutdown();
    }

    @Test
    public void testConcurrentSearchIsDescendantAndIteratorResults() throws InterruptedException, ExecutionException {
        int i;
        ExecutorService executor = Executors.newFixedThreadPool(300);
        ExecutorCompletionService<Boolean> service = new ExecutorCompletionService<Boolean>(executor);
        StopWatch stopWatch = new StopWatch("testConcurrentSearchIsDescendantAndIteratorResults");
        stopWatch.start(Thread.currentThread().getName() + " search jnt:page nodes is descendant site node, iterator results for query results size = -1 ");
        for (i = 0; i < 1000; ++i) {
            service.submit(new SearchIteratorResults("select * from [jnt:page] as page where isdescendantnode(page, 'path') "), Boolean.TRUE);
        }
        for (i = 0; i < 1000; ++i) {
            Boolean bl = (Boolean)service.take().get();
        }
        stopWatch.stop();
        logger.error(stopWatch.prettyPrint());
        executor.shutdown();
    }

    @Test
    public void testConcurrentSearchIsCreatedBeforeNow() throws InterruptedException, ExecutionException {
        int i;
        ExecutorService executor = Executors.newFixedThreadPool(300);
        ExecutorCompletionService<Boolean> service = new ExecutorCompletionService<Boolean>(executor);
        StopWatch stopWatch = new StopWatch("testConcurrentSearchIsCreatedBeforeNow");
        stopWatch.start(Thread.currentThread().getName() + " search jnt:page nodes is created before now");
        for (i = 0; i < 1000; ++i) {
            service.submit(new Search("select * from [jnt:page] as page where page.[jcr:created] < CAST(" + System.currentTimeMillis() + " as date) "), Boolean.TRUE);
        }
        for (i = 0; i < 1000; ++i) {
            Boolean bl = (Boolean)service.take().get();
        }
        stopWatch.stop();
        logger.error(stopWatch.prettyPrint());
        executor.shutdown();
    }

    @Test
    public void testConcurrentSearchIsCreatedBeforeNowAndIsDescendant() throws InterruptedException, ExecutionException {
        int i;
        ExecutorService executor = Executors.newFixedThreadPool(300);
        ExecutorCompletionService<Boolean> service = new ExecutorCompletionService<Boolean>(executor);
        StopWatch stopWatch = new StopWatch("testConcurrentSearchIsCreatedBeforeNowAndIsDescendant");
        stopWatch.start(Thread.currentThread().getName() + " search jnt:page nodes is created before now and is descendant site node");
        for (i = 0; i < 1000; ++i) {
            service.submit(new Search("select * from [jnt:page] as page where isdescendantnode(page, 'path') and page.[jcr:created] < CAST(" + System.currentTimeMillis() + " as date) "), Boolean.TRUE);
        }
        for (i = 0; i < 1000; ++i) {
            Boolean bl = (Boolean)service.take().get();
        }
        stopWatch.stop();
        logger.error(stopWatch.prettyPrint());
        executor.shutdown();
    }

    private class SearchIteratorResults
    implements Runnable {
        StopWatch stopWatch;
        private JCRTemplate jcrTemplate;
        private String testQuery;

        public SearchIteratorResults(String s) {
            this.testQuery = s;
            this.stopWatch = new StopWatch("SearchIteratorResultsRunnable");
            this.jcrTemplate = JCRTemplate.getInstance();
        }

        @Override
        public void run() {
            try {
                this.stopWatch.start(Thread.currentThread().getName() + " searching node");
                this.jcrTemplate.doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

                    public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        SearchIteratorResults.this.testQuery = SearchIteratorResults.this.testQuery.replace("path", session.getNode(ConcurrentReadTest.SITECONTENT_ROOT_NODE).getPath());
                        QueryWrapper query = session.getWorkspace().getQueryManager().createQuery(SearchIteratorResults.this.testQuery, "JCR-SQL2");
                        QueryResult queryResult = query.execute();
                        if (queryResult.getNodes().getSize() == -1L) {
                            NodeIterator nodeIterator = queryResult.getNodes();
                            nodeIterator.nextNode();
                        }
                        return null;
                    }
                });
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private class Search
    implements Runnable {
        StopWatch stopWatch;
        private JCRTemplate jcrTemplate;
        private String testQuery;

        public Search(String s) {
            this.testQuery = s;
            this.stopWatch = new StopWatch("SearchRunnable");
            this.jcrTemplate = JCRTemplate.getInstance();
        }

        @Override
        public void run() {
            try {
                this.stopWatch.start(Thread.currentThread().getName() + " searching node");
                this.jcrTemplate.doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

                    public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        Search.this.testQuery = Search.this.testQuery.replace("path", session.getNode(ConcurrentReadTest.SITECONTENT_ROOT_NODE).getPath());
                        QueryWrapper query = session.getWorkspace().getQueryManager().createQuery(Search.this.testQuery, "JCR-SQL2");
                        query.execute();
                        return null;
                    }
                });
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private class Writer
    implements Runnable {
        private final Random random = new Random();
        StopWatch stopWatch = new StopWatch("WriterRunnable");
        private JCRTemplate jcrTemplate = JCRTemplate.getInstance();
        private String primaryNodeTypeName;

        public Writer(String primaryNodeTypeName) {
            this.primaryNodeTypeName = primaryNodeTypeName;
        }

        @Override
        public void run() {
            try {
                this.stopWatch.start(Thread.currentThread().getName() + " creating node");
                this.jcrTemplate.doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

                    public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        int i = Writer.this.random.nextInt(10);
                        int j = Writer.this.random.nextInt(10);
                        int k = Writer.this.random.nextInt(10);
                        JCRNodeWrapper node = session.getNode(ConcurrentReadTest.SITECONTENT_ROOT_NODE).getNode("child" + i).getNode("child" + j).getNode("child" + k);
                        node.addNode("child" + Writer.this.random.nextLong(), Writer.this.primaryNodeTypeName);
                        session.save();
                        return null;
                    }
                });
                this.stopWatch.stop();
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private class Reader
    implements Runnable {
        private final Random random = new Random();
        StopWatch stopWatch = new StopWatch("ReaderRunnable");
        private JCRTemplate jcrTemplate;

        public Reader() {
            this.stopWatch.start(Thread.currentThread().getName() + " reading node");
            this.jcrTemplate = JCRTemplate.getInstance();
        }

        @Override
        public void run() {
            try {
                this.jcrTemplate.doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

                    public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        int i = Reader.this.random.nextInt(10);
                        int j = Reader.this.random.nextInt(10);
                        int k = Reader.this.random.nextInt(10);
                        session.getNode(ConcurrentReadTest.SITECONTENT_ROOT_NODE).getNode("child" + i).getNode("child" + j).getNode("child" + k);
                        return null;
                    }
                });
                this.stopWatch.stop();
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

