/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.acl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.test.PerformanceTestUtils;
import org.junit.Before;
import org.junit.Test;

public class AclExtendedNodesPerformanceTest {
    private static final String USER_GROUP_PROVIDER = "ldap";
    private static final String USER_NAME = "user%s";
    private static final int NUM_USERS = 100;
    private static final String FOLDER_FILE_NAME = AclExtendedNodesPerformanceTest.class.getSimpleName() + "%s";
    private static final Pattern FOLDER_FILE_NAME_PATTERN = Pattern.compile(AclExtendedNodesPerformanceTest.class.getSimpleName() + "\\d+");
    private static final int USER_FOLDER_TREE_DEPTH = 3;
    private static final int NUM_USER_FOLDERS_PER_LEVEL = 2;
    private static final String FILE_CONTENT_TYPE = "text/plain";
    private static final String FILE_CONTENT = "Test file";
    private static final String FILE_ENCODING = "UTF-8";
    private static final int NUM_FILES_PER_FOLDER_SINGLE_USER = 10;
    private static final int NUM_ITERATIONS_TOUCHING_FILES_BY_SINGLE_USER = 50;
    private static final int NUM_FILES_TO_TOUCH_BY_SINGLE_USER = 20;
    private static final int NUM_FILES_TO_DOWNLOAD_BY_SINGLE_USER = 100;
    private static final int NUM_FILES_PER_FOLDER_MULTIPLE_USERS = 5;
    private static final int NUM_OWNER_USERS = 10;
    private static final int NUM_TOUCHING_USERS = 50;
    private static final int NUM_FILES_TO_TOUCH_PER_OWNER = 2;
    private static final int NUM_DOWNLOADER_USERS = 25;
    private static final int NUM_FILES_TO_DOWNLOAD_PER_DOWNLOADER_PER_OWNER = 2;
    private JahiaUserManagerService userManagerService;

    @Before
    public void setUp() throws Exception {
        this.userManagerService = ServicesRegistry.getInstance().getJahiaUserManagerService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCrdBySingleUser() throws Exception {
        LinkedList<Long> createFolderSamples = new LinkedList<Long>();
        LinkedList<Long> uploadFileSamples = new LinkedList<Long>();
        LinkedList<Long> touchFileSamplesDefault = new LinkedList<Long>();
        LinkedList<Long> downloadFileSamplesDefault = new LinkedList<Long>();
        LinkedList<Long> touchFileSamplesLive = new LinkedList<Long>();
        LinkedList<Long> downloadFileSamplesLive = new LinkedList<Long>();
        LinkedList<Long> listSamples = new LinkedList<Long>();
        LinkedList<Long> removeSamples = new LinkedList<Long>();
        JCRUserNode user = this.getUser(0);
        try {
            System.out.println("Creating folders/files by single user...");
            ArrayList<String> filePaths = new ArrayList<String>(this.createFoldersAndFiles(user, 10, createFolderSamples, uploadFileSamples));
            System.out.println("Accessing files by single user in default workspace...");
            this.touchRandomFiles("default", user, filePaths, touchFileSamplesDefault);
            System.out.println("Downloading files by single user from default workspace...");
            this.downloadRandomFiles("default", user, filePaths, downloadFileSamplesDefault);
            System.out.println("Accessing files by single user in live workspace...");
            this.touchRandomFiles("live", user, filePaths, touchFileSamplesLive);
            System.out.println("Downloading files by single user from live workspace...");
            this.downloadRandomFiles("live", user, filePaths, downloadFileSamplesLive);
        }
        finally {
            System.out.println("Removing folders/files by single user...");
            this.removeFoldersAndFiles(user, listSamples, removeSamples);
        }
        AclExtendedNodesPerformanceTest.printStatistics("Single user CRD test", new OperationInfo[]{new OperationInfo("Creating folders/files", createFolderSamples), new OperationInfo("Uploading files", uploadFileSamples), new OperationInfo("Accessing files (default)", touchFileSamplesDefault), new OperationInfo("Downloading files (default)", downloadFileSamplesDefault), new OperationInfo("Accessing files (live)", touchFileSamplesLive), new OperationInfo("Downloading files (live)", downloadFileSamplesLive), new OperationInfo("Listing sub-nodes", listSamples), new OperationInfo("Removing folders/files", removeSamples)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCrdByMultipleUsers() throws Exception {
        LinkedList<Long> createFolderSamples = new LinkedList<Long>();
        LinkedList<Long> uploadFileSamples = new LinkedList<Long>();
        LinkedList<Long> touchFileSamplesLive = new LinkedList<Long>();
        LinkedList<Long> downloadFileSamplesLive = new LinkedList<Long>();
        LinkedList<Long> listSamples = new LinkedList<Long>();
        LinkedList<Long> removeSamples = new LinkedList<Long>();
        try {
            System.out.println("Creating folders/files by multiple users...");
            ArrayListMultimap filePathsByOwner = ArrayListMultimap.create();
            for (int i = 0; i < 100; ++i) {
                JCRUserNode owner = this.getUser(i);
                ArrayList<String> filePaths = new ArrayList<String>(this.createFoldersAndFiles(owner, 5, createFolderSamples, uploadFileSamples));
                filePathsByOwner.putAll((Object)i, filePaths);
            }
            System.out.println("Accessing files by multiple users in live workspace...");
            this.touchRandomFilesByRandomUsers("live", (ListMultimap<Integer, String>)filePathsByOwner, touchFileSamplesLive);
            System.out.println("Downloading files by multiple users from live workspace...");
            this.downloadRandomFilesByRandomUsers("live", (ListMultimap<Integer, String>)filePathsByOwner, downloadFileSamplesLive);
        }
        finally {
            System.out.println("Removing folders/files by multiple users...");
            this.removeFoldersAndFiles(listSamples, removeSamples);
        }
        AclExtendedNodesPerformanceTest.printStatistics("Multiple users CRD test", new OperationInfo[]{new OperationInfo("Creating folders/files", createFolderSamples), new OperationInfo("Uploading files", uploadFileSamples), new OperationInfo("Accessing files (live)", touchFileSamplesLive), new OperationInfo("Downloading files (live)", downloadFileSamplesLive), new OperationInfo("Listing sub-nodes", listSamples), new OperationInfo("Removing folders/files", removeSamples)});
    }

    private JCRUserNode getUser(int index) {
        return this.getUser(String.format(USER_NAME, index));
    }

    private JCRUserNode getUser(String name) {
        JCRUserNode user = this.userManagerService.lookup(name);
        assert (user != null);
        assert (USER_GROUP_PROVIDER.equals(user.getPropertyAsString("j:externalSource")));
        return user;
    }

    private List<String> createFoldersAndFiles(JCRUserNode user, final int numFilesPerFolder, final Collection<Long> createFolderSamples, final Collection<Long> uploadFileSamples) {
        byte[] fileBytes;
        final LinkedList<String> filePaths = new LinkedList<String>();
        try {
            fileBytes = FILE_CONTENT.getBytes(FILE_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        final ByteArrayInputStream fileContentStream = new ByteArrayInputStream(fileBytes);
        try {
            JCRTemplate.getInstance().doExecute(user.getJahiaUser(), "default", Locale.ENGLISH, (JCRCallback)new JCRCallback<Void>(){

                public Void doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    AclExtendedNodesPerformanceTest.this.createFoldersAndFiles((JCRNodeWrapper)session.getUserNode(), 3, numFilesPerFolder, fileContentStream, filePaths, createFolderSamples, uploadFileSamples);
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        return filePaths;
    }

    private void createFoldersAndFiles(JCRNodeWrapper parent, int numLevelsToCreate, int numFilesPerFolder, InputStream fileContentStream, List<String> filePaths, Collection<Long> createFolderSamples, Collection<Long> uploadFileSamples) {
        int i;
        for (i = 0; i < numFilesPerFolder; ++i) {
            String fileName = String.format(FOLDER_FILE_NAME, System.currentTimeMillis());
            try {
                fileContentStream.reset();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                long start = System.currentTimeMillis();
                parent.uploadFile(fileName, fileContentStream, FILE_CONTENT_TYPE);
                parent.getSession().save();
                uploadFileSamples.add(System.currentTimeMillis() - start);
                filePaths.add(parent.getNode(fileName).getPath());
                continue;
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }
        if (numLevelsToCreate == 0) {
            return;
        }
        for (i = 0; i < 2; ++i) {
            JCRNodeWrapper folder;
            String folderName = String.format(FOLDER_FILE_NAME, System.currentTimeMillis());
            long start = System.currentTimeMillis();
            try {
                folder = parent.addNode(folderName, "jnt:folder");
                parent.getSession().save();
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
            createFolderSamples.add(System.currentTimeMillis() - start);
            this.createFoldersAndFiles(folder, numLevelsToCreate - 1, numFilesPerFolder, fileContentStream, filePaths, createFolderSamples, uploadFileSamples);
        }
    }

    private void touchRandomFiles(String workspace, JCRUserNode touchingUser, List<String> candidateFilePaths, Collection<Long> touchSamples) {
        Collection<String> filePathsToTouch = PerformanceTestUtils.getUniqueRandomElements(candidateFilePaths, 20);
        TouchFileProcessor fileTouching = new TouchFileProcessor();
        for (int i = 0; i < 50; ++i) {
            this.accessFiles(workspace, touchingUser, filePathsToTouch, touchSamples, fileTouching);
        }
    }

    private void touchRandomFilesByRandomUsers(final String workspace, ListMultimap<Integer, String> filePathsByOwner, final Collection<Long> touchSamples) {
        LinkedList filePathsToTouch = new LinkedList();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        final HashSet<Integer> ownersSeen = new HashSet<Integer>();
        int numOwners = 0;
        while (numOwners < 10) {
            int ownerIndex = ((Random)random).nextInt(100);
            if (ownersSeen.contains(ownerIndex)) continue;
            ownersSeen.add(ownerIndex);
            ++numOwners;
            List filePaths = filePathsByOwner.get((Object)ownerIndex);
            filePathsToTouch.addAll(PerformanceTestUtils.getUniqueRandomElements(filePaths, 2));
        }
        final ArrayList finalFilePathsToTouch = new ArrayList(filePathsToTouch);
        this.accessFilesByRandomUsers(workspace, 50, new UserRejector(){

            @Override
            public boolean isToBeRejected(int userIndex) {
                return ownersSeen.contains(userIndex);
            }
        }, new FilesAccessor(){

            @Override
            public void accessFilesByUser(int touchingIndex) {
                JCRUserNode touchingUser = AclExtendedNodesPerformanceTest.this.getUser(touchingIndex);
                AclExtendedNodesPerformanceTest.this.accessFiles(workspace, touchingUser, finalFilePathsToTouch, touchSamples, new TouchFileProcessor());
            }
        });
    }

    private void downloadRandomFiles(String workspace, JCRUserNode downloaderUser, List<String> candidateFilePaths, Collection<Long> downloadSamples) {
        Collection<String> filePathsToDownload = PerformanceTestUtils.getUniqueRandomElements(candidateFilePaths, 100);
        this.accessFiles(workspace, downloaderUser, filePathsToDownload, downloadSamples, new DownloadFileProcessor());
    }

    private void downloadRandomFilesByRandomUsers(final String workspace, final ListMultimap<Integer, String> filePathsByOwner, final Collection<Long> downloadSamples) {
        final DownloadFileProcessor fileDownloader = new DownloadFileProcessor();
        final HashSet filePathsSeen = new HashSet();
        this.accessFilesByRandomUsers(workspace, 25, null, new FilesAccessor(){

            @Override
            public void accessFilesByUser(int downloaderIndex) {
                JCRUserNode downloaderUser = AclExtendedNodesPerformanceTest.this.getUser(downloaderIndex);
                ThreadLocalRandom random = ThreadLocalRandom.current();
                HashSet<Integer> ownersSeen = new HashSet<Integer>();
                int numOwners = 0;
                while (numOwners < 10) {
                    int ownerIndex = ((Random)random).nextInt(100);
                    if (ownersSeen.contains(ownerIndex) || ownerIndex == downloaderIndex) continue;
                    ownersSeen.add(ownerIndex);
                    ++numOwners;
                    List filePaths = filePathsByOwner.get((Object)ownerIndex);
                    Collection<String> filePathsToDownload = PerformanceTestUtils.getUniqueRandomElements(filePaths, 2, new PerformanceTestUtils.ElementRejector<String>(){

                        @Override
                        public boolean isToBeRejected(String filePath) {
                            return filePathsSeen.contains(filePath);
                        }
                    });
                    filePathsSeen.addAll(filePathsToDownload);
                    AclExtendedNodesPerformanceTest.this.accessFiles(workspace, downloaderUser, filePathsToDownload, downloadSamples, fileDownloader);
                }
            }
        });
    }

    private void accessFilesByRandomUsers(String workspace, int numAccessorUsers, UserRejector userRejector, FilesAccessor fileAccessor) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        HashSet<Integer> accessorsSeen = new HashSet<Integer>();
        int numAccessors = 0;
        while (numAccessors < numAccessorUsers) {
            int accessorIndex = ((Random)random).nextInt(100);
            if (accessorsSeen.contains(accessorIndex) || userRejector != null && userRejector.isToBeRejected(accessorIndex)) continue;
            accessorsSeen.add(accessorIndex);
            ++numAccessors;
            fileAccessor.accessFilesByUser(accessorIndex);
        }
    }

    private void accessFiles(String workspace, JCRUserNode accessorUser, final Collection<String> filePaths, final Collection<Long> accessSamples, final NodeProcessor accessor) {
        try {
            JCRTemplate.getInstance().doExecute(accessorUser.getJahiaUser(), workspace, Locale.ENGLISH, (JCRCallback)new JCRCallback<Void>(){

                public Void doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    for (String filePath : filePaths) {
                        JCRNodeWrapper file = session.getNode(filePath);
                        long start = System.currentTimeMillis();
                        accessor.process(file);
                        accessSamples.add(System.currentTimeMillis() - start);
                    }
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    private void removeFoldersAndFiles(Collection<Long> listSamples, Collection<Long> removeSamples) {
        for (int i = 0; i < 100; ++i) {
            JCRUserNode user = this.getUser(i);
            this.removeFoldersAndFiles(user, listSamples, removeSamples);
        }
    }

    private void removeFoldersAndFiles(JCRUserNode ownerUser, final Collection<Long> listSamples, final Collection<Long> removeSamples) {
        try {
            JCRTemplate.getInstance().doExecute(ownerUser.getJahiaUser(), "default", Locale.ENGLISH, (JCRCallback)new JCRCallback<Void>(){

                public Void doInJCR(final JCRSessionWrapper session) throws RepositoryException {
                    AclExtendedNodesPerformanceTest.this.processFoldersAndFiles((JCRNodeWrapper)session.getUserNode(), listSamples, new NodeProcessor(){

                        @Override
                        public void process(JCRNodeWrapper folderOrFile) {
                            long start = System.currentTimeMillis();
                            try {
                                folderOrFile.remove();
                                session.save();
                            }
                            catch (RepositoryException e) {
                                throw new RuntimeException(e);
                            }
                            removeSamples.add(System.currentTimeMillis() - start);
                        }
                    });
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    private void processFoldersAndFiles(JCRNodeWrapper scope, Collection<Long> listSamples, NodeProcessor nodeProcessor) {
        JCRNodeIteratorWrapper subNodes;
        long start = System.currentTimeMillis();
        try {
            subNodes = scope.getNodes();
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        listSamples.add(System.currentTimeMillis() - start);
        for (JCRNodeWrapper subNode : subNodes) {
            String subNodeName = subNode.getName();
            if (subNodeName == null || !FOLDER_FILE_NAME_PATTERN.matcher(subNodeName).matches()) continue;
            this.processFoldersAndFiles(subNode, listSamples, nodeProcessor);
            nodeProcessor.process(subNode);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void printStatistics(String title, OperationInfo[] operations) {
        void var6_13;
        void var6_11;
        System.out.println(title);
        Integer operationColumnWidth = null;
        for (OperationInfo operationInfo : operations) {
            String operationTitle = operationInfo.getTitle();
            if (operationColumnWidth != null && operationTitle.length() <= operationColumnWidth) continue;
            operationColumnWidth = operationTitle.length();
        }
        Integer valueColumnWidth = null;
        Measurement[] measurementArray = Measurement.values();
        int n = measurementArray.length;
        boolean bl = false;
        while (var6_11 < n) {
            Measurement measurement = measurementArray[var6_11];
            String columnTitle = measurement.getTitle();
            if (valueColumnWidth == null || columnTitle.length() > valueColumnWidth) {
                valueColumnWidth = columnTitle.length();
            }
            ++var6_11;
        }
        int tableWidth = 1 + operationColumnWidth + 1 + Measurement.values().length * (valueColumnWidth + 1);
        StringBuilder horizontalRule = new StringBuilder();
        boolean bl2 = false;
        while (var6_13 < tableWidth) {
            horizontalRule.append('-');
            ++var6_13;
        }
        System.out.println(horizontalRule);
        System.out.print('|');
        AclExtendedNodesPerformanceTest.printTableCellAdjustLeft("", operationColumnWidth);
        for (Measurement measurement : Measurement.values()) {
            AclExtendedNodesPerformanceTest.printTableCellAdjustRight(measurement.getTitle(), valueColumnWidth);
        }
        System.out.println();
        System.out.println(horizontalRule);
        for (OperationInfo operationInfo : operations) {
            PerformanceTestUtils.TimingStatistics statistics = PerformanceTestUtils.getTimingStatistics(operationInfo.getSamples());
            System.out.print('|');
            AclExtendedNodesPerformanceTest.printTableCellAdjustLeft(operationInfo.getTitle(), operationColumnWidth);
            for (Measurement measurement : Measurement.values()) {
                AclExtendedNodesPerformanceTest.printTableCellAdjustRight(Long.toString(measurement.extractValue(statistics)), valueColumnWidth);
            }
            System.out.println();
            System.out.println(horizontalRule);
        }
    }

    private static void printTableCellAdjustLeft(String content, int width) {
        System.out.print(content);
        AclExtendedNodesPerformanceTest.printSpace(width - content.length());
        System.out.print('|');
    }

    private static void printTableCellAdjustRight(String content, int width) {
        AclExtendedNodesPerformanceTest.printSpace(width - content.length());
        System.out.print(content);
        System.out.print('|');
    }

    private static void printSpace(int width) {
        StringBuilder space = new StringBuilder();
        for (int i = 0; i < width; ++i) {
            space.append(' ');
        }
        System.out.print(space);
    }

    private static class OperationInfo {
        private String title;
        private Collection<Long> samples;

        public OperationInfo(String title, Collection<Long> samples) {
            this.title = title;
            this.samples = samples;
        }

        public String getTitle() {
            return this.title;
        }

        public Collection<Long> getSamples() {
            return this.samples;
        }
    }

    private static interface NodeProcessor {
        public void process(JCRNodeWrapper var1);
    }

    private static interface FilesAccessor {
        public void accessFilesByUser(int var1);
    }

    private static interface UserRejector {
        public boolean isToBeRejected(int var1);
    }

    private static class DownloadFileProcessor
    implements NodeProcessor {
        private DownloadFileProcessor() {
        }

        @Override
        public void process(JCRNodeWrapper file) {
            file.getFileContent().downloadFile();
        }
    }

    private static class TouchFileProcessor
    implements NodeProcessor {
        private TouchFileProcessor() {
        }

        @Override
        public void process(JCRNodeWrapper file) {
            file.getDisplayableName();
            file.getUrl();
        }
    }

    private static enum Measurement {
        NUM_SAMPLES("samples"){

            @Override
            protected long extractValue(PerformanceTestUtils.TimingStatistics statistics) {
                return statistics.getNumSamples();
            }
        }
        ,
        MIN("min"){

            @Override
            protected long extractValue(PerformanceTestUtils.TimingStatistics statistics) {
                return statistics.getMin();
            }
        }
        ,
        MAX("max"){

            @Override
            protected long extractValue(PerformanceTestUtils.TimingStatistics statistics) {
                return statistics.getMax();
            }
        }
        ,
        AVG("avg"){

            @Override
            protected long extractValue(PerformanceTestUtils.TimingStatistics statistics) {
                return statistics.getAvg();
            }
        }
        ,
        PERCENTILE_50("50th pc"){

            @Override
            protected long extractValue(PerformanceTestUtils.TimingStatistics statistics) {
                return statistics.getPercentile(50);
            }
        }
        ,
        PERCENTILE_90("90th pc"){

            @Override
            protected long extractValue(PerformanceTestUtils.TimingStatistics statistics) {
                return statistics.getPercentile(90);
            }
        };

        private String title;

        private Measurement(String title) {
            this.title = title;
        }

        protected abstract long extractValue(PerformanceTestUtils.TimingStatistics var1);

        public String getTitle() {
            return this.title;
        }
    }
}

